/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok.definitions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ngrok.definitions.EventSource;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class EventSourceList {
    @JsonProperty(value="sources")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final List<EventSource> sources;
    @JsonProperty(value="uri")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final URI uri;

    @JsonCreator
    public EventSourceList(@JsonProperty(value="sources") List<EventSource> sources, @JsonProperty(value="uri") URI uri) {
        this.sources = sources != null ? sources : Collections.emptyList();
        this.uri = Objects.requireNonNull(uri, "uri is required");
    }

    public List<EventSource> getSources() {
        return this.sources;
    }

    public URI getUri() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventSourceList other = (EventSourceList)o;
        return this.sources.equals(other.sources) && this.uri.equals(other.uri);
    }

    public int hashCode() {
        return Objects.hash(this.sources, this.uri);
    }

    public String toString() {
        return "EventSourceList{sources='" + this.sources + "', uri='" + this.uri + "'}";
    }
}

