/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok.definitions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ngrok.definitions.EventDestination;
import com.ngrok.definitions.Pageable;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class EventDestinationList
implements Pageable {
    @JsonProperty(value="event_destinations")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final List<EventDestination> eventDestinations;
    @JsonProperty(value="uri")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final URI uri;
    @JsonProperty(value="next_page_uri")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Optional<URI> nextPageUri;

    @JsonCreator
    public EventDestinationList(@JsonProperty(value="event_destinations") List<EventDestination> eventDestinations, @JsonProperty(value="uri") URI uri, @JsonProperty(value="next_page_uri") Optional<URI> nextPageUri) {
        this.eventDestinations = eventDestinations != null ? eventDestinations : Collections.emptyList();
        this.uri = Objects.requireNonNull(uri, "uri is required");
        this.nextPageUri = nextPageUri != null ? nextPageUri : Optional.empty();
    }

    public List<EventDestination> getEventDestinations() {
        return this.eventDestinations;
    }

    public URI getUri() {
        return this.uri;
    }

    @Override
    public Optional<URI> getNextPageUri() {
        return this.nextPageUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventDestinationList other = (EventDestinationList)o;
        return this.eventDestinations.equals(other.eventDestinations) && this.uri.equals(other.uri) && this.nextPageUri.equals(other.nextPageUri);
    }

    public int hashCode() {
        return Objects.hash(this.eventDestinations, this.uri, this.nextPageUri);
    }

    public String toString() {
        return "EventDestinationList{eventDestinations='" + this.eventDestinations + "', uri='" + this.uri + "', nextPageUri='" + this.nextPageUri.map(Object::toString).orElse("(null)") + "'}";
    }
}

