/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok.definitions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class EndpointWebhookValidation {
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Optional<Boolean> enabled;
    @JsonProperty(value="provider")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String provider;
    @JsonProperty(value="secret")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String secret;

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonCreator
    private EndpointWebhookValidation(@JsonProperty(value="enabled") Optional<Boolean> enabled, @JsonProperty(value="provider") String provider, @JsonProperty(value="secret") String secret) {
        this.enabled = enabled != null ? enabled : Optional.empty();
        this.provider = Objects.requireNonNull(provider, "provider is required");
        this.secret = Objects.requireNonNull(secret, "secret is required");
    }

    public Optional<Boolean> getEnabled() {
        return this.enabled;
    }

    public String getProvider() {
        return this.provider;
    }

    public String getSecret() {
        return this.secret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EndpointWebhookValidation other = (EndpointWebhookValidation)o;
        return this.enabled.equals(other.enabled) && this.provider.equals(other.provider) && this.secret.equals(other.secret);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.provider, this.secret);
    }

    public String toString() {
        return "EndpointWebhookValidation{enabled='" + this.enabled.map(Object::toString).orElse("(null)") + "', provider='" + this.provider + "', secret='" + this.secret + "'}";
    }

    public static class Builder {
        private Optional<Boolean> enabled = Optional.empty();
        private Optional<String> provider = Optional.empty();
        private Optional<String> secret = Optional.empty();

        private Builder() {
        }

        public Builder enabled(boolean enabled) {
            this.enabled = Optional.of(Objects.requireNonNull(Boolean.valueOf(enabled), "enabled is required"));
            return this;
        }

        public Builder enabled(Optional<Boolean> enabled) {
            this.enabled = Objects.requireNonNull(enabled, "enabled is required");
            return this;
        }

        public Builder provider(String provider) {
            this.provider = Optional.of(Objects.requireNonNull(provider, "provider is required"));
            return this;
        }

        public Builder provider(Optional<String> provider) {
            this.provider = Objects.requireNonNull(provider, "provider is required");
            return this;
        }

        public Builder secret(String secret) {
            this.secret = Optional.of(Objects.requireNonNull(secret, "secret is required"));
            return this;
        }

        public Builder secret(Optional<String> secret) {
            this.secret = Objects.requireNonNull(secret, "secret is required");
            return this;
        }

        public EndpointWebhookValidation build() {
            return new EndpointWebhookValidation(this.enabled, this.provider.orElse(""), this.secret.orElse(""));
        }
    }
}

