/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok.definitions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class EndpointSamlMutate {
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Optional<Boolean> enabled;
    @JsonProperty(value="options_passthrough")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final boolean optionsPassthrough;
    @JsonProperty(value="cookie_prefix")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String cookiePrefix;
    @JsonProperty(value="inactivity_timeout")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final long inactivityTimeout;
    @JsonProperty(value="maximum_duration")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Duration maximumDuration;
    @JsonProperty(value="idp_metadata")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String idpMetadata;
    @JsonProperty(value="force_authn")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final boolean forceAuthn;
    @JsonProperty(value="allow_idp_initiated")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Optional<Boolean> allowIdpInitiated;
    @JsonProperty(value="authorized_groups")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final List<String> authorizedGroups;
    @JsonProperty(value="nameid_format")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String nameidFormat;

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonCreator
    private EndpointSamlMutate(@JsonProperty(value="enabled") Optional<Boolean> enabled, @JsonProperty(value="options_passthrough") Boolean optionsPassthrough, @JsonProperty(value="cookie_prefix") String cookiePrefix, @JsonProperty(value="inactivity_timeout") Long inactivityTimeout, @JsonProperty(value="maximum_duration") Duration maximumDuration, @JsonProperty(value="idp_metadata") String idpMetadata, @JsonProperty(value="force_authn") Boolean forceAuthn, @JsonProperty(value="allow_idp_initiated") Optional<Boolean> allowIdpInitiated, @JsonProperty(value="authorized_groups") List<String> authorizedGroups, @JsonProperty(value="nameid_format") String nameidFormat) {
        this.enabled = enabled != null ? enabled : Optional.empty();
        this.optionsPassthrough = Objects.requireNonNull(optionsPassthrough, "optionsPassthrough is required");
        this.cookiePrefix = Objects.requireNonNull(cookiePrefix, "cookiePrefix is required");
        this.inactivityTimeout = Objects.requireNonNull(inactivityTimeout, "inactivityTimeout is required");
        this.maximumDuration = Objects.requireNonNull(maximumDuration, "maximumDuration is required");
        this.idpMetadata = Objects.requireNonNull(idpMetadata, "idpMetadata is required");
        this.forceAuthn = Objects.requireNonNull(forceAuthn, "forceAuthn is required");
        this.allowIdpInitiated = allowIdpInitiated != null ? allowIdpInitiated : Optional.empty();
        this.authorizedGroups = authorizedGroups != null ? authorizedGroups : Collections.emptyList();
        this.nameidFormat = Objects.requireNonNull(nameidFormat, "nameidFormat is required");
    }

    public Optional<Boolean> getEnabled() {
        return this.enabled;
    }

    public boolean getOptionsPassthrough() {
        return this.optionsPassthrough;
    }

    public String getCookiePrefix() {
        return this.cookiePrefix;
    }

    public long getInactivityTimeout() {
        return this.inactivityTimeout;
    }

    public Duration getMaximumDuration() {
        return this.maximumDuration;
    }

    public String getIdpMetadata() {
        return this.idpMetadata;
    }

    public boolean getForceAuthn() {
        return this.forceAuthn;
    }

    public Optional<Boolean> getAllowIdpInitiated() {
        return this.allowIdpInitiated;
    }

    public List<String> getAuthorizedGroups() {
        return this.authorizedGroups;
    }

    public String getNameidFormat() {
        return this.nameidFormat;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EndpointSamlMutate other = (EndpointSamlMutate)o;
        return this.enabled.equals(other.enabled) && this.optionsPassthrough == other.optionsPassthrough && this.cookiePrefix.equals(other.cookiePrefix) && this.inactivityTimeout == other.inactivityTimeout && this.maximumDuration == other.maximumDuration && this.idpMetadata.equals(other.idpMetadata) && this.forceAuthn == other.forceAuthn && this.allowIdpInitiated.equals(other.allowIdpInitiated) && this.authorizedGroups.equals(other.authorizedGroups) && this.nameidFormat.equals(other.nameidFormat);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.optionsPassthrough, this.cookiePrefix, this.inactivityTimeout, this.maximumDuration, this.idpMetadata, this.forceAuthn, this.allowIdpInitiated, this.authorizedGroups, this.nameidFormat);
    }

    public String toString() {
        return "EndpointSamlMutate{enabled='" + this.enabled.map(Object::toString).orElse("(null)") + "', optionsPassthrough='" + this.optionsPassthrough + "', cookiePrefix='" + this.cookiePrefix + "', inactivityTimeout='" + this.inactivityTimeout + "', maximumDuration='" + this.maximumDuration + "', idpMetadata='" + this.idpMetadata + "', forceAuthn='" + this.forceAuthn + "', allowIdpInitiated='" + this.allowIdpInitiated.map(Object::toString).orElse("(null)") + "', authorizedGroups='" + this.authorizedGroups + "', nameidFormat='" + this.nameidFormat + "'}";
    }

    public static class Builder {
        private Optional<Boolean> enabled = Optional.empty();
        private Optional<Boolean> optionsPassthrough = Optional.empty();
        private Optional<String> cookiePrefix = Optional.empty();
        private Optional<Long> inactivityTimeout = Optional.empty();
        private Optional<Duration> maximumDuration = Optional.empty();
        private Optional<String> idpMetadata = Optional.empty();
        private Optional<Boolean> forceAuthn = Optional.empty();
        private Optional<Boolean> allowIdpInitiated = Optional.empty();
        private List<String> authorizedGroups = Collections.emptyList();
        private Optional<String> nameidFormat = Optional.empty();

        private Builder() {
        }

        public Builder enabled(boolean enabled) {
            this.enabled = Optional.of(Objects.requireNonNull(Boolean.valueOf(enabled), "enabled is required"));
            return this;
        }

        public Builder enabled(Optional<Boolean> enabled) {
            this.enabled = Objects.requireNonNull(enabled, "enabled is required");
            return this;
        }

        public Builder optionsPassthrough(boolean optionsPassthrough) {
            this.optionsPassthrough = Optional.of(Objects.requireNonNull(Boolean.valueOf(optionsPassthrough), "optionsPassthrough is required"));
            return this;
        }

        public Builder optionsPassthrough(Optional<Boolean> optionsPassthrough) {
            this.optionsPassthrough = Objects.requireNonNull(optionsPassthrough, "optionsPassthrough is required");
            return this;
        }

        public Builder cookiePrefix(String cookiePrefix) {
            this.cookiePrefix = Optional.of(Objects.requireNonNull(cookiePrefix, "cookiePrefix is required"));
            return this;
        }

        public Builder cookiePrefix(Optional<String> cookiePrefix) {
            this.cookiePrefix = Objects.requireNonNull(cookiePrefix, "cookiePrefix is required");
            return this;
        }

        public Builder inactivityTimeout(long inactivityTimeout) {
            this.inactivityTimeout = Optional.of(Objects.requireNonNull(Long.valueOf(inactivityTimeout), "inactivityTimeout is required"));
            return this;
        }

        public Builder inactivityTimeout(Optional<Long> inactivityTimeout) {
            this.inactivityTimeout = Objects.requireNonNull(inactivityTimeout, "inactivityTimeout is required");
            return this;
        }

        public Builder maximumDuration(Duration maximumDuration) {
            this.maximumDuration = Optional.of(Objects.requireNonNull(maximumDuration, "maximumDuration is required"));
            return this;
        }

        public Builder maximumDuration(Optional<Duration> maximumDuration) {
            this.maximumDuration = Objects.requireNonNull(maximumDuration, "maximumDuration is required");
            return this;
        }

        public Builder idpMetadata(String idpMetadata) {
            this.idpMetadata = Optional.of(Objects.requireNonNull(idpMetadata, "idpMetadata is required"));
            return this;
        }

        public Builder idpMetadata(Optional<String> idpMetadata) {
            this.idpMetadata = Objects.requireNonNull(idpMetadata, "idpMetadata is required");
            return this;
        }

        public Builder forceAuthn(boolean forceAuthn) {
            this.forceAuthn = Optional.of(Objects.requireNonNull(Boolean.valueOf(forceAuthn), "forceAuthn is required"));
            return this;
        }

        public Builder forceAuthn(Optional<Boolean> forceAuthn) {
            this.forceAuthn = Objects.requireNonNull(forceAuthn, "forceAuthn is required");
            return this;
        }

        public Builder allowIdpInitiated(boolean allowIdpInitiated) {
            this.allowIdpInitiated = Optional.of(Objects.requireNonNull(Boolean.valueOf(allowIdpInitiated), "allowIdpInitiated is required"));
            return this;
        }

        public Builder allowIdpInitiated(Optional<Boolean> allowIdpInitiated) {
            this.allowIdpInitiated = Objects.requireNonNull(allowIdpInitiated, "allowIdpInitiated is required");
            return this;
        }

        public Builder authorizedGroups(List<String> authorizedGroups) {
            this.authorizedGroups = Objects.requireNonNull(authorizedGroups, "authorizedGroups is required");
            return this;
        }

        public Builder authorizedGroups(Optional<List<String>> authorizedGroups) {
            this.authorizedGroups = Objects.requireNonNull(authorizedGroups, "authorizedGroups is required").orElse(Collections.emptyList());
            return this;
        }

        public Builder nameidFormat(String nameidFormat) {
            this.nameidFormat = Optional.of(Objects.requireNonNull(nameidFormat, "nameidFormat is required"));
            return this;
        }

        public Builder nameidFormat(Optional<String> nameidFormat) {
            this.nameidFormat = Objects.requireNonNull(nameidFormat, "nameidFormat is required");
            return this;
        }

        public EndpointSamlMutate build() {
            return new EndpointSamlMutate(this.enabled, this.optionsPassthrough.orElse(false), this.cookiePrefix.orElse(""), this.inactivityTimeout.orElse(0L), this.maximumDuration.orElse(Duration.ZERO), this.idpMetadata.orElse(""), this.forceAuthn.orElse(false), this.allowIdpInitiated, this.authorizedGroups, this.nameidFormat.orElse(""));
        }
    }
}

