/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok.definitions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URI;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class EndpointSaml {
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Optional<Boolean> enabled;
    @JsonProperty(value="options_passthrough")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final boolean optionsPassthrough;
    @JsonProperty(value="cookie_prefix")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String cookiePrefix;
    @JsonProperty(value="inactivity_timeout")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final long inactivityTimeout;
    @JsonProperty(value="maximum_duration")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Duration maximumDuration;
    @JsonProperty(value="idp_metadata")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String idpMetadata;
    @JsonProperty(value="force_authn")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final boolean forceAuthn;
    @JsonProperty(value="allow_idp_initiated")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Optional<Boolean> allowIdpInitiated;
    @JsonProperty(value="authorized_groups")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final List<String> authorizedGroups;
    @JsonProperty(value="entity_id")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String entityId;
    @JsonProperty(value="assertion_consumer_service_url")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final URI assertionConsumerServiceUrl;
    @JsonProperty(value="single_logout_url")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final URI singleLogoutUrl;
    @JsonProperty(value="request_signing_certificate_pem")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String requestSigningCertificatePem;
    @JsonProperty(value="metadata_url")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final URI metadataUrl;
    @JsonProperty(value="nameid_format")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String nameidFormat;

    @JsonCreator
    public EndpointSaml(@JsonProperty(value="enabled") Optional<Boolean> enabled, @JsonProperty(value="options_passthrough") Boolean optionsPassthrough, @JsonProperty(value="cookie_prefix") String cookiePrefix, @JsonProperty(value="inactivity_timeout") Long inactivityTimeout, @JsonProperty(value="maximum_duration") Duration maximumDuration, @JsonProperty(value="idp_metadata") String idpMetadata, @JsonProperty(value="force_authn") Boolean forceAuthn, @JsonProperty(value="allow_idp_initiated") Optional<Boolean> allowIdpInitiated, @JsonProperty(value="authorized_groups") List<String> authorizedGroups, @JsonProperty(value="entity_id") String entityId, @JsonProperty(value="assertion_consumer_service_url") URI assertionConsumerServiceUrl, @JsonProperty(value="single_logout_url") URI singleLogoutUrl, @JsonProperty(value="request_signing_certificate_pem") String requestSigningCertificatePem, @JsonProperty(value="metadata_url") URI metadataUrl, @JsonProperty(value="nameid_format") String nameidFormat) {
        this.enabled = enabled != null ? enabled : Optional.empty();
        this.optionsPassthrough = Objects.requireNonNull(optionsPassthrough, "optionsPassthrough is required");
        this.cookiePrefix = Objects.requireNonNull(cookiePrefix, "cookiePrefix is required");
        this.inactivityTimeout = Objects.requireNonNull(inactivityTimeout, "inactivityTimeout is required");
        this.maximumDuration = Objects.requireNonNull(maximumDuration, "maximumDuration is required");
        this.idpMetadata = Objects.requireNonNull(idpMetadata, "idpMetadata is required");
        this.forceAuthn = Objects.requireNonNull(forceAuthn, "forceAuthn is required");
        this.allowIdpInitiated = allowIdpInitiated != null ? allowIdpInitiated : Optional.empty();
        this.authorizedGroups = authorizedGroups != null ? authorizedGroups : Collections.emptyList();
        this.entityId = Objects.requireNonNull(entityId, "entityId is required");
        this.assertionConsumerServiceUrl = Objects.requireNonNull(assertionConsumerServiceUrl, "assertionConsumerServiceUrl is required");
        this.singleLogoutUrl = Objects.requireNonNull(singleLogoutUrl, "singleLogoutUrl is required");
        this.requestSigningCertificatePem = Objects.requireNonNull(requestSigningCertificatePem, "requestSigningCertificatePem is required");
        this.metadataUrl = Objects.requireNonNull(metadataUrl, "metadataUrl is required");
        this.nameidFormat = Objects.requireNonNull(nameidFormat, "nameidFormat is required");
    }

    public Optional<Boolean> getEnabled() {
        return this.enabled;
    }

    public boolean getOptionsPassthrough() {
        return this.optionsPassthrough;
    }

    public String getCookiePrefix() {
        return this.cookiePrefix;
    }

    public long getInactivityTimeout() {
        return this.inactivityTimeout;
    }

    public Duration getMaximumDuration() {
        return this.maximumDuration;
    }

    public String getIdpMetadata() {
        return this.idpMetadata;
    }

    public boolean getForceAuthn() {
        return this.forceAuthn;
    }

    public Optional<Boolean> getAllowIdpInitiated() {
        return this.allowIdpInitiated;
    }

    public List<String> getAuthorizedGroups() {
        return this.authorizedGroups;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public URI getAssertionConsumerServiceUrl() {
        return this.assertionConsumerServiceUrl;
    }

    public URI getSingleLogoutUrl() {
        return this.singleLogoutUrl;
    }

    public String getRequestSigningCertificatePem() {
        return this.requestSigningCertificatePem;
    }

    public URI getMetadataUrl() {
        return this.metadataUrl;
    }

    public String getNameidFormat() {
        return this.nameidFormat;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EndpointSaml other = (EndpointSaml)o;
        return this.enabled.equals(other.enabled) && this.optionsPassthrough == other.optionsPassthrough && this.cookiePrefix.equals(other.cookiePrefix) && this.inactivityTimeout == other.inactivityTimeout && this.maximumDuration == other.maximumDuration && this.idpMetadata.equals(other.idpMetadata) && this.forceAuthn == other.forceAuthn && this.allowIdpInitiated.equals(other.allowIdpInitiated) && this.authorizedGroups.equals(other.authorizedGroups) && this.entityId.equals(other.entityId) && this.assertionConsumerServiceUrl.equals(other.assertionConsumerServiceUrl) && this.singleLogoutUrl.equals(other.singleLogoutUrl) && this.requestSigningCertificatePem.equals(other.requestSigningCertificatePem) && this.metadataUrl.equals(other.metadataUrl) && this.nameidFormat.equals(other.nameidFormat);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.optionsPassthrough, this.cookiePrefix, this.inactivityTimeout, this.maximumDuration, this.idpMetadata, this.forceAuthn, this.allowIdpInitiated, this.authorizedGroups, this.entityId, this.assertionConsumerServiceUrl, this.singleLogoutUrl, this.requestSigningCertificatePem, this.metadataUrl, this.nameidFormat);
    }

    public String toString() {
        return "EndpointSaml{enabled='" + this.enabled.map(Object::toString).orElse("(null)") + "', optionsPassthrough='" + this.optionsPassthrough + "', cookiePrefix='" + this.cookiePrefix + "', inactivityTimeout='" + this.inactivityTimeout + "', maximumDuration='" + this.maximumDuration + "', idpMetadata='" + this.idpMetadata + "', forceAuthn='" + this.forceAuthn + "', allowIdpInitiated='" + this.allowIdpInitiated.map(Object::toString).orElse("(null)") + "', authorizedGroups='" + this.authorizedGroups + "', entityId='" + this.entityId + "', assertionConsumerServiceUrl='" + this.assertionConsumerServiceUrl + "', singleLogoutUrl='" + this.singleLogoutUrl + "', requestSigningCertificatePem='" + this.requestSigningCertificatePem + "', metadataUrl='" + this.metadataUrl + "', nameidFormat='" + this.nameidFormat + "'}";
    }
}

