/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok.definitions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class EndpointRequestHeaders {
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Optional<Boolean> enabled;
    @JsonProperty(value="add")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Map<String, String> add;
    @JsonProperty(value="remove")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final List<String> remove;

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonCreator
    private EndpointRequestHeaders(@JsonProperty(value="enabled") Optional<Boolean> enabled, @JsonProperty(value="add") Map<String, String> add, @JsonProperty(value="remove") List<String> remove) {
        this.enabled = enabled != null ? enabled : Optional.empty();
        this.add = add != null ? add : Collections.emptyMap();
        this.remove = remove != null ? remove : Collections.emptyList();
    }

    public Optional<Boolean> getEnabled() {
        return this.enabled;
    }

    public Map<String, String> getAdd() {
        return this.add;
    }

    public List<String> getRemove() {
        return this.remove;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EndpointRequestHeaders other = (EndpointRequestHeaders)o;
        return this.enabled.equals(other.enabled) && this.add.equals(other.add) && this.remove.equals(other.remove);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.add, this.remove);
    }

    public String toString() {
        return "EndpointRequestHeaders{enabled='" + this.enabled.map(Object::toString).orElse("(null)") + "', add='" + this.add + "', remove='" + this.remove + "'}";
    }

    public static class Builder {
        private Optional<Boolean> enabled = Optional.empty();
        private Map<String, String> add = Collections.emptyMap();
        private List<String> remove = Collections.emptyList();

        private Builder() {
        }

        public Builder enabled(boolean enabled) {
            this.enabled = Optional.of(Objects.requireNonNull(Boolean.valueOf(enabled), "enabled is required"));
            return this;
        }

        public Builder enabled(Optional<Boolean> enabled) {
            this.enabled = Objects.requireNonNull(enabled, "enabled is required");
            return this;
        }

        public Builder add(Map<String, String> add) {
            this.add = Objects.requireNonNull(add, "add is required");
            return this;
        }

        public Builder add(Optional<Map<String, String>> add) {
            this.add = Objects.requireNonNull(add, "add is required").orElse(Collections.emptyMap());
            return this;
        }

        public Builder remove(List<String> remove) {
            this.remove = Objects.requireNonNull(remove, "remove is required");
            return this;
        }

        public Builder remove(Optional<List<String>> remove) {
            this.remove = Objects.requireNonNull(remove, "remove is required").orElse(Collections.emptyList());
            return this;
        }

        public EndpointRequestHeaders build() {
            return new EndpointRequestHeaders(this.enabled, this.add, this.remove);
        }
    }
}

