/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok.definitions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class EndpointOidc {
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Optional<Boolean> enabled;
    @JsonProperty(value="options_passthrough")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final boolean optionsPassthrough;
    @JsonProperty(value="cookie_prefix")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String cookiePrefix;
    @JsonProperty(value="inactivity_timeout")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final long inactivityTimeout;
    @JsonProperty(value="maximum_duration")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Duration maximumDuration;
    @JsonProperty(value="issuer")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String issuer;
    @JsonProperty(value="client_id")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String clientId;
    @JsonProperty(value="client_secret")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String clientSecret;
    @JsonProperty(value="scopes")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final List<String> scopes;

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonCreator
    private EndpointOidc(@JsonProperty(value="enabled") Optional<Boolean> enabled, @JsonProperty(value="options_passthrough") Boolean optionsPassthrough, @JsonProperty(value="cookie_prefix") String cookiePrefix, @JsonProperty(value="inactivity_timeout") Long inactivityTimeout, @JsonProperty(value="maximum_duration") Duration maximumDuration, @JsonProperty(value="issuer") String issuer, @JsonProperty(value="client_id") String clientId, @JsonProperty(value="client_secret") String clientSecret, @JsonProperty(value="scopes") List<String> scopes) {
        this.enabled = enabled != null ? enabled : Optional.empty();
        this.optionsPassthrough = Objects.requireNonNull(optionsPassthrough, "optionsPassthrough is required");
        this.cookiePrefix = Objects.requireNonNull(cookiePrefix, "cookiePrefix is required");
        this.inactivityTimeout = Objects.requireNonNull(inactivityTimeout, "inactivityTimeout is required");
        this.maximumDuration = Objects.requireNonNull(maximumDuration, "maximumDuration is required");
        this.issuer = Objects.requireNonNull(issuer, "issuer is required");
        this.clientId = Objects.requireNonNull(clientId, "clientId is required");
        this.clientSecret = Objects.requireNonNull(clientSecret, "clientSecret is required");
        this.scopes = scopes != null ? scopes : Collections.emptyList();
    }

    public Optional<Boolean> getEnabled() {
        return this.enabled;
    }

    public boolean getOptionsPassthrough() {
        return this.optionsPassthrough;
    }

    public String getCookiePrefix() {
        return this.cookiePrefix;
    }

    public long getInactivityTimeout() {
        return this.inactivityTimeout;
    }

    public Duration getMaximumDuration() {
        return this.maximumDuration;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EndpointOidc other = (EndpointOidc)o;
        return this.enabled.equals(other.enabled) && this.optionsPassthrough == other.optionsPassthrough && this.cookiePrefix.equals(other.cookiePrefix) && this.inactivityTimeout == other.inactivityTimeout && this.maximumDuration == other.maximumDuration && this.issuer.equals(other.issuer) && this.clientId.equals(other.clientId) && this.clientSecret.equals(other.clientSecret) && this.scopes.equals(other.scopes);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.optionsPassthrough, this.cookiePrefix, this.inactivityTimeout, this.maximumDuration, this.issuer, this.clientId, this.clientSecret, this.scopes);
    }

    public String toString() {
        return "EndpointOidc{enabled='" + this.enabled.map(Object::toString).orElse("(null)") + "', optionsPassthrough='" + this.optionsPassthrough + "', cookiePrefix='" + this.cookiePrefix + "', inactivityTimeout='" + this.inactivityTimeout + "', maximumDuration='" + this.maximumDuration + "', issuer='" + this.issuer + "', clientId='" + this.clientId + "', clientSecret='" + this.clientSecret + "', scopes='" + this.scopes + "'}";
    }

    public static class Builder {
        private Optional<Boolean> enabled = Optional.empty();
        private Optional<Boolean> optionsPassthrough = Optional.empty();
        private Optional<String> cookiePrefix = Optional.empty();
        private Optional<Long> inactivityTimeout = Optional.empty();
        private Optional<Duration> maximumDuration = Optional.empty();
        private Optional<String> issuer = Optional.empty();
        private Optional<String> clientId = Optional.empty();
        private Optional<String> clientSecret = Optional.empty();
        private List<String> scopes = Collections.emptyList();

        private Builder() {
        }

        public Builder enabled(boolean enabled) {
            this.enabled = Optional.of(Objects.requireNonNull(Boolean.valueOf(enabled), "enabled is required"));
            return this;
        }

        public Builder enabled(Optional<Boolean> enabled) {
            this.enabled = Objects.requireNonNull(enabled, "enabled is required");
            return this;
        }

        public Builder optionsPassthrough(boolean optionsPassthrough) {
            this.optionsPassthrough = Optional.of(Objects.requireNonNull(Boolean.valueOf(optionsPassthrough), "optionsPassthrough is required"));
            return this;
        }

        public Builder optionsPassthrough(Optional<Boolean> optionsPassthrough) {
            this.optionsPassthrough = Objects.requireNonNull(optionsPassthrough, "optionsPassthrough is required");
            return this;
        }

        public Builder cookiePrefix(String cookiePrefix) {
            this.cookiePrefix = Optional.of(Objects.requireNonNull(cookiePrefix, "cookiePrefix is required"));
            return this;
        }

        public Builder cookiePrefix(Optional<String> cookiePrefix) {
            this.cookiePrefix = Objects.requireNonNull(cookiePrefix, "cookiePrefix is required");
            return this;
        }

        public Builder inactivityTimeout(long inactivityTimeout) {
            this.inactivityTimeout = Optional.of(Objects.requireNonNull(Long.valueOf(inactivityTimeout), "inactivityTimeout is required"));
            return this;
        }

        public Builder inactivityTimeout(Optional<Long> inactivityTimeout) {
            this.inactivityTimeout = Objects.requireNonNull(inactivityTimeout, "inactivityTimeout is required");
            return this;
        }

        public Builder maximumDuration(Duration maximumDuration) {
            this.maximumDuration = Optional.of(Objects.requireNonNull(maximumDuration, "maximumDuration is required"));
            return this;
        }

        public Builder maximumDuration(Optional<Duration> maximumDuration) {
            this.maximumDuration = Objects.requireNonNull(maximumDuration, "maximumDuration is required");
            return this;
        }

        public Builder issuer(String issuer) {
            this.issuer = Optional.of(Objects.requireNonNull(issuer, "issuer is required"));
            return this;
        }

        public Builder issuer(Optional<String> issuer) {
            this.issuer = Objects.requireNonNull(issuer, "issuer is required");
            return this;
        }

        public Builder clientId(String clientId) {
            this.clientId = Optional.of(Objects.requireNonNull(clientId, "clientId is required"));
            return this;
        }

        public Builder clientId(Optional<String> clientId) {
            this.clientId = Objects.requireNonNull(clientId, "clientId is required");
            return this;
        }

        public Builder clientSecret(String clientSecret) {
            this.clientSecret = Optional.of(Objects.requireNonNull(clientSecret, "clientSecret is required"));
            return this;
        }

        public Builder clientSecret(Optional<String> clientSecret) {
            this.clientSecret = Objects.requireNonNull(clientSecret, "clientSecret is required");
            return this;
        }

        public Builder scopes(List<String> scopes) {
            this.scopes = Objects.requireNonNull(scopes, "scopes is required");
            return this;
        }

        public Builder scopes(Optional<List<String>> scopes) {
            this.scopes = Objects.requireNonNull(scopes, "scopes is required").orElse(Collections.emptyList());
            return this;
        }

        public EndpointOidc build() {
            return new EndpointOidc(this.enabled, this.optionsPassthrough.orElse(false), this.cookiePrefix.orElse(""), this.inactivityTimeout.orElse(0L), this.maximumDuration.orElse(Duration.ZERO), this.issuer.orElse(""), this.clientId.orElse(""), this.clientSecret.orElse(""), this.scopes);
        }
    }
}

