/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok.definitions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ngrok.definitions.EndpointOAuthFacebook;
import com.ngrok.definitions.EndpointOAuthGitHub;
import com.ngrok.definitions.EndpointOAuthGoogle;
import com.ngrok.definitions.EndpointOAuthMicrosoft;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class EndpointOAuthProvider {
    @JsonProperty(value="github")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Optional<EndpointOAuthGitHub> github;
    @JsonProperty(value="facebook")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Optional<EndpointOAuthFacebook> facebook;
    @JsonProperty(value="microsoft")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Optional<EndpointOAuthMicrosoft> microsoft;
    @JsonProperty(value="google")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Optional<EndpointOAuthGoogle> google;

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonCreator
    private EndpointOAuthProvider(@JsonProperty(value="github") Optional<EndpointOAuthGitHub> github, @JsonProperty(value="facebook") Optional<EndpointOAuthFacebook> facebook, @JsonProperty(value="microsoft") Optional<EndpointOAuthMicrosoft> microsoft, @JsonProperty(value="google") Optional<EndpointOAuthGoogle> google) {
        this.github = github != null ? github : Optional.empty();
        this.facebook = facebook != null ? facebook : Optional.empty();
        this.microsoft = microsoft != null ? microsoft : Optional.empty();
        this.google = google != null ? google : Optional.empty();
    }

    public Optional<EndpointOAuthGitHub> getGithub() {
        return this.github;
    }

    public Optional<EndpointOAuthFacebook> getFacebook() {
        return this.facebook;
    }

    public Optional<EndpointOAuthMicrosoft> getMicrosoft() {
        return this.microsoft;
    }

    public Optional<EndpointOAuthGoogle> getGoogle() {
        return this.google;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EndpointOAuthProvider other = (EndpointOAuthProvider)o;
        return this.github.equals(other.github) && this.facebook.equals(other.facebook) && this.microsoft.equals(other.microsoft) && this.google.equals(other.google);
    }

    public int hashCode() {
        return Objects.hash(this.github, this.facebook, this.microsoft, this.google);
    }

    public String toString() {
        return "EndpointOAuthProvider{github='" + this.github.map(Object::toString).orElse("(null)") + "', facebook='" + this.facebook.map(Object::toString).orElse("(null)") + "', microsoft='" + this.microsoft.map(Object::toString).orElse("(null)") + "', google='" + this.google.map(Object::toString).orElse("(null)") + "'}";
    }

    public static class Builder {
        private Optional<EndpointOAuthGitHub> github = Optional.empty();
        private Optional<EndpointOAuthFacebook> facebook = Optional.empty();
        private Optional<EndpointOAuthMicrosoft> microsoft = Optional.empty();
        private Optional<EndpointOAuthGoogle> google = Optional.empty();

        private Builder() {
        }

        public Builder github(EndpointOAuthGitHub github) {
            this.github = Optional.of(Objects.requireNonNull(github, "github is required"));
            return this;
        }

        public Builder github(Optional<EndpointOAuthGitHub> github) {
            this.github = Objects.requireNonNull(github, "github is required");
            return this;
        }

        public Builder facebook(EndpointOAuthFacebook facebook) {
            this.facebook = Optional.of(Objects.requireNonNull(facebook, "facebook is required"));
            return this;
        }

        public Builder facebook(Optional<EndpointOAuthFacebook> facebook) {
            this.facebook = Objects.requireNonNull(facebook, "facebook is required");
            return this;
        }

        public Builder microsoft(EndpointOAuthMicrosoft microsoft) {
            this.microsoft = Optional.of(Objects.requireNonNull(microsoft, "microsoft is required"));
            return this;
        }

        public Builder microsoft(Optional<EndpointOAuthMicrosoft> microsoft) {
            this.microsoft = Objects.requireNonNull(microsoft, "microsoft is required");
            return this;
        }

        public Builder google(EndpointOAuthGoogle google) {
            this.google = Optional.of(Objects.requireNonNull(google, "google is required"));
            return this;
        }

        public Builder google(Optional<EndpointOAuthGoogle> google) {
            this.google = Objects.requireNonNull(google, "google is required");
            return this;
        }

        public EndpointOAuthProvider build() {
            return new EndpointOAuthProvider(this.github, this.facebook, this.microsoft, this.google);
        }
    }
}

