/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok.definitions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class EndpointOAuthGitHub {
    @JsonProperty(value="client_id")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Optional<String> clientId;
    @JsonProperty(value="client_secret")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Optional<String> clientSecret;
    @JsonProperty(value="scopes")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final List<String> scopes;
    @JsonProperty(value="email_addresses")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final List<String> emailAddresses;
    @JsonProperty(value="email_domains")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final List<String> emailDomains;
    @JsonProperty(value="teams")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final List<String> teams;
    @JsonProperty(value="organizations")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final List<String> organizations;

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonCreator
    private EndpointOAuthGitHub(@JsonProperty(value="client_id") Optional<String> clientId, @JsonProperty(value="client_secret") Optional<String> clientSecret, @JsonProperty(value="scopes") List<String> scopes, @JsonProperty(value="email_addresses") List<String> emailAddresses, @JsonProperty(value="email_domains") List<String> emailDomains, @JsonProperty(value="teams") List<String> teams, @JsonProperty(value="organizations") List<String> organizations) {
        this.clientId = clientId != null ? clientId : Optional.empty();
        this.clientSecret = clientSecret != null ? clientSecret : Optional.empty();
        this.scopes = scopes != null ? scopes : Collections.emptyList();
        this.emailAddresses = emailAddresses != null ? emailAddresses : Collections.emptyList();
        this.emailDomains = emailDomains != null ? emailDomains : Collections.emptyList();
        this.teams = teams != null ? teams : Collections.emptyList();
        this.organizations = organizations != null ? organizations : Collections.emptyList();
    }

    public Optional<String> getClientId() {
        return this.clientId;
    }

    public Optional<String> getClientSecret() {
        return this.clientSecret;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public List<String> getEmailAddresses() {
        return this.emailAddresses;
    }

    public List<String> getEmailDomains() {
        return this.emailDomains;
    }

    public List<String> getTeams() {
        return this.teams;
    }

    public List<String> getOrganizations() {
        return this.organizations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EndpointOAuthGitHub other = (EndpointOAuthGitHub)o;
        return this.clientId.equals(other.clientId) && this.clientSecret.equals(other.clientSecret) && this.scopes.equals(other.scopes) && this.emailAddresses.equals(other.emailAddresses) && this.emailDomains.equals(other.emailDomains) && this.teams.equals(other.teams) && this.organizations.equals(other.organizations);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.clientSecret, this.scopes, this.emailAddresses, this.emailDomains, this.teams, this.organizations);
    }

    public String toString() {
        return "EndpointOAuthGitHub{clientId='" + this.clientId.orElse("(null)") + "', clientSecret='" + this.clientSecret.orElse("(null)") + "', scopes='" + this.scopes + "', emailAddresses='" + this.emailAddresses + "', emailDomains='" + this.emailDomains + "', teams='" + this.teams + "', organizations='" + this.organizations + "'}";
    }

    public static class Builder {
        private Optional<String> clientId = Optional.empty();
        private Optional<String> clientSecret = Optional.empty();
        private List<String> scopes = Collections.emptyList();
        private List<String> emailAddresses = Collections.emptyList();
        private List<String> emailDomains = Collections.emptyList();
        private List<String> teams = Collections.emptyList();
        private List<String> organizations = Collections.emptyList();

        private Builder() {
        }

        public Builder clientId(String clientId) {
            this.clientId = Optional.of(Objects.requireNonNull(clientId, "clientId is required"));
            return this;
        }

        public Builder clientId(Optional<String> clientId) {
            this.clientId = Objects.requireNonNull(clientId, "clientId is required");
            return this;
        }

        public Builder clientSecret(String clientSecret) {
            this.clientSecret = Optional.of(Objects.requireNonNull(clientSecret, "clientSecret is required"));
            return this;
        }

        public Builder clientSecret(Optional<String> clientSecret) {
            this.clientSecret = Objects.requireNonNull(clientSecret, "clientSecret is required");
            return this;
        }

        public Builder scopes(List<String> scopes) {
            this.scopes = Objects.requireNonNull(scopes, "scopes is required");
            return this;
        }

        public Builder scopes(Optional<List<String>> scopes) {
            this.scopes = Objects.requireNonNull(scopes, "scopes is required").orElse(Collections.emptyList());
            return this;
        }

        public Builder emailAddresses(List<String> emailAddresses) {
            this.emailAddresses = Objects.requireNonNull(emailAddresses, "emailAddresses is required");
            return this;
        }

        public Builder emailAddresses(Optional<List<String>> emailAddresses) {
            this.emailAddresses = Objects.requireNonNull(emailAddresses, "emailAddresses is required").orElse(Collections.emptyList());
            return this;
        }

        public Builder emailDomains(List<String> emailDomains) {
            this.emailDomains = Objects.requireNonNull(emailDomains, "emailDomains is required");
            return this;
        }

        public Builder emailDomains(Optional<List<String>> emailDomains) {
            this.emailDomains = Objects.requireNonNull(emailDomains, "emailDomains is required").orElse(Collections.emptyList());
            return this;
        }

        public Builder teams(List<String> teams) {
            this.teams = Objects.requireNonNull(teams, "teams is required");
            return this;
        }

        public Builder teams(Optional<List<String>> teams) {
            this.teams = Objects.requireNonNull(teams, "teams is required").orElse(Collections.emptyList());
            return this;
        }

        public Builder organizations(List<String> organizations) {
            this.organizations = Objects.requireNonNull(organizations, "organizations is required");
            return this;
        }

        public Builder organizations(Optional<List<String>> organizations) {
            this.organizations = Objects.requireNonNull(organizations, "organizations is required").orElse(Collections.emptyList());
            return this;
        }

        public EndpointOAuthGitHub build() {
            return new EndpointOAuthGitHub(this.clientId, this.clientSecret, this.scopes, this.emailAddresses, this.emailDomains, this.teams, this.organizations);
        }
    }
}

