/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok.definitions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ngrok.definitions.EndpointOAuthProvider;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class EndpointOAuth {
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Optional<Boolean> enabled;
    @JsonProperty(value="provider")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final EndpointOAuthProvider provider;
    @JsonProperty(value="options_passthrough")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final boolean optionsPassthrough;
    @JsonProperty(value="cookie_prefix")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String cookiePrefix;
    @JsonProperty(value="inactivity_timeout")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final long inactivityTimeout;
    @JsonProperty(value="maximum_duration")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Duration maximumDuration;
    @JsonProperty(value="auth_check_interval")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final long authCheckInterval;

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonCreator
    private EndpointOAuth(@JsonProperty(value="enabled") Optional<Boolean> enabled, @JsonProperty(value="provider") EndpointOAuthProvider provider, @JsonProperty(value="options_passthrough") Boolean optionsPassthrough, @JsonProperty(value="cookie_prefix") String cookiePrefix, @JsonProperty(value="inactivity_timeout") Long inactivityTimeout, @JsonProperty(value="maximum_duration") Duration maximumDuration, @JsonProperty(value="auth_check_interval") Long authCheckInterval) {
        this.enabled = enabled != null ? enabled : Optional.empty();
        this.provider = Objects.requireNonNull(provider, "provider is required");
        this.optionsPassthrough = Objects.requireNonNull(optionsPassthrough, "optionsPassthrough is required");
        this.cookiePrefix = Objects.requireNonNull(cookiePrefix, "cookiePrefix is required");
        this.inactivityTimeout = Objects.requireNonNull(inactivityTimeout, "inactivityTimeout is required");
        this.maximumDuration = Objects.requireNonNull(maximumDuration, "maximumDuration is required");
        this.authCheckInterval = Objects.requireNonNull(authCheckInterval, "authCheckInterval is required");
    }

    public Optional<Boolean> getEnabled() {
        return this.enabled;
    }

    public EndpointOAuthProvider getProvider() {
        return this.provider;
    }

    public boolean getOptionsPassthrough() {
        return this.optionsPassthrough;
    }

    public String getCookiePrefix() {
        return this.cookiePrefix;
    }

    public long getInactivityTimeout() {
        return this.inactivityTimeout;
    }

    public Duration getMaximumDuration() {
        return this.maximumDuration;
    }

    public long getAuthCheckInterval() {
        return this.authCheckInterval;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EndpointOAuth other = (EndpointOAuth)o;
        return this.enabled.equals(other.enabled) && this.provider.equals(other.provider) && this.optionsPassthrough == other.optionsPassthrough && this.cookiePrefix.equals(other.cookiePrefix) && this.inactivityTimeout == other.inactivityTimeout && this.maximumDuration == other.maximumDuration && this.authCheckInterval == other.authCheckInterval;
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.provider, this.optionsPassthrough, this.cookiePrefix, this.inactivityTimeout, this.maximumDuration, this.authCheckInterval);
    }

    public String toString() {
        return "EndpointOAuth{enabled='" + this.enabled.map(Object::toString).orElse("(null)") + "', provider='" + this.provider + "', optionsPassthrough='" + this.optionsPassthrough + "', cookiePrefix='" + this.cookiePrefix + "', inactivityTimeout='" + this.inactivityTimeout + "', maximumDuration='" + this.maximumDuration + "', authCheckInterval='" + this.authCheckInterval + "'}";
    }

    public static class Builder {
        private Optional<Boolean> enabled = Optional.empty();
        private Optional<EndpointOAuthProvider> provider = Optional.empty();
        private Optional<Boolean> optionsPassthrough = Optional.empty();
        private Optional<String> cookiePrefix = Optional.empty();
        private Optional<Long> inactivityTimeout = Optional.empty();
        private Optional<Duration> maximumDuration = Optional.empty();
        private Optional<Long> authCheckInterval = Optional.empty();

        private Builder() {
        }

        public Builder enabled(boolean enabled) {
            this.enabled = Optional.of(Objects.requireNonNull(Boolean.valueOf(enabled), "enabled is required"));
            return this;
        }

        public Builder enabled(Optional<Boolean> enabled) {
            this.enabled = Objects.requireNonNull(enabled, "enabled is required");
            return this;
        }

        public Builder provider(EndpointOAuthProvider provider) {
            this.provider = Optional.of(Objects.requireNonNull(provider, "provider is required"));
            return this;
        }

        public Builder provider(Optional<EndpointOAuthProvider> provider) {
            this.provider = Objects.requireNonNull(provider, "provider is required");
            return this;
        }

        public Builder optionsPassthrough(boolean optionsPassthrough) {
            this.optionsPassthrough = Optional.of(Objects.requireNonNull(Boolean.valueOf(optionsPassthrough), "optionsPassthrough is required"));
            return this;
        }

        public Builder optionsPassthrough(Optional<Boolean> optionsPassthrough) {
            this.optionsPassthrough = Objects.requireNonNull(optionsPassthrough, "optionsPassthrough is required");
            return this;
        }

        public Builder cookiePrefix(String cookiePrefix) {
            this.cookiePrefix = Optional.of(Objects.requireNonNull(cookiePrefix, "cookiePrefix is required"));
            return this;
        }

        public Builder cookiePrefix(Optional<String> cookiePrefix) {
            this.cookiePrefix = Objects.requireNonNull(cookiePrefix, "cookiePrefix is required");
            return this;
        }

        public Builder inactivityTimeout(long inactivityTimeout) {
            this.inactivityTimeout = Optional.of(Objects.requireNonNull(Long.valueOf(inactivityTimeout), "inactivityTimeout is required"));
            return this;
        }

        public Builder inactivityTimeout(Optional<Long> inactivityTimeout) {
            this.inactivityTimeout = Objects.requireNonNull(inactivityTimeout, "inactivityTimeout is required");
            return this;
        }

        public Builder maximumDuration(Duration maximumDuration) {
            this.maximumDuration = Optional.of(Objects.requireNonNull(maximumDuration, "maximumDuration is required"));
            return this;
        }

        public Builder maximumDuration(Optional<Duration> maximumDuration) {
            this.maximumDuration = Objects.requireNonNull(maximumDuration, "maximumDuration is required");
            return this;
        }

        public Builder authCheckInterval(long authCheckInterval) {
            this.authCheckInterval = Optional.of(Objects.requireNonNull(Long.valueOf(authCheckInterval), "authCheckInterval is required"));
            return this;
        }

        public Builder authCheckInterval(Optional<Long> authCheckInterval) {
            this.authCheckInterval = Objects.requireNonNull(authCheckInterval, "authCheckInterval is required");
            return this;
        }

        public EndpointOAuth build() {
            return new EndpointOAuth(this.enabled, this.provider.orElse(null), this.optionsPassthrough.orElse(false), this.cookiePrefix.orElse(""), this.inactivityTimeout.orElse(0L), this.maximumDuration.orElse(Duration.ZERO), this.authCheckInterval.orElse(0L));
        }
    }
}

