/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok.definitions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class EndpointCircuitBreaker {
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Optional<Boolean> enabled;
    @JsonProperty(value="tripped_duration")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Duration trippedDuration;
    @JsonProperty(value="rolling_window")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final long rollingWindow;
    @JsonProperty(value="num_buckets")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final long numBuckets;
    @JsonProperty(value="volume_threshold")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final long volumeThreshold;
    @JsonProperty(value="error_threshold_percentage")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final double errorThresholdPercentage;

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonCreator
    private EndpointCircuitBreaker(@JsonProperty(value="enabled") Optional<Boolean> enabled, @JsonProperty(value="tripped_duration") Duration trippedDuration, @JsonProperty(value="rolling_window") Long rollingWindow, @JsonProperty(value="num_buckets") Long numBuckets, @JsonProperty(value="volume_threshold") Long volumeThreshold, @JsonProperty(value="error_threshold_percentage") Double errorThresholdPercentage) {
        this.enabled = enabled != null ? enabled : Optional.empty();
        this.trippedDuration = Objects.requireNonNull(trippedDuration, "trippedDuration is required");
        this.rollingWindow = Objects.requireNonNull(rollingWindow, "rollingWindow is required");
        this.numBuckets = Objects.requireNonNull(numBuckets, "numBuckets is required");
        this.volumeThreshold = Objects.requireNonNull(volumeThreshold, "volumeThreshold is required");
        this.errorThresholdPercentage = Objects.requireNonNull(errorThresholdPercentage, "errorThresholdPercentage is required");
    }

    public Optional<Boolean> getEnabled() {
        return this.enabled;
    }

    public Duration getTrippedDuration() {
        return this.trippedDuration;
    }

    public long getRollingWindow() {
        return this.rollingWindow;
    }

    public long getNumBuckets() {
        return this.numBuckets;
    }

    public long getVolumeThreshold() {
        return this.volumeThreshold;
    }

    public double getErrorThresholdPercentage() {
        return this.errorThresholdPercentage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EndpointCircuitBreaker other = (EndpointCircuitBreaker)o;
        return this.enabled.equals(other.enabled) && this.trippedDuration == other.trippedDuration && this.rollingWindow == other.rollingWindow && this.numBuckets == other.numBuckets && this.volumeThreshold == other.volumeThreshold && this.errorThresholdPercentage == other.errorThresholdPercentage;
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.trippedDuration, this.rollingWindow, this.numBuckets, this.volumeThreshold, this.errorThresholdPercentage);
    }

    public String toString() {
        return "EndpointCircuitBreaker{enabled='" + this.enabled.map(Object::toString).orElse("(null)") + "', trippedDuration='" + this.trippedDuration + "', rollingWindow='" + this.rollingWindow + "', numBuckets='" + this.numBuckets + "', volumeThreshold='" + this.volumeThreshold + "', errorThresholdPercentage='" + this.errorThresholdPercentage + "'}";
    }

    public static class Builder {
        private Optional<Boolean> enabled = Optional.empty();
        private Optional<Duration> trippedDuration = Optional.empty();
        private Optional<Long> rollingWindow = Optional.empty();
        private Optional<Long> numBuckets = Optional.empty();
        private Optional<Long> volumeThreshold = Optional.empty();
        private Optional<Double> errorThresholdPercentage = Optional.empty();

        private Builder() {
        }

        public Builder enabled(boolean enabled) {
            this.enabled = Optional.of(Objects.requireNonNull(Boolean.valueOf(enabled), "enabled is required"));
            return this;
        }

        public Builder enabled(Optional<Boolean> enabled) {
            this.enabled = Objects.requireNonNull(enabled, "enabled is required");
            return this;
        }

        public Builder trippedDuration(Duration trippedDuration) {
            this.trippedDuration = Optional.of(Objects.requireNonNull(trippedDuration, "trippedDuration is required"));
            return this;
        }

        public Builder trippedDuration(Optional<Duration> trippedDuration) {
            this.trippedDuration = Objects.requireNonNull(trippedDuration, "trippedDuration is required");
            return this;
        }

        public Builder rollingWindow(long rollingWindow) {
            this.rollingWindow = Optional.of(Objects.requireNonNull(Long.valueOf(rollingWindow), "rollingWindow is required"));
            return this;
        }

        public Builder rollingWindow(Optional<Long> rollingWindow) {
            this.rollingWindow = Objects.requireNonNull(rollingWindow, "rollingWindow is required");
            return this;
        }

        public Builder numBuckets(long numBuckets) {
            this.numBuckets = Optional.of(Objects.requireNonNull(Long.valueOf(numBuckets), "numBuckets is required"));
            return this;
        }

        public Builder numBuckets(Optional<Long> numBuckets) {
            this.numBuckets = Objects.requireNonNull(numBuckets, "numBuckets is required");
            return this;
        }

        public Builder volumeThreshold(long volumeThreshold) {
            this.volumeThreshold = Optional.of(Objects.requireNonNull(Long.valueOf(volumeThreshold), "volumeThreshold is required"));
            return this;
        }

        public Builder volumeThreshold(Optional<Long> volumeThreshold) {
            this.volumeThreshold = Objects.requireNonNull(volumeThreshold, "volumeThreshold is required");
            return this;
        }

        public Builder errorThresholdPercentage(double errorThresholdPercentage) {
            this.errorThresholdPercentage = Optional.of(Objects.requireNonNull(Double.valueOf(errorThresholdPercentage), "errorThresholdPercentage is required"));
            return this;
        }

        public Builder errorThresholdPercentage(Optional<Double> errorThresholdPercentage) {
            this.errorThresholdPercentage = Objects.requireNonNull(errorThresholdPercentage, "errorThresholdPercentage is required");
            return this;
        }

        public EndpointCircuitBreaker build() {
            return new EndpointCircuitBreaker(this.enabled, this.trippedDuration.orElse(Duration.ZERO), this.rollingWindow.orElse(0L), this.numBuckets.orElse(0L), this.volumeThreshold.orElse(0L), this.errorThresholdPercentage.orElse(0.0));
        }
    }
}

