/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok.definitions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Credential {
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String id;
    @JsonProperty(value="uri")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final URI uri;
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final OffsetDateTime createdAt;
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String description;
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String metadata;
    @JsonProperty(value="token")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Optional<String> token;
    @JsonProperty(value="acl")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final List<String> acl;

    @JsonCreator
    public Credential(@JsonProperty(value="id") String id, @JsonProperty(value="uri") URI uri, @JsonProperty(value="created_at") OffsetDateTime createdAt, @JsonProperty(value="description") String description, @JsonProperty(value="metadata") String metadata, @JsonProperty(value="token") Optional<String> token, @JsonProperty(value="acl") List<String> acl) {
        this.id = Objects.requireNonNull(id, "id is required");
        this.uri = Objects.requireNonNull(uri, "uri is required");
        this.createdAt = Objects.requireNonNull(createdAt, "createdAt is required");
        this.description = Objects.requireNonNull(description, "description is required");
        this.metadata = Objects.requireNonNull(metadata, "metadata is required");
        this.token = token != null ? token : Optional.empty();
        this.acl = acl != null ? acl : Collections.emptyList();
    }

    public String getId() {
        return this.id;
    }

    public URI getUri() {
        return this.uri;
    }

    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public String getDescription() {
        return this.description;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public Optional<String> getToken() {
        return this.token;
    }

    public List<String> getAcl() {
        return this.acl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Credential other = (Credential)o;
        return this.id.equals(other.id) && this.uri.equals(other.uri) && this.createdAt.equals(other.createdAt) && this.description.equals(other.description) && this.metadata.equals(other.metadata) && this.token.equals(other.token) && this.acl.equals(other.acl);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.uri, this.createdAt, this.description, this.metadata, this.token, this.acl);
    }

    public String toString() {
        return "Credential{id='" + this.id + "', uri='" + this.uri + "', createdAt='" + this.createdAt + "', description='" + this.description + "', metadata='" + this.metadata + "', token='" + this.token.orElse("(null)") + "', acl='" + this.acl + "'}";
    }
}

