/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok.definitions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ngrok.definitions.CertificateAuthority;
import com.ngrok.definitions.Pageable;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CertificateAuthorityList
implements Pageable {
    @JsonProperty(value="certificate_authorities")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final List<CertificateAuthority> certificateAuthorities;
    @JsonProperty(value="uri")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final URI uri;
    @JsonProperty(value="next_page_uri")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Optional<URI> nextPageUri;

    @JsonCreator
    public CertificateAuthorityList(@JsonProperty(value="certificate_authorities") List<CertificateAuthority> certificateAuthorities, @JsonProperty(value="uri") URI uri, @JsonProperty(value="next_page_uri") Optional<URI> nextPageUri) {
        this.certificateAuthorities = certificateAuthorities != null ? certificateAuthorities : Collections.emptyList();
        this.uri = Objects.requireNonNull(uri, "uri is required");
        this.nextPageUri = nextPageUri != null ? nextPageUri : Optional.empty();
    }

    public List<CertificateAuthority> getCertificateAuthorities() {
        return this.certificateAuthorities;
    }

    public URI getUri() {
        return this.uri;
    }

    @Override
    public Optional<URI> getNextPageUri() {
        return this.nextPageUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CertificateAuthorityList other = (CertificateAuthorityList)o;
        return this.certificateAuthorities.equals(other.certificateAuthorities) && this.uri.equals(other.uri) && this.nextPageUri.equals(other.nextPageUri);
    }

    public int hashCode() {
        return Objects.hash(this.certificateAuthorities, this.uri, this.nextPageUri);
    }

    public String toString() {
        return "CertificateAuthorityList{certificateAuthorities='" + this.certificateAuthorities + "', uri='" + this.uri + "', nextPageUri='" + this.nextPageUri.map(Object::toString).orElse("(null)") + "'}";
    }
}

