/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok.definitions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AwsCredentials {
    @JsonProperty(value="aws_access_key_id")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String awsAccessKeyId;
    @JsonProperty(value="aws_secret_access_key")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Optional<String> awsSecretAccessKey;

    public static Builder newBuilder(String awsAccessKeyId, String awsSecretAccessKey) {
        return new Builder(awsAccessKeyId, awsSecretAccessKey);
    }

    @JsonCreator
    private AwsCredentials(@JsonProperty(value="aws_access_key_id") String awsAccessKeyId, @JsonProperty(value="aws_secret_access_key") Optional<String> awsSecretAccessKey) {
        this.awsAccessKeyId = Objects.requireNonNull(awsAccessKeyId, "awsAccessKeyId is required");
        this.awsSecretAccessKey = awsSecretAccessKey != null ? awsSecretAccessKey : Optional.empty();
    }

    public String getAwsAccessKeyId() {
        return this.awsAccessKeyId;
    }

    public Optional<String> getAwsSecretAccessKey() {
        return this.awsSecretAccessKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AwsCredentials other = (AwsCredentials)o;
        return this.awsAccessKeyId.equals(other.awsAccessKeyId) && this.awsSecretAccessKey.equals(other.awsSecretAccessKey);
    }

    public int hashCode() {
        return Objects.hash(this.awsAccessKeyId, this.awsSecretAccessKey);
    }

    public String toString() {
        return "AwsCredentials{awsAccessKeyId='" + this.awsAccessKeyId + "', awsSecretAccessKey='" + this.awsSecretAccessKey.orElse("(null)") + "'}";
    }

    public static class Builder {
        private final String awsAccessKeyId;
        private final String awsSecretAccessKey;

        private Builder(String awsAccessKeyId, String awsSecretAccessKey) {
            this.awsAccessKeyId = Objects.requireNonNull(awsAccessKeyId, "awsAccessKeyId is required");
            this.awsSecretAccessKey = Objects.requireNonNull(awsSecretAccessKey, "awsSecretAccessKey is required");
        }

        public AwsCredentials build() {
            return new AwsCredentials(this.awsAccessKeyId, Optional.of(this.awsSecretAccessKey));
        }
    }
}

