/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok.definitions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ngrok.definitions.AwsCredentials;
import com.ngrok.definitions.AwsRole;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AwsAuth {
    @JsonProperty(value="role")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Optional<AwsRole> role;
    @JsonProperty(value="creds")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Optional<AwsCredentials> creds;

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonCreator
    private AwsAuth(@JsonProperty(value="role") Optional<AwsRole> role, @JsonProperty(value="creds") Optional<AwsCredentials> creds) {
        this.role = role != null ? role : Optional.empty();
        this.creds = creds != null ? creds : Optional.empty();
    }

    public Optional<AwsRole> getRole() {
        return this.role;
    }

    public Optional<AwsCredentials> getCreds() {
        return this.creds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AwsAuth other = (AwsAuth)o;
        return this.role.equals(other.role) && this.creds.equals(other.creds);
    }

    public int hashCode() {
        return Objects.hash(this.role, this.creds);
    }

    public String toString() {
        return "AwsAuth{role='" + this.role.map(Object::toString).orElse("(null)") + "', creds='" + this.creds.map(Object::toString).orElse("(null)") + "'}";
    }

    public static class Builder {
        private Optional<AwsRole> role = Optional.empty();
        private Optional<AwsCredentials> creds = Optional.empty();

        private Builder() {
        }

        public Builder role(AwsRole role) {
            this.role = Optional.of(Objects.requireNonNull(role, "role is required"));
            return this;
        }

        public Builder role(Optional<AwsRole> role) {
            this.role = Objects.requireNonNull(role, "role is required");
            return this;
        }

        public Builder creds(AwsCredentials creds) {
            this.creds = Optional.of(Objects.requireNonNull(creds, "creds is required"));
            return this;
        }

        public Builder creds(Optional<AwsCredentials> creds) {
            this.creds = Objects.requireNonNull(creds, "creds is required");
            return this;
        }

        public AwsAuth build() {
            return new AwsAuth(this.role, this.creds);
        }
    }
}

