/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok.definitions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ApiKey {
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String id;
    @JsonProperty(value="uri")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final URI uri;
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String description;
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String metadata;
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final OffsetDateTime createdAt;
    @JsonProperty(value="token")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Optional<String> token;

    @JsonCreator
    public ApiKey(@JsonProperty(value="id") String id, @JsonProperty(value="uri") URI uri, @JsonProperty(value="description") String description, @JsonProperty(value="metadata") String metadata, @JsonProperty(value="created_at") OffsetDateTime createdAt, @JsonProperty(value="token") Optional<String> token) {
        this.id = Objects.requireNonNull(id, "id is required");
        this.uri = Objects.requireNonNull(uri, "uri is required");
        this.description = Objects.requireNonNull(description, "description is required");
        this.metadata = Objects.requireNonNull(metadata, "metadata is required");
        this.createdAt = Objects.requireNonNull(createdAt, "createdAt is required");
        this.token = token != null ? token : Optional.empty();
    }

    public String getId() {
        return this.id;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getDescription() {
        return this.description;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public Optional<String> getToken() {
        return this.token;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiKey other = (ApiKey)o;
        return this.id.equals(other.id) && this.uri.equals(other.uri) && this.description.equals(other.description) && this.metadata.equals(other.metadata) && this.createdAt.equals(other.createdAt) && this.token.equals(other.token);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.uri, this.description, this.metadata, this.createdAt, this.token);
    }

    public String toString() {
        return "ApiKey{id='" + this.id + "', uri='" + this.uri + "', description='" + this.description + "', metadata='" + this.metadata + "', createdAt='" + this.createdAt + "', token='" + this.token.orElse("(null)") + "'}";
    }
}

