/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.client.WebClientRequestPreparation;
import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.ngrok.NgrokApiClient;
import com.ngrok.definitions.NgrokApiError;
import java.net.URI;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DefaultNgrokApiClient
implements NgrokApiClient {
    private static String JAVA_VERSION = System.getProperty("java.version");
    private final String apiKey;
    private final WebClient httpClient;
    private final URI baseUri;
    private final ObjectMapper objectMapper;

    public static Builder newBuilder(String apiKey) {
        return new Builder(apiKey);
    }

    public static WebClient newDefaultHttpClient() {
        ClientFactory factory = ClientFactory.builder().connectTimeout(Duration.ofSeconds(4L)).idleTimeout(Duration.ofMinutes(2L)).useHttp1Pipelining(false).build();
        return WebClient.builder().factory(factory).responseTimeout(Duration.ofSeconds(30L)).writeTimeout(Duration.ofSeconds(1L)).build();
    }

    private static HttpMethod armeriaMethodFromNgrokMethod(NgrokApiClient.HttpMethod method) {
        switch (method) {
            case GET: {
                return HttpMethod.GET;
            }
            case POST: {
                return HttpMethod.POST;
            }
            case PUT: {
                return HttpMethod.PUT;
            }
            case PATCH: {
                return HttpMethod.PATCH;
            }
            case DELETE: {
                return HttpMethod.DELETE;
            }
        }
        throw new AssertionError((Object)("Impossible NgrokApiClient.HttpMethod: " + (Object)((Object)method)));
    }

    private static String queryParamToString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof OffsetDateTime) {
            return ((OffsetDateTime)value).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }
        if (value instanceof Duration) {
            return String.valueOf(((Duration)value).getSeconds());
        }
        return value.toString();
    }

    private static <T> CompletionStage<T> failedFuture(Throwable t) {
        CompletableFuture failed = new CompletableFuture();
        failed.completeExceptionally(t);
        return failed;
    }

    private static <T> CompletionStage<T> couldThrow(Callable<T> f, Optional<AggregatedHttpResponse> response) {
        try {
            return CompletableFuture.completedFuture(f.call());
        }
        catch (Exception e) {
            return DefaultNgrokApiClient.failedFuture(response.map(r -> {
                Optional<String> responseBody = Optional.of(r.content()).filter(c -> !c.isEmpty()).map(HttpData::toStringUtf8);
                try {
                    return new NgrokApiError(r.status().code(), responseBody, e);
                }
                catch (Exception e1) {
                    return new NgrokApiError(HttpStatus.SERVICE_UNAVAILABLE.code(), responseBody, e);
                }
            }).orElse(e));
        }
    }

    private static <T> CompletionStage<T> couldThrow(Callable<T> f, AggregatedHttpResponse response) {
        return DefaultNgrokApiClient.couldThrow(f, Optional.of(response));
    }

    private static <T> CompletionStage<T> couldThrow(Callable<T> f) {
        return DefaultNgrokApiClient.couldThrow(f, Optional.empty());
    }

    private DefaultNgrokApiClient(String apiKey, WebClient httpClient, URI baseUri, ObjectMapper objectMapper) {
        this.apiKey = apiKey;
        this.httpClient = httpClient;
        this.baseUri = baseUri;
        this.objectMapper = objectMapper;
    }

    @Override
    public <O> CompletionStage<O> sendRequest(URI uri, Class<O> responseClass) {
        WebClientRequestPreparation request = this.httpClient.prepare().get(uri.toString());
        return this.sendRequest(request, Optional.empty(), Optional.of(responseClass));
    }

    @Override
    public <O> CompletionStage<O> sendRequest(NgrokApiClient.HttpMethod method, String endpoint, Stream<Map.Entry<String, Optional<Object>>> queryParams, Stream<Map.Entry<String, Optional<Object>>> bodyParamsStream, Optional<Class<O>> responseClass) {
        WebClientRequestPreparation request = this.httpClient.prepare().method(DefaultNgrokApiClient.armeriaMethodFromNgrokMethod(method)).path(this.baseUri.toString() + endpoint).queryParams((Iterable)queryParams.flatMap(entry -> ((Optional)entry.getValue()).map(value -> Stream.of(new AbstractMap.SimpleEntry<String, String>((String)entry.getKey(), DefaultNgrokApiClient.queryParamToString(value)))).orElse(Stream.empty())).collect(Collectors.toList()));
        List bodyParams = bodyParamsStream.collect(Collectors.toList());
        Optional<JsonNode> body = bodyParams.isEmpty() ? Optional.empty() : Optional.of((JsonNode)this.objectMapper.convertValue(bodyParams.stream().flatMap(entry -> ((Optional)entry.getValue()).map(value -> Stream.of(new AbstractMap.SimpleEntry<String, Object>((String)entry.getKey(), value))).orElse(Stream.empty())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)), JsonNode.class));
        return this.sendRequest(request, body, responseClass);
    }

    private <O> CompletionStage<O> sendRequest(WebClientRequestPreparation request, Optional<JsonNode> maybeBody, Optional<Class<O>> responseClass) {
        request.header((CharSequence)HttpHeaderNames.USER_AGENT, (Object)("ngrok-api-java/0.6.0/" + JAVA_VERSION)).header((CharSequence)"ngrok-version", (Object)"2").header((CharSequence)HttpHeaderNames.AUTHORIZATION, (Object)("Bearer " + this.apiKey));
        return maybeBody.map(body -> DefaultNgrokApiClient.couldThrow(() -> Optional.of(this.objectMapper.writeValueAsBytes(body)))).orElseGet(() -> CompletableFuture.completedFuture(Optional.empty())).thenApply(maybeBodyBytes -> maybeBodyBytes.map(bodyBytes -> request.content(MediaType.JSON, bodyBytes)).orElse(request)).thenCompose(req -> req.execute().aggregate()).thenCompose(response -> Optional.of(response.content()).filter(c -> !c.isEmpty()).map(responseBody -> {
            if (response.status().isSuccess()) {
                return responseClass.map(cls -> DefaultNgrokApiClient.couldThrow(() -> this.objectMapper.readValue(responseBody.toStringUtf8(), cls), response)).orElseGet(() -> CompletableFuture.completedFuture(null));
            }
            return DefaultNgrokApiClient.couldThrow(() -> (NgrokApiError)this.objectMapper.readValue(responseBody.toStringUtf8(), NgrokApiError.class), response).thenCompose(DefaultNgrokApiClient::failedFuture);
        }).orElseGet(() -> {
            if (response.status().isSuccess()) {
                return responseClass.map(cls -> DefaultNgrokApiClient.couldThrow(() -> this.objectMapper.readValue("{}", cls), response)).orElseGet(() -> CompletableFuture.completedFuture(null));
            }
            return DefaultNgrokApiClient.failedFuture(new NgrokApiError(response.status().code()));
        }));
    }

    public static class Builder {
        private final String apiKey;
        private Optional<WebClient> httpClient = Optional.empty();
        private Optional<URI> baseUri = Optional.empty();
        private Optional<ObjectMapper> objectMapper = Optional.empty();

        private Builder(String apiKey) {
            this.apiKey = Objects.requireNonNull(apiKey, "apiKey is required");
        }

        public Builder httpClient(WebClient httpClient) {
            this.httpClient = Optional.ofNullable(httpClient);
            return this;
        }

        public Builder httpClient(Optional<WebClient> httpClient) {
            this.httpClient = Objects.requireNonNull(httpClient, "httpClient is required");
            return this;
        }

        public Builder baseUri(URI baseUri) {
            this.baseUri = Optional.ofNullable(baseUri);
            return this;
        }

        public Builder baseUri(Optional<URI> baseUri) {
            this.baseUri = Objects.requireNonNull(baseUri, "baseUri is required");
            return this;
        }

        public Builder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = Optional.ofNullable(objectMapper);
            return this;
        }

        public Builder objectMapper(Optional<ObjectMapper> objectMapper) {
            this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper is required");
            return this;
        }

        public DefaultNgrokApiClient build() {
            return new DefaultNgrokApiClient(this.apiKey, this.httpClient.orElseGet(DefaultNgrokApiClient::newDefaultHttpClient), this.baseUri.orElse(NgrokApiClient.DEFAULT_BASE_URI), this.objectMapper.orElseGet(() -> new ObjectMapper().registerModule((Module)new Jdk8Module()).registerModule((Module)new JavaTimeModule())));
        }
    }
}

