/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class Config
extends Properties {
    static String[] _placesToLook = new String[]{"./", "conf", "/etc/", System.getenv("ED_HOME") + "/", System.getenv("ED_HOME") + "/conf", System.getenv("ED_HOME") + "/etc"};
    private static String _configFile = "10gen.properties";
    private static final Config INSTANCE = new Config();

    public static Config get() {
        return INSTANCE;
    }

    public static String getInternalDomain() {
        return Config.get().getProperty("internalDomain", "10gen.cc");
    }

    public static String getExternalDomain() {
        return Config.get().getProperty("externalDomain", "10gen.com");
    }

    public static String getDataRoot() {
        String root = Config.get().getTryEnvFirst("BASE", "/data/").trim();
        if (!root.endsWith("/")) {
            root = root + "/";
        }
        return root;
    }

    private Config() {
        super(System.getProperties());
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        for (String place : _placesToLook) {
            File f = new File(place, _configFile);
            if (f.exists()) {
                System.out.println("loading config file from [" + f + "]");
                this._load(f);
                break;
            }
            InputStream in = cl.getResourceAsStream(place + _configFile);
            if (in == null) continue;
            System.out.println("loading config from [" + place + _configFile + "]");
            this._load(in);
            break;
        }
    }

    private void _load(File f) {
        try {
            this._load(new FileInputStream(f));
        }
        catch (FileNotFoundException fnf) {
            System.err.println("can't find : " + f + " but should be impossible b/c only called if it exists.  exiting");
            System.exit(-4);
        }
    }

    private void _load(InputStream in) {
        try {
            this.load(in);
        }
        catch (IOException ioe) {
            System.err.println("error reading config file from stream : " + ioe + "  exiting...");
            System.exit(-4);
        }
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean def) {
        String s = this.getProperty(key);
        if (s == null) {
            return def;
        }
        if (s.startsWith("t") || s.startsWith("T") || s.startsWith("y") || s.startsWith("Y") || s.startsWith("1")) {
            return true;
        }
        if (s.startsWith("n") || s.startsWith("N") || s.startsWith("f") || s.startsWith("F") || s.startsWith("0")) {
            return false;
        }
        return def;
    }

    public long getLong(String name, long def) {
        String s = this.getProperty(name);
        if (s == null) {
            return def;
        }
        if ((s = s.trim()).length() == 0) {
            return def;
        }
        return Long.parseLong(s);
    }

    public String getTryEnvFirst(String name, String def) {
        String s = System.getenv(name);
        if (s != null && s.trim().length() > 0) {
            return s;
        }
        return this.getProperty(name, def);
    }

    @Override
    public Object setProperty(String key, String value) {
        throw new RuntimeException("can't set something on config");
    }

    @Override
    public Object put(String key, String value) {
        throw new RuntimeException("can't set something on config");
    }
}

