/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.gridfs;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.gridfs.GridFS;
import com.mongodb.util.JSON;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class GridFSFile
implements DBObject {
    protected GridFS _fs = null;
    Object _id;
    String _filename;
    String _contentType;
    long _length;
    long _chunkSize;
    Date _uploadDate;
    List<String> _aliases;
    DBObject _metadata;
    String _md5;
    static final Set<String> VALID_FIELDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("_id", "filename", "contentType", "length", "chunkSize", "uploadDate", "aliases", "metadata", "md5")));

    public void save() {
        if (this._fs == null) {
            throw new MongoException("need _fs");
        }
        this._fs._filesCollection.save(this);
    }

    public void validate() {
        if (this._fs == null) {
            throw new MongoException("no _fs");
        }
        if (this._md5 == null) {
            throw new MongoException("no _md5 stored");
        }
        DBObject res = this._fs._db.command(new BasicDBObject("filemd5", this._id));
        String m = res.get("md5").toString();
        if (m.equals(this._md5)) {
            return;
        }
        throw new MongoException("md5 differ.  mine [" + this._md5 + "] theirs [" + m + "]");
    }

    public int numChunks() {
        double d = this._length;
        return (int)Math.ceil(d /= (double)this._chunkSize);
    }

    public Object getId() {
        return this._id;
    }

    public String getFilename() {
        return this._filename;
    }

    public String getContentType() {
        return this._contentType;
    }

    public long getLength() {
        return this._length;
    }

    public long getChunkSize() {
        return this._chunkSize;
    }

    public Date getUploadDate() {
        return this._uploadDate;
    }

    public List<String> getAliases() {
        return this._aliases;
    }

    public DBObject getMetaData() {
        return this._metadata;
    }

    public String getMD5() {
        return this._md5;
    }

    @Override
    public Object put(String key, Object v) {
        if (key == null) {
            throw new RuntimeException("key should never be null");
        }
        if (key.equals("_id")) {
            this._id = v;
        } else if (!key.equals("_ns")) {
            if (key.equals("filename")) {
                this._filename = v == null ? null : v.toString();
            } else if (key.equals("contentType")) {
                this._contentType = (String)v;
            } else if (key.equals("length")) {
                this._length = ((Number)v).longValue();
            } else if (key.equals("chunkSize")) {
                this._chunkSize = ((Number)v).longValue();
            } else if (key.equals("uploadDate")) {
                this._uploadDate = (Date)v;
            } else if (key.equals("metadata")) {
                this._metadata = (DBObject)v;
            } else if (key.equals("md5")) {
                this._md5 = (String)v;
            } else if (key.equals("aliases")) {
                if (v != null) {
                    throw new MongoException("can't handle aliases yet");
                }
            } else {
                throw new MongoException("GridFSFile don't know about key [" + key + "] converting to metadata ");
            }
        }
        return v;
    }

    @Override
    public Object get(String key) {
        if (key == null) {
            throw new RuntimeException("key should never be null");
        }
        if (key.equals("_id")) {
            return this._id;
        }
        if (key.equals("filename")) {
            return this._filename;
        }
        if (key.equals("contentType")) {
            return this._contentType;
        }
        if (key.equals("length")) {
            return this._length;
        }
        if (key.equals("chunkSize")) {
            return this._chunkSize;
        }
        if (key.equals("uplodateDate")) {
            return this._uploadDate;
        }
        if (key.equals("metadata")) {
            return this._metadata;
        }
        if (key.equals("md5")) {
            return this._md5;
        }
        return null;
    }

    @Override
    public void putAll(DBObject o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map toMap() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object removeField(String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(String s) {
        return this.containsField(s);
    }

    @Override
    public boolean containsField(String s) {
        return VALID_FIELDS.contains(s);
    }

    @Override
    public Set<String> keySet() {
        return VALID_FIELDS;
    }

    @Override
    public boolean isPartialObject() {
        return false;
    }

    @Override
    public void markAsPartialObject() {
        throw new RuntimeException("can't load partial GridFSFile file");
    }

    public String toString() {
        return JSON.serialize(this);
    }

    protected void setGridFS(GridFS fs) {
        this._fs = fs;
    }
}

