/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.gridfs;

import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.gridfs.GridFSFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class GridFSDBFile
extends GridFSFile {
    public InputStream getInputStream() {
        return new MyInputStream();
    }

    public long writeTo(String filename) throws IOException {
        return this.writeTo(new File(filename));
    }

    public long writeTo(File f) throws IOException {
        return this.writeTo(new FileOutputStream(f));
    }

    public long writeTo(OutputStream out) throws IOException {
        int nc = this.numChunks();
        for (int i = 0; i < nc; ++i) {
            out.write(this.getChunk(i));
        }
        return this._length;
    }

    byte[] getChunk(int i) {
        if (this._fs == null) {
            throw new RuntimeException("no gridfs!");
        }
        DBObject chunk = this._fs._chunkCollection.findOne(BasicDBObjectBuilder.start("files_id", this._id).add("n", i).get());
        if (chunk == null) {
            throw new MongoException("can't find a chunk!  file id: " + this._id + " chunk: " + i);
        }
        return (byte[])chunk.get("data");
    }

    void remove() {
        this._fs._filesCollection.remove(new BasicDBObject("_id", this._id));
        this._fs._chunkCollection.remove(new BasicDBObject("files_id", this._id));
    }

    class MyInputStream
    extends InputStream {
        final int _numChunks;
        int _nextChunk = 0;
        int _offset;
        byte[] _data = null;

        MyInputStream() {
            this._numChunks = GridFSDBFile.this.numChunks();
        }

        @Override
        public int available() {
            if (this._data == null) {
                return 0;
            }
            return this._data.length - this._offset;
        }

        @Override
        public void close() {
        }

        @Override
        public void mark(int readlimit) {
            throw new RuntimeException("mark not supported");
        }

        @Override
        public void reset() {
            throw new RuntimeException("mark not supported");
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public int read() {
            byte[] b = new byte[1];
            int res = this.read(b);
            if (res < 0) {
                return -1;
            }
            return b[0] & 0xFF;
        }

        @Override
        public int read(byte[] b) {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) {
            if (this._data == null || this._offset >= this._data.length) {
                if (this._nextChunk >= this._numChunks) {
                    return -1;
                }
                this._data = GridFSDBFile.this.getChunk(this._nextChunk);
                this._offset = 0;
                ++this._nextChunk;
            }
            int r = Math.min(len, this._data.length - this._offset);
            System.arraycopy(this._data, this._offset, b, off, r);
            this._offset += r;
            return r;
        }
    }
}

