/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.Bytes;
import com.mongodb.DBApiLayer;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.MongoInternalException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class DBCursor
implements Iterator<DBObject>,
Iterable<DBObject> {
    final DBCollection _collection;
    final DBObject _query;
    final DBObject _keysWanted;
    private DBObject _orderBy = null;
    private String _hint = null;
    private boolean _explain = false;
    private int _numWanted = 0;
    private int _batchSize = 0;
    private int _skip = 0;
    private boolean _snapshot = false;
    private Iterator<DBObject> _it = null;
    private boolean _fake = false;
    private CursorType _cursorType = null;
    private DBObject _cur = null;
    private int _num = 0;
    private final ArrayList<DBObject> _all = new ArrayList();
    private final List<String> _nums = new ArrayList<String>();

    public DBCursor(DBCollection collection, DBObject q, DBObject k) {
        this._collection = collection;
        this._query = q == null ? new BasicDBObject() : q;
        this._keysWanted = k;
    }

    public DBCursor copy() {
        DBCursor c = new DBCursor(this._collection, this._query, this._keysWanted);
        c._orderBy = this._orderBy;
        c._hint = this._hint;
        c._numWanted = this._numWanted;
        c._skip = this._skip;
        return c;
    }

    @Override
    public Iterator<DBObject> iterator() {
        return this.copy();
    }

    public DBCursor sort(DBObject orderBy) {
        if (this._it != null) {
            throw new IllegalStateException("can't sort after executing query");
        }
        this._orderBy = orderBy;
        return this;
    }

    public DBCursor hint(DBObject indexKeys) {
        if (this._it != null) {
            throw new IllegalStateException("can't hint after executing query");
        }
        this._hint = indexKeys == null ? null : DBCollection.genIndexName(indexKeys);
        return this;
    }

    public DBCursor snapshot() {
        if (this._it != null) {
            throw new IllegalStateException("can't snapshot after executing the query");
        }
        this._snapshot = true;
        return this;
    }

    public DBCursor hint(String indexName) {
        if (this._it != null) {
            throw new IllegalStateException("can't hint after executing query");
        }
        this._hint = indexName;
        return this;
    }

    public DBObject explain() {
        DBCursor c = this.copy();
        c._explain = true;
        c._numWanted *= -1;
        return c.next();
    }

    public DBCursor limit(int n) {
        if (this._it != null) {
            throw new IllegalStateException("can't set limit after executing query");
        }
        this._numWanted = n;
        return this;
    }

    public DBCursor batchSize(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("batchSize has to be >= 1");
        }
        if (n == 1) {
            n = 2;
        }
        if (this._it != null) {
            throw new IllegalStateException("can't set batch size after executing query");
        }
        this._batchSize = n;
        return this;
    }

    public DBCursor skip(int n) {
        if (this._it != null) {
            throw new IllegalStateException("can't set skip after executing query");
        }
        this._skip = n;
        return this;
    }

    private void _check() throws MongoException {
        if (this._it != null) {
            return;
        }
        if (this._collection != null && this._query != null) {
            this._lookForHints();
            DBObject foo = this._query;
            if (this.hasSpecialQueryFields()) {
                foo = new BasicDBObject();
                this._addToQueryObject(foo, "query", this._query, true);
                this._addToQueryObject(foo, "orderby", this._orderBy, false);
                this._addToQueryObject(foo, "$hint", this._hint);
                if (this._explain) {
                    foo.put("$explain", true);
                }
                if (this._snapshot) {
                    foo.put("$snapshot", true);
                }
            }
            int bs = this._numWanted;
            if (this._batchSize > 0) {
                bs = this._numWanted == 0 ? this._batchSize : Math.min(bs, this._batchSize);
            }
            this._it = this._collection.find(foo, this._keysWanted, this._skip, bs);
        }
        if (this._it == null) {
            this._it = new LinkedList().iterator();
            this._fake = true;
        }
    }

    private void _lookForHints() {
        if (this._hint != null) {
            return;
        }
        if (this._collection._hintFields == null) {
            return;
        }
        Set<String> mykeys = this._query.keySet();
        for (DBObject o : this._collection._hintFields) {
            Set<String> hintKeys = o.keySet();
            if (!mykeys.containsAll(hintKeys)) continue;
            this.hint(o);
            return;
        }
    }

    boolean hasSpecialQueryFields() {
        if (this._orderBy != null && this._orderBy.keySet().size() > 0) {
            return true;
        }
        if (this._hint != null) {
            return true;
        }
        return this._explain;
    }

    void _addToQueryObject(DBObject query, String field, DBObject thing, boolean sendEmpty) {
        if (thing == null) {
            return;
        }
        if (!sendEmpty && thing.keySet().size() == 0) {
            return;
        }
        this._noRefCheck(thing);
        this._addToQueryObject(query, field, thing);
    }

    void _addToQueryObject(DBObject query, String field, Object thing) {
        if (thing == null) {
            return;
        }
        query.put(field, thing);
    }

    void _noRefCheck(DBObject o) {
        if (!Bytes.cameFromDB(o)) {
            return;
        }
        o.put("_____nodbref_____", "z");
    }

    void _checkType(CursorType type) {
        if (this._cursorType == null) {
            this._cursorType = type;
            return;
        }
        if (type == this._cursorType) {
            return;
        }
        throw new IllegalArgumentException("can't switch cursor access methods");
    }

    private DBObject _next() throws MongoException {
        if (this._cursorType == null) {
            this._checkType(CursorType.ITERATOR);
        }
        this._check();
        this._cur = null;
        this._cur = this._it.next();
        this._collection.apply(this._cur, false);
        ++this._num;
        if (this._keysWanted != null && this._keysWanted.keySet().size() > 0) {
            this._cur.markAsPartialObject();
        }
        if (this._cursorType == CursorType.ARRAY) {
            this._nums.add(String.valueOf(this._all.size()));
            this._all.add(this._cur);
        }
        return this._cur;
    }

    public int numGetMores() {
        if (this._fake) {
            return 0;
        }
        if (this._it instanceof DBApiLayer.Result) {
            return ((DBApiLayer.Result)this._it).numGetMores();
        }
        throw new IllegalArgumentException("_it not a real result");
    }

    public List<Integer> getSizes() {
        if (this._fake) {
            return new LinkedList<Integer>();
        }
        if (this._it instanceof DBApiLayer.Result) {
            return ((DBApiLayer.Result)this._it).getSizes();
        }
        throw new IllegalArgumentException("_it not a real result");
    }

    private boolean _hasNext() throws MongoException {
        this._check();
        if (this._numWanted > 0 && this._num >= this._numWanted) {
            return false;
        }
        return this._it.hasNext();
    }

    public int numSeen() {
        return this._num;
    }

    @Override
    public boolean hasNext() {
        this._checkType(CursorType.ITERATOR);
        try {
            return this._hasNext();
        }
        catch (MongoException e) {
            throw new MongoInternalException("couldn't get next element", e);
        }
    }

    @Override
    public DBObject next() {
        this._checkType(CursorType.ITERATOR);
        try {
            return this._next();
        }
        catch (MongoException e) {
            throw new MongoInternalException("couldn't get next element", e);
        }
    }

    public DBObject curr() {
        this._checkType(CursorType.ITERATOR);
        return this._cur;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("can't remove from a cursor");
    }

    void _fill(int n) throws MongoException {
        this._checkType(CursorType.ARRAY);
        while (n >= this._all.size() && this._hasNext()) {
            this._next();
        }
    }

    public int length() throws MongoException {
        this._checkType(CursorType.ARRAY);
        this._fill(Integer.MAX_VALUE);
        return this._all.size();
    }

    public List<DBObject> toArray() throws MongoException {
        return this.toArray(Integer.MAX_VALUE);
    }

    public List<DBObject> toArray(int min) throws MongoException {
        this._checkType(CursorType.ARRAY);
        this._fill(min);
        return this._all;
    }

    public int itcount() {
        int n = 0;
        while (this.hasNext()) {
            this.next();
            ++n;
        }
        return n;
    }

    public int count() throws MongoException {
        if (this._collection == null) {
            throw new IllegalArgumentException("why is _collection null");
        }
        if (this._collection._base == null) {
            throw new IllegalArgumentException("why is _collection._base null");
        }
        return (int)this._collection.getCount(this._query, this._keysWanted);
    }

    static enum CursorType {
        ITERATOR,
        ARRAY;

    }
}

