/*
 * Decompiled with CFR 0.152.
 */
package com.logtail.logback;

import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.logtail.logback.LogtailResponse;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogtailAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private static final String CUSTOM_USER_AGENT = "Logtail Logback Appender";
    private final Logger errorLog = LoggerFactory.getLogger(LogtailAppender.class);
    private final ObjectMapper dataMapper;
    private Client client;
    private boolean disabled;
    protected final MultivaluedMap<String, Object> headers;
    protected PatternLayoutEncoder encoder;
    protected String appName;
    protected String ingestUrl = "https://in.logtail.com";
    protected List<String> mdcFields = new ArrayList<String>();
    protected List<String> mdcTypes = new ArrayList<String>();
    protected long connectTimeout = 5000L;
    protected long readTimeout = 10000L;
    private int batchSize = 1000;
    private List<ILoggingEvent> batch = new ArrayList<ILoggingEvent>();

    public LogtailAppender() {
        this.headers = new MultivaluedHashMap();
        this.headers.add((Object)"User-Agent", (Object)CUSTOM_USER_AGENT);
        this.headers.add((Object)"Accept", (Object)"application/json");
        this.headers.add((Object)"Content-Type", (Object)"application/json");
        this.dataMapper = new ObjectMapper();
        this.dataMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.dataMapper.setPropertyNamingStrategy(PropertyNamingStrategies.UPPER_CAMEL_CASE);
    }

    protected Client client() {
        if (this.client == null) {
            this.client = ClientBuilder.newBuilder().connectTimeout(this.connectTimeout, TimeUnit.MILLISECONDS).readTimeout(this.readTimeout, TimeUnit.MILLISECONDS).build();
        }
        return this.client;
    }

    protected void append(ILoggingEvent event) {
        if (this.disabled) {
            return;
        }
        if (event.getLoggerName().equals(LogtailAppender.class.getName())) {
            return;
        }
        if (!this.headers.containsKey((Object)"Authorization") || this.headers.getFirst((Object)"Authorization").toString().trim().length() < 8) {
            this.errorLog.warn("Empty ingest API key for Logtail ; disabling LogtailAppender");
            this.disabled = true;
            return;
        }
        this.appendToBatch(event);
    }

    private void appendToBatch(ILoggingEvent event) {
        this.batch.add(event);
        if (this.batch.size() >= this.batchSize) {
            this.flush();
        }
    }

    protected void flush() {
        try {
            String jsonData = this.convertLogEventsToJson(this.batch);
            Response response = this.callIngestApi(jsonData);
            if (response.getStatus() != 202) {
                LogtailResponse logtailResponse = this.convertResponseToObject(response);
                this.errorLog.error("Error calling Logtail : {} ({})", (Object)logtailResponse.getError(), (Object)response.getStatus());
            }
            this.batch.clear();
        }
        catch (JsonProcessingException e) {
            this.errorLog.error("Error processing JSON data : {}", (Object)e.getMessage());
        }
        catch (Exception e) {
            this.errorLog.error("Error trying to call Logtail : {}", (Object)e.getMessage());
        }
    }

    protected String convertLogEventsToJson(List<ILoggingEvent> events) throws JsonProcessingException {
        List values = events.stream().map(this::buildPostData).collect(Collectors.toList());
        return this.dataMapper.writeValueAsString(values);
    }

    protected LogtailResponse convertResponseToObject(Response response) throws JsonProcessingException {
        return new LogtailResponse((String)response.readEntity(String.class), response.getStatus());
    }

    protected Response callIngestApi(String jsonData) {
        WebTarget wt = this.client().target(this.ingestUrl);
        return wt.request().headers(this.headers).post(Entity.json((Object)jsonData));
    }

    protected Map<String, Object> buildPostData(ILoggingEvent event) {
        StackTraceElement[] callerData;
        HashMap<String, Object> line = new HashMap<String, Object>();
        line.put("dt", Long.toString(event.getTimeStamp()));
        line.put("level", event.getLevel().toString());
        line.put("app", this.appName);
        line.put("message", this.encoder != null ? new String(this.encoder.encode((Object)event)) : event.getFormattedMessage());
        HashMap<String, Object> meta = new HashMap<String, Object>();
        meta.put("logger", event.getLoggerName());
        if (!this.mdcFields.isEmpty() && !event.getMDCPropertyMap().isEmpty()) {
            for (Map.Entry entry : event.getMDCPropertyMap().entrySet()) {
                if (!this.mdcFields.contains(entry.getKey())) continue;
                String type = this.mdcTypes.get(this.mdcFields.indexOf(entry.getKey()));
                meta.put((String)entry.getKey(), this.getMetaValue(type, (String)entry.getValue()));
            }
        }
        line.put("meta", meta);
        HashMap<String, Object> runtime = new HashMap<String, Object>();
        runtime.put("thread", event.getThreadName());
        if (event.hasCallerData() && (callerData = event.getCallerData()).length > 0) {
            StackTraceElement callerContext = callerData[0];
            runtime.put("class", callerContext.getClassName());
            runtime.put("method", callerContext.getMethodName());
            runtime.put("file", callerContext.getFileName());
            runtime.put("line", callerContext.getLineNumber());
        }
        line.put("runtime", runtime);
        return line;
    }

    private Object getMetaValue(String type, String value) {
        try {
            if ("int".equals(type)) {
                return Integer.valueOf(value);
            }
            if ("long".equals(type)) {
                return Long.valueOf(value);
            }
            if ("boolean".equals(type)) {
                return Boolean.valueOf(value);
            }
        }
        catch (NumberFormatException e) {
            this.errorLog.warn("Error getting meta value : {}", (Object)e.getMessage());
        }
        return value;
    }

    public void setEncoder(PatternLayoutEncoder encoder) {
        this.encoder = encoder;
    }

    public void setIngestKey(String ingestKey) {
        this.headers.add((Object)"Authorization", (Object)String.format("Bearer %s", ingestKey));
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setIngestUrl(String ingestUrl) {
        this.ingestUrl = ingestUrl;
    }

    public void setMdcFields(String mdcFields) {
        this.mdcFields = Arrays.asList(mdcFields.split(","));
    }

    public void setMdcTypes(String mdcTypes) {
        this.mdcTypes = Arrays.asList(mdcTypes.split(","));
    }

    public void setConnectTimeout(Long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(Long readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void stop() {
        this.flush();
        super.stop();
    }
}

