/*
 * Decompiled with CFR 0.152.
 */
package com.linkare.jboolexpr;

import com.linkare.jboolexpr.BooleanAndOperation;
import com.linkare.jboolexpr.BooleanExpression;
import com.linkare.jboolexpr.BooleanNotOperation;
import com.linkare.jboolexpr.BooleanOrOperation;
import com.linkare.jboolexpr.BooleanUtil;
import com.linkare.jboolexpr.BooleanXorOperation;
import com.linkare.jboolexpr.IBoolean;
import com.linkare.jboolexpr.MalformedBooleanException;
import com.linkare.jboolexpr.SimpleBoolean;

public final class BooleanExpressionRL
extends BooleanExpression {
    private static final int FALSE_LENGTH = 5;
    private static final int TRUE_LENGTH = 4;
    private String booleanExpression;
    private IBoolean iBoolean;

    BooleanExpressionRL(String newBooleanExpression) throws MalformedBooleanException {
        this.booleanExpression = newBooleanExpression;
        this.iBoolean = this.toIBoolean(BooleanUtil.validAndformat(newBooleanExpression), 0);
    }

    @Override
    public boolean booleanValue() {
        return this.iBoolean.booleanValue();
    }

    private IBoolean toIBoolean(String formatedBooleanExpression, int index) throws MalformedBooleanException {
        int firstChar = this.getFirstChar(formatedBooleanExpression);
        if (new Character((char)firstChar).toString().matches("\\s")) {
            firstChar = 32;
        }
        String substring = this.getSubstringWithoutFirstChar(formatedBooleanExpression);
        switch (firstChar) {
            case 32: {
                return this.toIBoolean(substring, index + 1);
            }
            case 40: {
                String beginToClose = this.getFromBeginToCloseParenthesis(substring, index + 1);
                String closeToEnd = this.getFromCloseParenthesisToEnd(substring, index + 1);
                IBoolean boolBeginToClose = this.toIBoolean(beginToClose, index + 1);
                return this.toIBoolean(boolBeginToClose, closeToEnd, index + 1);
            }
            case 84: {
                return this.toIBoolean(new SimpleBoolean(true), substring, index + 4);
            }
            case 70: {
                return this.toIBoolean(new SimpleBoolean(false), substring, index + 5);
            }
            case 33: {
                IBoolean boolAll = this.toIBoolean(substring, index + 1);
                return new BooleanNotOperation(boolAll);
            }
        }
        throw new MalformedBooleanException("Expected [ (, true, flase, ! ]", index, this.booleanExpression);
    }

    private IBoolean toIBoolean(IBoolean lastIBoolean, String formatedBooleanExpression, int index) throws MalformedBooleanException {
        int firstChar = this.getFirstChar(formatedBooleanExpression);
        if (new Character((char)firstChar).toString().matches("\\s")) {
            firstChar = 32;
        }
        String substring = this.getSubstringWithoutFirstChar(formatedBooleanExpression);
        switch (firstChar) {
            case 32: {
                return this.toIBoolean(lastIBoolean, substring, index + 1);
            }
            case 46: {
                return lastIBoolean;
            }
            case 41: {
                return this.toIBoolean(lastIBoolean, substring, index + 1);
            }
            case 124: {
                return new BooleanOrOperation(lastIBoolean, this.toIBoolean(substring, index + 2));
            }
            case 38: {
                return new BooleanAndOperation(lastIBoolean, this.toIBoolean(substring, index + 2));
            }
            case 94: {
                return new BooleanXorOperation(lastIBoolean, this.toIBoolean(substring, index + 1));
            }
        }
        throw new MalformedBooleanException("Expected [ ' ', ), ||, &&, ^ ]", index, this.booleanExpression);
    }

    private char getFirstChar(String formatedBooleanExpression) {
        if (formatedBooleanExpression.length() == 0) {
            return '.';
        }
        return formatedBooleanExpression.charAt(0);
    }

    private String getSubstringWithoutFirstChar(String formatedBooleanExpression) {
        if (formatedBooleanExpression == null || formatedBooleanExpression.length() == 0) {
            return "";
        }
        return formatedBooleanExpression.substring(1, formatedBooleanExpression.length());
    }

    private String getFromBeginToCloseParenthesis(String formatedBooleanExpression, int index) throws MalformedBooleanException {
        if (formatedBooleanExpression == null || formatedBooleanExpression.length() == 0) {
            return "";
        }
        int fromIndex = 0;
        int toIndex = this.getIndexOfCloseParenthesis(formatedBooleanExpression, index);
        return formatedBooleanExpression.substring(fromIndex, toIndex);
    }

    private String getFromCloseParenthesisToEnd(String formatedBooleanExpression, int index) throws MalformedBooleanException {
        if (formatedBooleanExpression == null || formatedBooleanExpression.length() == 0) {
            return "";
        }
        int fromIndex = this.getIndexOfCloseParenthesis(formatedBooleanExpression, index);
        int toIndex = formatedBooleanExpression.length();
        return formatedBooleanExpression.substring(fromIndex, toIndex);
    }

    private int getIndexOfCloseParenthesis(String formatedBooleanExpression, int index) throws MalformedBooleanException {
        int lastIndexOfOpenParenthesis = this.getIndexOf(formatedBooleanExpression, "(", -1);
        int lastIndexOfCloseParenthesis = this.getIndexOf(formatedBooleanExpression, ")", -1);
        while (lastIndexOfOpenParenthesis != -1 && lastIndexOfOpenParenthesis < lastIndexOfCloseParenthesis) {
            lastIndexOfOpenParenthesis = this.getIndexOf(formatedBooleanExpression, "(", lastIndexOfOpenParenthesis);
            lastIndexOfCloseParenthesis = this.getIndexOf(formatedBooleanExpression, ")", lastIndexOfCloseParenthesis);
        }
        if (lastIndexOfCloseParenthesis == -1) {
            int parenthesisIndex = index + lastIndexOfOpenParenthesis;
            throw new MalformedBooleanException("Have a open parenthesis without a close parenthesis", parenthesisIndex, this.booleanExpression);
        }
        return lastIndexOfCloseParenthesis;
    }

    private int getIndexOf(String formatedBooleanExpression, String searchedString, int fromIndex) {
        int newFromIndex = fromIndex;
        if (newFromIndex == -1) {
            return formatedBooleanExpression.indexOf(searchedString);
        }
        int length = formatedBooleanExpression.length();
        if (++newFromIndex > length) {
            return -1;
        }
        return formatedBooleanExpression.indexOf(searchedString, newFromIndex);
    }

    public String toString() {
        return this.iBoolean.toString();
    }
}

