/*
 * Decompiled with CFR 0.152.
 */
package com.linkare.jboolexpr.test;

import com.linkare.jboolexpr.BooleanExpression;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public final class BooleanExpressionTest
extends Applet
implements TextListener,
ItemListener {
    private static final int MY_HEIGHT = 150;
    private static final int MY_WIDTH = 600;
    private static final int FIELD_BOOLEAN_EXPRESSION_COLUMNS = 34;
    private static final String LR = "Read left to right";
    private static final String RL = "Read right to left";
    private static final long serialVersionUID = 1L;
    private TextField fieldBooleanExpression = new TextField("!true&&false||true", 34);
    private Choice booleanExpresisonType = new Choice();
    private TextArea outResult = new TextArea();

    @Override
    public void init() {
        BorderLayout borderLayout = new BorderLayout();
        this.setLayout(borderLayout);
        Panel input = new Panel();
        input.add(new Label("Boolean expression to evaluate:", 2));
        input.add(this.fieldBooleanExpression);
        input.add(this.booleanExpresisonType);
        this.add((Component)input, "North");
        this.add((Component)this.outResult, "Center");
        this.setSize(600, 150);
        this.booleanExpresisonType.add(LR);
        this.booleanExpresisonType.add(RL);
        this.booleanExpresisonType.addItemListener(this);
        this.fieldBooleanExpression.addTextListener(this);
        this.textValueChanged(null);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.updateTextArea();
    }

    @Override
    public void textValueChanged(TextEvent textEvent) {
        this.updateTextArea();
    }

    private void updateTextArea() {
        String booleanExpression = this.fieldBooleanExpression.getText();
        String selectedItem = this.booleanExpresisonType.getSelectedItem();
        BooleanExpression be = null;
        try {
            if (LR.equals(selectedItem)) {
                be = BooleanExpression.readLeftToRight(booleanExpression);
            } else if (RL.equals(selectedItem)) {
                be = BooleanExpression.readRightToLeft(booleanExpression);
            } else {
                throw new IllegalArgumentException("selectedItem is diferent of 'Read left to right' and 'Read right to left' (selectedItem='" + selectedItem + "')");
            }
            this.outResult.setText(be.toString() + " == " + be.booleanValue());
        }
        catch (Exception e) {
            StringBuilder exceptionText = new StringBuilder();
            String exceptionName = e.getClass().getName();
            exceptionText.append(exceptionName);
            String exceptionMessage = e.getMessage();
            if (exceptionMessage != null) {
                exceptionText.append("\n");
                exceptionText.append(exceptionMessage);
            }
            StackTraceElement[] stackTraceElements = e.getStackTrace();
            for (int i = 0; i < stackTraceElements.length; ++i) {
                String stackTraceElement = stackTraceElements[i].toString();
                if (!stackTraceElement.startsWith(BooleanExpression.class.getPackage().getName())) continue;
                exceptionText.append("\n\t");
                exceptionText.append(stackTraceElements[i]);
            }
            this.outResult.setText(exceptionText.toString());
        }
    }

    public static void main(String[] arg) {
        Frame frame = new Frame("Boolean Expression Demo");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        BooleanExpressionTest test = new BooleanExpressionTest();
        frame.add(test);
        test.init();
        frame.pack();
        frame.setVisible(true);
    }
}

