/*
 * Decompiled with CFR 0.152.
 */
package com.lgou2w.ldk.common;

import com.lgou2w.ldk.common.ComparisonChain;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0016B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0010\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0003H\u0016J\b\u0010\u0015\u001a\u00020\fH\u0016R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lcom/lgou2w/ldk/common/Version;", "", "major", "", "minor", "build", "(III)V", "getBuild", "()I", "getMajor", "getMinor", "version", "", "getVersion", "()Ljava/lang/String;", "compareTo", "other", "equals", "", "", "hashCode", "toString", "Companion", "ldk-common"})
public class Version
implements Comparable<Version> {
    private final int major;
    private final int minor;
    private final int build;
    private static final Pattern VERSION_PATTERN;
    public static final Companion Companion;

    @NotNull
    public String getVersion() {
        return "" + this.major + '.' + this.minor + '.' + this.build;
    }

    @Override
    public int compareTo(@NotNull Version other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return ComparisonChain.Companion.start().compare(this.major, other.major).compare(this.minor, other.minor).compare(this.build, other.build).getResult();
    }

    public int hashCode() {
        int result = Integer.hashCode(this.major);
        result = 31 * result + Integer.hashCode(this.minor);
        result = 31 * result + Integer.hashCode(this.build);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Version) {
            return this.major == ((Version)other).major && this.minor == ((Version)other).minor && this.build == ((Version)other).build;
        }
        return false;
    }

    @NotNull
    public String toString() {
        return "Version(major=" + this.major + ", minor=" + this.minor + ", build=" + this.build + ')';
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int getBuild() {
        return this.build;
    }

    public Version(int major, int minor, int build) {
        this.major = major;
        this.minor = minor;
        this.build = build;
    }

    static {
        Companion = new Companion(null);
        VERSION_PATTERN = Pattern.compile("^(?<major>\\d+)\\.(?<minor>\\d+)\\.(?<build>\\d+)$");
    }

    @JvmStatic
    @NotNull
    public static final Version parse(@NotNull String versionOnly) throws IllegalArgumentException {
        return Companion.parse(versionOnly);
    }

    @JvmStatic
    @Nullable
    public static final Version parseSafely(@Nullable String versionOnly) {
        return Companion.parseSafely(versionOnly);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0014\u0010\u000b\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007R\u001e\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u00a8\u0006\f"}, d2={"Lcom/lgou2w/ldk/common/Version$Companion;", "", "()V", "VERSION_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "VERSION_PATTERN$annotations", "parse", "Lcom/lgou2w/ldk/common/Version;", "versionOnly", "", "parseSafely", "ldk-common"})
    public static final class Companion {
        @JvmStatic
        private static /* synthetic */ void VERSION_PATTERN$annotations() {
        }

        @JvmStatic
        @NotNull
        public final Version parse(@NotNull String versionOnly) throws IllegalArgumentException {
            int n;
            Intrinsics.checkParameterIsNotNull((Object)versionOnly, (String)"versionOnly");
            Matcher matcher = VERSION_PATTERN.matcher(versionOnly);
            if (!matcher.matches()) {
                throw (Throwable)new IllegalArgumentException("Illegal version format, must be: x.y.z");
            }
            String string = matcher.group("major");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"matcher.group(\"major\")");
            String string2 = string;
            boolean bl = false;
            int n2 = Integer.parseInt(string2);
            String string3 = matcher.group("minor");
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"matcher.group(\"minor\")");
            string2 = string3;
            bl = false;
            int n3 = Integer.parseInt(string2);
            String string4 = matcher.group("build");
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"matcher.group(\"build\")");
            string2 = string4;
            bl = false;
            int n4 = n = Integer.parseInt(string2);
            int n5 = n3;
            int n6 = n2;
            return new Version(n6, n5, n4);
        }

        @JvmStatic
        @Nullable
        public final Version parseSafely(@Nullable String versionOnly) {
            Version version;
            if (versionOnly == null || StringsKt.isBlank((CharSequence)versionOnly)) {
                return null;
            }
            try {
                version = this.parse(versionOnly);
            }
            catch (IllegalArgumentException e) {
                version = null;
            }
            return version;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

