/*
 * Decompiled with CFR 0.152.
 */
package com.lgou2w.ldk.common;

import java.util.Comparator;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\u0010\u0007\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b&\u0018\u0000 \u00182\u00020\u0001:\u0003\u0017\u0018\u0019B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0007\u001a\u00020\u0000\"\u000e\b\u0000\u0010\b*\b\u0012\u0004\u0012\u0002H\b0\t2\u0006\u0010\n\u001a\u0002H\b2\u0006\u0010\u000b\u001a\u0002H\bH&\u00a2\u0006\u0002\u0010\fJ;\u0010\u0007\u001a\u00020\u0000\"\u0004\b\u0000\u0010\b2\u0006\u0010\n\u001a\u0002H\b2\u0006\u0010\u000b\u001a\u0002H\b2\u0016\u0010\r\u001a\u0012\u0012\u0004\u0012\u0002H\b0\u000ej\b\u0012\u0004\u0012\u0002H\b`\u000fH&\u00a2\u0006\u0002\u0010\u0010J\u0018\u0010\u0007\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u0011H&J\u0018\u0010\u0007\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u0012H&J\u0018\u0010\u0007\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004H&J\u0018\u0010\u0007\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\u0013H&J\u0018\u0010\u0014\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\u0015H&J\u0018\u0010\u0016\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\u0015H&R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001a"}, d2={"Lcom/lgou2w/ldk/common/ComparisonChain;", "", "()V", "result", "", "getResult", "()I", "compare", "T", "", "left", "right", "(Ljava/lang/Comparable;Ljava/lang/Comparable;)Lcom/lgou2w/ldk/common/ComparisonChain;", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/util/Comparator;)Lcom/lgou2w/ldk/common/ComparisonChain;", "", "", "", "compareFalseFirst", "", "compareTrueFirst", "ActiveComparisonChain", "Companion", "InactiveComparisonChain", "ldk-common"})
public abstract class ComparisonChain {
    private static final ComparisonChain ACTIVE;
    private static final ComparisonChain LESS;
    private static final ComparisonChain GREATER;
    public static final Companion Companion;

    @NotNull
    public abstract <T extends Comparable<? super T>> ComparisonChain compare(@NotNull T var1, @NotNull T var2);

    @NotNull
    public abstract <T> ComparisonChain compare(T var1, T var2, @NotNull Comparator<T> var3);

    @NotNull
    public abstract ComparisonChain compare(int var1, int var2);

    @NotNull
    public abstract ComparisonChain compare(long var1, long var3);

    @NotNull
    public abstract ComparisonChain compare(float var1, float var2);

    @NotNull
    public abstract ComparisonChain compare(double var1, double var3);

    @NotNull
    public abstract ComparisonChain compareTrueFirst(boolean var1, boolean var2);

    @NotNull
    public abstract ComparisonChain compareFalseFirst(boolean var1, boolean var2);

    public abstract int getResult();

    private ComparisonChain() {
    }

    static {
        Companion = new Companion(null);
        ACTIVE = new ActiveComparisonChain();
        LESS = new InactiveComparisonChain(-1);
        GREATER = new InactiveComparisonChain(1);
    }

    public /* synthetic */ ComparisonChain(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @JvmStatic
    @NotNull
    public static final ComparisonChain start() {
        return Companion.start();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\u0010\u0007\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J-\u0010\b\u001a\u00020\u0001\"\u000e\b\u0000\u0010\t*\b\u0012\u0004\u0012\u0002H\t0\n2\u0006\u0010\u000b\u001a\u0002H\t2\u0006\u0010\f\u001a\u0002H\tH\u0016\u00a2\u0006\u0002\u0010\rJ;\u0010\b\u001a\u00020\u0001\"\u0004\b\u0000\u0010\t2\u0006\u0010\u000b\u001a\u0002H\t2\u0006\u0010\f\u001a\u0002H\t2\u0016\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u0002H\t0\u000fj\b\u0012\u0004\u0012\u0002H\t`\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010\b\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u0012H\u0016J\u0018\u0010\b\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u0013H\u0016J\u0018\u0010\b\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0016J\u0018\u0010\b\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\u0016H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lcom/lgou2w/ldk/common/ComparisonChain$ActiveComparisonChain;", "Lcom/lgou2w/ldk/common/ComparisonChain;", "()V", "result", "", "getResult", "()I", "classify", "compare", "T", "", "left", "right", "(Ljava/lang/Comparable;Ljava/lang/Comparable;)Lcom/lgou2w/ldk/common/ComparisonChain;", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/util/Comparator;)Lcom/lgou2w/ldk/common/ComparisonChain;", "", "", "", "compareFalseFirst", "", "compareTrueFirst", "ldk-common"})
    private static final class ActiveComparisonChain
    extends ComparisonChain {
        private final int result = 0;

        @Override
        @NotNull
        public <T extends Comparable<? super T>> ComparisonChain compare(@NotNull T left, @NotNull T right) {
            Intrinsics.checkParameterIsNotNull(left, (String)"left");
            Intrinsics.checkParameterIsNotNull(right, (String)"right");
            return this.classify(left.compareTo(right));
        }

        @Override
        @NotNull
        public <T> ComparisonChain compare(T left, T right, @NotNull Comparator<T> comparator) {
            Intrinsics.checkParameterIsNotNull(comparator, (String)"comparator");
            return this.classify(comparator.compare(left, right));
        }

        @Override
        @NotNull
        public ComparisonChain compare(int left, int right) {
            return this.classify(Intrinsics.compare((int)left, (int)right));
        }

        @Override
        @NotNull
        public ComparisonChain compare(long left, long right) {
            return this.classify(left == right ? 0 : (left < right ? -1 : 1));
        }

        @Override
        @NotNull
        public ComparisonChain compare(float left, float right) {
            return this.classify(Float.compare(left, right));
        }

        @Override
        @NotNull
        public ComparisonChain compare(double left, double right) {
            return this.classify(Double.compare(left, right));
        }

        @Override
        @NotNull
        public ComparisonChain compareTrueFirst(boolean left, boolean right) {
            return this.classify(Intrinsics.compare((int)(right ? 1 : 0), (int)(left ? 1 : 0)));
        }

        @Override
        @NotNull
        public ComparisonChain compareFalseFirst(boolean left, boolean right) {
            return this.classify(Intrinsics.compare((int)(left ? 1 : 0), (int)(right ? 1 : 0)));
        }

        @Override
        public int getResult() {
            return this.result;
        }

        private final ComparisonChain classify(int result) {
            return result < 0 ? LESS : (result > 0 ? GREATER : ACTIVE);
        }

        public ActiveComparisonChain() {
            super(null);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\u0010\u0007\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J-\u0010\u0007\u001a\u00020\u0001\"\u000e\b\u0000\u0010\b*\b\u0012\u0004\u0012\u0002H\b0\t2\u0006\u0010\n\u001a\u0002H\b2\u0006\u0010\u000b\u001a\u0002H\bH\u0016\u00a2\u0006\u0002\u0010\fJ;\u0010\u0007\u001a\u00020\u0001\"\u0004\b\u0000\u0010\b2\u0006\u0010\n\u001a\u0002H\b2\u0006\u0010\u000b\u001a\u0002H\b2\u0016\u0010\r\u001a\u0012\u0012\u0004\u0012\u0002H\b0\u000ej\b\u0012\u0004\u0012\u0002H\b`\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010J\u0018\u0010\u0007\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u0011H\u0016J\u0018\u0010\u0007\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u0012H\u0016J\u0018\u0010\u0007\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J\u0018\u0010\u0007\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\u0015H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lcom/lgou2w/ldk/common/ComparisonChain$InactiveComparisonChain;", "Lcom/lgou2w/ldk/common/ComparisonChain;", "result", "", "(I)V", "getResult", "()I", "compare", "T", "", "left", "right", "(Ljava/lang/Comparable;Ljava/lang/Comparable;)Lcom/lgou2w/ldk/common/ComparisonChain;", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/util/Comparator;)Lcom/lgou2w/ldk/common/ComparisonChain;", "", "", "", "compareFalseFirst", "", "compareTrueFirst", "ldk-common"})
    private static final class InactiveComparisonChain
    extends ComparisonChain {
        private final int result;

        @Override
        @NotNull
        public <T extends Comparable<? super T>> ComparisonChain compare(@NotNull T left, @NotNull T right) {
            Intrinsics.checkParameterIsNotNull(left, (String)"left");
            Intrinsics.checkParameterIsNotNull(right, (String)"right");
            return this;
        }

        @Override
        @NotNull
        public <T> ComparisonChain compare(T left, T right, @NotNull Comparator<T> comparator) {
            Intrinsics.checkParameterIsNotNull(comparator, (String)"comparator");
            return this;
        }

        @Override
        @NotNull
        public ComparisonChain compare(int left, int right) {
            return this;
        }

        @Override
        @NotNull
        public ComparisonChain compare(long left, long right) {
            return this;
        }

        @Override
        @NotNull
        public ComparisonChain compare(float left, float right) {
            return this;
        }

        @Override
        @NotNull
        public ComparisonChain compare(double left, double right) {
            return this;
        }

        @Override
        @NotNull
        public ComparisonChain compareTrueFirst(boolean left, boolean right) {
            return this;
        }

        @Override
        @NotNull
        public ComparisonChain compareFalseFirst(boolean left, boolean right) {
            return this;
        }

        @Override
        public int getResult() {
            return this.result;
        }

        public InactiveComparisonChain(int result) {
            super(null);
            this.result = result;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/lgou2w/ldk/common/ComparisonChain$Companion;", "", "()V", "ACTIVE", "Lcom/lgou2w/ldk/common/ComparisonChain;", "GREATER", "LESS", "start", "ldk-common"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final ComparisonChain start() {
            return ACTIVE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

