/*
 * Decompiled with CFR 0.152.
 */
package com.lgou2w.ldk.bukkit.version;

import com.lgou2w.ldk.bukkit.version.Level;
import com.lgou2w.ldk.common.ComparisonChain;
import com.lgou2w.ldk.common.Version;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00192\u00020\u00012\b\u0012\u0004\u0012\u00020\u00010\u0002:\u0001\u0019B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0001H\u0096\u0002J\u0013\u0010\u0015\u001a\u00020\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J\b\u0010\u0017\u001a\u00020\u0004H\u0016J\b\u0010\u0018\u001a\u00020\u0010H\u0016R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0015\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001a"}, d2={"Lcom/lgou2w/ldk/bukkit/version/MinecraftVersion;", "Lcom/lgou2w/ldk/common/Version;", "", "major", "", "minor", "build", "pre", "(IIILjava/lang/Integer;)V", "isPre", "", "()Z", "getPre", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "version", "", "getVersion", "()Ljava/lang/String;", "compareTo", "other", "equals", "", "hashCode", "toString", "Companion", "ldk-bukkit-version"})
public final class MinecraftVersion
extends Version
implements Comparable<Version> {
    @Nullable
    private final Integer pre;
    @JvmField
    @NotNull
    public static final MinecraftVersion UNKNOWN;
    @JvmField
    @NotNull
    public static final MinecraftVersion V1_8;
    @JvmField
    @NotNull
    public static final MinecraftVersion V1_9;
    @JvmField
    @NotNull
    public static final MinecraftVersion V1_10;
    @JvmField
    @NotNull
    public static final MinecraftVersion V1_11;
    @JvmField
    @NotNull
    public static final MinecraftVersion V1_12;
    @JvmField
    @NotNull
    public static final MinecraftVersion V1_13;
    @JvmField
    @NotNull
    public static final MinecraftVersion V1_14;
    @JvmField
    @NotNull
    public static final MinecraftVersion V1_15;
    private static final Pattern VERSION_PATTERN;
    @NotNull
    private static MinecraftVersion CURRENT;
    private static final Map<Level, MinecraftVersion> LOOKUP_LEVEL;
    public static final Companion Companion;

    public final boolean isPre() {
        return this.pre != null;
    }

    @NotNull
    public String getVersion() {
        return this.pre != null ? super.getVersion() + "-pre" + this.pre : super.getVersion();
    }

    @Override
    public int compareTo(@NotNull Version other) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        if (other instanceof MinecraftVersion) {
            Integer n2 = this.pre;
            Integer n3 = ((MinecraftVersion)other).pre;
            n = ComparisonChain.Companion.start().compare(this.getMajor(), other.getMajor()).compare(this.getMinor(), other.getMinor()).compare(this.getBuild(), other.getBuild()).compare(n2 != null ? n2 : -1, n3 != null ? n3 : -1).getResult();
        } else {
            n = super.compareTo(other);
        }
        return n;
    }

    public int hashCode() {
        int result = super.hashCode();
        Integer n = this.pre;
        result = 31 * result + (n != null ? Integer.hashCode(n) : 0);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof MinecraftVersion) {
            return super.equals(other) && Intrinsics.areEqual((Object)this.pre, (Object)((MinecraftVersion)other).pre);
        }
        return false;
    }

    @NotNull
    public String toString() {
        return "MinecraftVersion(major=" + this.getMajor() + ", minor=" + this.getMinor() + ", build=" + this.getBuild() + ", pre=" + this.pre + ')';
    }

    @Nullable
    public final Integer getPre() {
        return this.pre;
    }

    public MinecraftVersion(int major, int minor, int build, @Nullable Integer pre) {
        super(major, minor, build);
        this.pre = pre;
    }

    public /* synthetic */ MinecraftVersion(int n, int n2, int n3, Integer n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 8) != 0) {
            n4 = null;
        }
        this(n, n2, n3, n4);
    }

    static {
        Companion = new Companion(null);
        UNKNOWN = new MinecraftVersion(-1, -1, -1, -1);
        V1_8 = new MinecraftVersion(1, 8, 0, null, 8, null);
        V1_9 = new MinecraftVersion(1, 9, 0, null, 8, null);
        V1_10 = new MinecraftVersion(1, 10, 0, null, 8, null);
        V1_11 = new MinecraftVersion(1, 11, 0, null, 8, null);
        V1_12 = new MinecraftVersion(1, 12, 0, null, 8, null);
        V1_13 = new MinecraftVersion(1, 13, 0, null, 8, null);
        V1_14 = new MinecraftVersion(1, 14, 0, null, 8, null);
        V1_15 = new MinecraftVersion(1, 15, 0, null, 8, null);
        VERSION_PATTERN = Pattern.compile(".*\\(.*MC.\\s*([a-zA-Z0-9\\-.]+)\\s*\\)");
        CURRENT = UNKNOWN;
        Map map2 = Collections.unmodifiableMap(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)((Object)Level.Minecraft_V1_8), (Object)V1_8), TuplesKt.to((Object)((Object)Level.Minecraft_V1_9), (Object)V1_9), TuplesKt.to((Object)((Object)Level.Minecraft_V1_10), (Object)V1_10), TuplesKt.to((Object)((Object)Level.Minecraft_V1_11), (Object)V1_11), TuplesKt.to((Object)((Object)Level.Minecraft_V1_12), (Object)V1_12), TuplesKt.to((Object)((Object)Level.Minecraft_V1_13), (Object)V1_13), TuplesKt.to((Object)((Object)Level.Minecraft_V1_14), (Object)V1_14), TuplesKt.to((Object)((Object)Level.Minecraft_V1_15), (Object)V1_15)}));
        Intrinsics.checkExpressionValueIsNotNull(map2, (String)"Collections.unmodifiable\u2026 V1_15\n                ))");
        LOOKUP_LEVEL = map2;
    }

    @NotNull
    public static final MinecraftVersion getCURRENT() {
        return Companion.getCURRENT();
    }

    private static final void setCURRENT(MinecraftVersion minecraftVersion) {
        Companion companion = Companion;
        CURRENT = minecraftVersion;
    }

    @JvmStatic
    @NotNull
    public static final MinecraftVersion fromLevel(@NotNull Level level) {
        return Companion.fromLevel(level);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\rH\u0007R,\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048F@BX\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\"\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00040\f8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000e\u0010\u0002R\u0010\u0010\u000f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0018\u001a\n \u001a*\u0004\u0018\u00010\u00190\u00198\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001b\u0010\u0002\u00a8\u0006\u001e"}, d2={"Lcom/lgou2w/ldk/bukkit/version/MinecraftVersion$Companion;", "", "()V", "<set-?>", "Lcom/lgou2w/ldk/bukkit/version/MinecraftVersion;", "CURRENT", "CURRENT$annotations", "getCURRENT", "()Lcom/lgou2w/ldk/bukkit/version/MinecraftVersion;", "setCURRENT", "(Lcom/lgou2w/ldk/bukkit/version/MinecraftVersion;)V", "LOOKUP_LEVEL", "", "Lcom/lgou2w/ldk/bukkit/version/Level;", "LOOKUP_LEVEL$annotations", "UNKNOWN", "V1_10", "V1_11", "V1_12", "V1_13", "V1_14", "V1_15", "V1_8", "V1_9", "VERSION_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "VERSION_PATTERN$annotations", "fromLevel", "level", "ldk-bukkit-version"})
    public static final class Companion {
        @JvmStatic
        private static /* synthetic */ void VERSION_PATTERN$annotations() {
        }

        @JvmStatic
        public static /* synthetic */ void CURRENT$annotations() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final MinecraftVersion getCURRENT() {
            if (Intrinsics.areEqual((Object)CURRENT, (Object)UNKNOWN)) {
                Server server = Bukkit.getServer();
                Intrinsics.checkExpressionValueIsNotNull((Object)server, (String)"Bukkit.getServer()");
                String string = server.getVersion();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Bukkit.getServer().version");
                String version = string;
                Matcher matcher = VERSION_PATTERN.matcher(version);
                if (!matcher.matches() || matcher.group(1) == null) {
                    throw (Throwable)new IllegalStateException("Bukkit Minecraft version number not successfully matched: " + version + '.');
                }
                String versionOnly = matcher.group(1);
                int[] numbers = new int[3];
                Integer pre = null;
                try {
                    List elements;
                    boolean bl;
                    int n;
                    List list;
                    String string2 = versionOnly;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"versionOnly");
                    int index = StringsKt.lastIndexOf$default((CharSequence)string2, (String)"-pre", (int)0, (boolean)false, (int)6, null);
                    if (index == -1) {
                        CharSequence charSequence = versionOnly;
                        Pattern pattern = Pattern.compile("\\.");
                        Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"Pattern.compile(\"\\\\.\")");
                        list = StringsKt.split$default((CharSequence)charSequence, (Pattern)pattern, (int)0, (int)2, null);
                    } else {
                        String string3 = versionOnly;
                        n = 0;
                        bl = false;
                        String string4 = string3.substring(n, index);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        CharSequence charSequence = string4;
                        Pattern pattern = Pattern.compile("\\.");
                        Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"Pattern.compile(\"\\\\.\")");
                        list = elements = StringsKt.split$default((CharSequence)charSequence, (Pattern)pattern, (int)0, (int)2, null);
                    }
                    if (elements.size() == -1) {
                        throw (Throwable)new IllegalStateException("Invalid Bukkit Minecraft version number: " + versionOnly);
                    }
                    int n2 = 0;
                    n = Math.min(numbers.length, elements.size());
                    while (n2 < n) {
                        int n3;
                        String string5;
                        void i;
                        String string6 = (String)elements.get((int)i);
                        void var13_17 = i;
                        int[] nArray = numbers;
                        boolean bl2 = false;
                        String string7 = string6;
                        if (string7 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                        }
                        string6 = string5 = ((Object)StringsKt.trim((CharSequence)string7)).toString();
                        bl2 = false;
                        nArray[var13_17] = n3 = Integer.parseInt(string6);
                        ++i;
                    }
                    if (index != -1) {
                        String string8 = versionOnly;
                        n = index + 4;
                        bl = false;
                        String string9 = string8.substring(n);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"(this as java.lang.String).substring(startIndex)");
                        string8 = string9;
                        n = 0;
                        pre = Integer.parseInt(string8);
                    }
                }
                catch (Exception e) {
                    if (e instanceof NumberFormatException) {
                        throw (Throwable)new IllegalStateException("Unable to parse Bukkit Minecraft version number: " + versionOnly);
                    }
                    throw (Throwable)e;
                }
                CURRENT = new MinecraftVersion(numbers[0], numbers[1], numbers[2], pre);
            }
            return CURRENT;
        }

        private final void setCURRENT(MinecraftVersion minecraftVersion) {
            CURRENT = minecraftVersion;
        }

        @JvmStatic
        private static /* synthetic */ void LOOKUP_LEVEL$annotations() {
        }

        @JvmStatic
        @NotNull
        public final MinecraftVersion fromLevel(@NotNull Level level) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)level), (String)"level");
            MinecraftVersion value = (MinecraftVersion)LOOKUP_LEVEL.get((Object)level);
            MinecraftVersion minecraftVersion = value;
            if (minecraftVersion == null) {
                minecraftVersion = UNKNOWN;
            }
            return minecraftVersion;
        }

        private Companion() {
        }

        public static final /* synthetic */ MinecraftVersion access$getCURRENT$p(Companion $this) {
            return $this.getCURRENT();
        }

        public static final /* synthetic */ void access$setCURRENT$p(Companion $this, MinecraftVersion minecraftVersion) {
            $this.setCURRENT(minecraftVersion);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

