/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest;

import java.io.File;
import java.nio.file.CopyOption;
import java.time.Instant;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import kong.unirest.Body;
import kong.unirest.Callback;
import kong.unirest.Cookie;
import kong.unirest.Empty;
import kong.unirest.GenericType;
import kong.unirest.Headers;
import kong.unirest.HttpMethod;
import kong.unirest.HttpRequestSummary;
import kong.unirest.HttpResponse;
import kong.unirest.JsonNode;
import kong.unirest.ObjectMapper;
import kong.unirest.PagedList;
import kong.unirest.ProgressMonitor;
import kong.unirest.RawResponse;

public interface HttpRequest<R extends HttpRequest> {
    public R routeParam(String var1, String var2);

    public R routeParam(Map<String, Object> var1);

    public R basicAuth(String var1, String var2);

    public R accept(String var1);

    public R responseEncoding(String var1);

    public R header(String var1, String var2);

    public R headerReplace(String var1, String var2);

    public R headers(Map<String, String> var1);

    public R headersReplace(Map<String, String> var1);

    public R cookie(String var1, String var2);

    public R cookie(Cookie var1);

    public R cookie(Collection<Cookie> var1);

    public R queryString(String var1, Object var2);

    public R queryString(String var1, Collection<?> var2);

    public R queryString(Map<String, Object> var1);

    public R withObjectMapper(ObjectMapper var1);

    public R connectTimeout(int var1);

    public R downloadMonitor(ProgressMonitor var1);

    public HttpResponse<String> asString();

    public CompletableFuture<HttpResponse<String>> asStringAsync();

    public CompletableFuture<HttpResponse<String>> asStringAsync(Callback<String> var1);

    public HttpResponse<byte[]> asBytes();

    public CompletableFuture<HttpResponse<byte[]>> asBytesAsync();

    public CompletableFuture<HttpResponse<byte[]>> asBytesAsync(Callback<byte[]> var1);

    public HttpResponse<JsonNode> asJson();

    public CompletableFuture<HttpResponse<JsonNode>> asJsonAsync();

    public CompletableFuture<HttpResponse<JsonNode>> asJsonAsync(Callback<JsonNode> var1);

    public <T> HttpResponse<T> asObject(Class<? extends T> var1);

    public <T> HttpResponse<T> asObject(GenericType<T> var1);

    public <T> HttpResponse<T> asObject(Function<RawResponse, T> var1);

    public <T> CompletableFuture<HttpResponse<T>> asObjectAsync(Class<? extends T> var1);

    public <T> CompletableFuture<HttpResponse<T>> asObjectAsync(Class<? extends T> var1, Callback<T> var2);

    public <T> CompletableFuture<HttpResponse<T>> asObjectAsync(GenericType<T> var1);

    public <T> CompletableFuture<HttpResponse<T>> asObjectAsync(GenericType<T> var1, Callback<T> var2);

    public <T> CompletableFuture<HttpResponse<T>> asObjectAsync(Function<RawResponse, T> var1);

    public HttpResponse<File> asFile(String var1, CopyOption ... var2);

    public CompletableFuture<HttpResponse<File>> asFileAsync(String var1, CopyOption ... var2);

    public CompletableFuture<HttpResponse<File>> asFileAsync(String var1, Callback<File> var2, CopyOption ... var3);

    public <T> PagedList<T> asPaged(Function<HttpRequest, HttpResponse> var1, Function<HttpResponse<T>, String> var2);

    public HttpResponse asEmpty();

    public CompletableFuture<HttpResponse<Empty>> asEmptyAsync();

    public CompletableFuture<HttpResponse<Empty>> asEmptyAsync(Callback<Empty> var1);

    public void thenConsume(Consumer<RawResponse> var1);

    public void thenConsumeAsync(Consumer<RawResponse> var1);

    public HttpMethod getHttpMethod();

    public String getUrl();

    public Headers getHeaders();

    default public Optional<Body> getBody() {
        return Optional.empty();
    }

    public int getConnectTimeout();

    public HttpRequestSummary toSummary();

    public Instant getCreationTime();
}

