/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.hickory.testing;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import net.java.dev.hickory.testing.LocationAndKind;
import net.java.dev.hickory.testing.MemFileManager;
import net.java.dev.hickory.testing.MemJavaFileObject;

final class MemClassLoader
extends ClassLoader {
    private final MemFileManager fileManager;
    final Map<LocationAndKind, Map<String, JavaFileObject>> ramFileSystem;
    private static final LocationAndKind CLASS_KEY = new LocationAndKind(StandardLocation.CLASS_OUTPUT, JavaFileObject.Kind.CLASS);
    private static final LocationAndKind SOURCE_KEY = new LocationAndKind(StandardLocation.CLASS_OUTPUT, JavaFileObject.Kind.SOURCE);
    private static final LocationAndKind OTHER_KEY = new LocationAndKind(StandardLocation.CLASS_OUTPUT, JavaFileObject.Kind.OTHER);

    MemClassLoader(Map<LocationAndKind, Map<String, JavaFileObject>> ramFileSystem, MemFileManager fMgr) {
        this.ramFileSystem = ramFileSystem;
        this.fileManager = fMgr;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        JavaFileObject jfo = this.ramFileSystem.get(CLASS_KEY).get(name);
        if (jfo != null) {
            byte[] bytes = ((MemJavaFileObject)jfo).baos.toByteArray();
            return this.defineClass(name, bytes, 0, bytes.length);
        }
        return super.findClass(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        JavaFileObject jfo = this.getFileObject(name);
        if (jfo != null) {
            byte[] bytes = ((MemJavaFileObject)jfo).baos.toByteArray();
            return new ByteArrayInputStream(bytes);
        }
        return null;
    }

    private JavaFileObject getFileObject(String name) {
        LocationAndKind key = OTHER_KEY;
        if (name.endsWith(JavaFileObject.Kind.CLASS.extension)) {
            name = name.replace(".", "/") + JavaFileObject.Kind.CLASS.extension;
            key = CLASS_KEY;
        } else if (name.endsWith(JavaFileObject.Kind.SOURCE.extension)) {
            name = name.replace(".", "/") + JavaFileObject.Kind.SOURCE.extension;
            key = SOURCE_KEY;
        }
        if (!this.ramFileSystem.containsKey(key)) {
            return null;
        }
        return this.ramFileSystem.get(key).get(name);
    }

    @Override
    protected URL findResource(String name) {
        URL retValue = super.findResource(name);
        if (retValue != null) {
            return retValue;
        }
        JavaFileObject jfo = this.getFileObject(name);
        if (jfo != null) {
            try {
                return jfo.toUri().toURL();
            }
            catch (MalformedURLException ex) {
                return null;
            }
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        ArrayList<URL> retValue = Collections.list(super.getResources(name));
        JavaFileObject jfo = this.getFileObject(name);
        if (jfo != null) {
            retValue.add(jfo.toUri().toURL());
        }
        return Collections.enumeration(retValue);
    }

    MemFileManager getFileManager() {
        return this.fileManager;
    }
}

