/*
 * Decompiled with CFR 0.152.
 */
package com.jeff_media.persistentdataserializer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.bukkit.NamespacedKey;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PersistentDataSerializer {
    private static final Set<PersistentDataType<?, ?>> NATIVE_PRIMITIVE_PERSISTENT_DATA_TYPES = new HashSet();
    private static final Map<String, PersistentDataType<?, ?>> NATIVE_PRIMITIVE_PERSISTENT_DATA_TYPES_BY_NAME = new HashMap();
    private static final Map<PersistentDataType<?, ?>, String> NATIVE_PRIMITIVE_PERSISTENT_DATA_TYPES_BY_CLASS = new HashMap();
    private static final TypeToken<List<Map<String, Object>>> LIST_MAP_TYPE_TOKEN = new TypeToken<List<Map<String, Object>>>(){};
    private static final Gson GSON = new GsonBuilder().create();

    private PersistentDataSerializer() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }

    public static PersistentDataType<?, ?> getPrimitivePersistentDataType(@NotNull PersistentDataContainer pdc, @NotNull NamespacedKey key) throws IllegalArgumentException {
        Objects.requireNonNull(pdc, "pdc cannot be null");
        Objects.requireNonNull(key, "key cannot be null");
        for (PersistentDataType<?, ?> type : NATIVE_PRIMITIVE_PERSISTENT_DATA_TYPES) {
            if (!pdc.has(key, type)) continue;
            return type;
        }
        throw new IllegalArgumentException("Could not find a native PrimitivePersistentDataType for key " + key + " in PersistentDataContainer " + pdc + ". Available native datatypes are " + String.join((CharSequence)", ", NATIVE_PRIMITIVE_PERSISTENT_DATA_TYPES_BY_NAME.keySet()));
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static List<Map<?, ?>> toMapList(@NotNull PersistentDataContainer pdc) {
        Objects.requireNonNull(pdc, "pdc cannot be null");
        ArrayList list = new ArrayList();
        for (NamespacedKey key : pdc.getKeys()) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            PersistentDataType<?, ?> type = PersistentDataSerializer.getPrimitivePersistentDataType(pdc, key);
            List<Map<?, ?>> value = pdc.get(key, type);
            Objects.requireNonNull(value, "value cannot be null");
            if (type.equals((Object)PersistentDataType.TAG_CONTAINER)) {
                value = PersistentDataSerializer.toMapList((PersistentDataContainer)value);
            } else if (type.equals((Object)PersistentDataType.TAG_CONTAINER_ARRAY)) {
                PersistentDataContainer[] containers = (PersistentDataContainer[])value;
                Objects.requireNonNull(containers, "containers cannot be null");
                ArrayList serializedContainers = new ArrayList();
                for (PersistentDataContainer container : containers) {
                    serializedContainers.add((Map<?, ?>)((Object)PersistentDataSerializer.toMapList(container)));
                }
                value = serializedContainers;
            }
            map.put("key", key.toString());
            map.put("type", PersistentDataSerializer.getNativePersistentDataTypeFieldName(type));
            map.put("value", value);
            list.add(map);
        }
        return list;
    }

    @NotNull
    @Contract(value="_, _ -> param2")
    public static PersistentDataContainer fromMapList(@NotNull List<Map<?, ?>> serializedPdc, @NotNull PersistentDataContainer targetPdc) {
        Objects.requireNonNull(targetPdc, "targetPdc cannot be null");
        Objects.requireNonNull(serializedPdc, "serializedPdc cannot be null");
        PersistentDataAdapterContext context = targetPdc.getAdapterContext();
        for (Map<?, ?> map : serializedPdc) {
            NamespacedKey key = NamespacedKey.fromString((String)((String)map.get("key")));
            Objects.requireNonNull(key, "key cannot be null");
            Object value = map.get("value");
            PersistentDataType<?, ?> type = PersistentDataSerializer.getNativePersistentDataTypeByFieldName((String)map.get("type"));
            if (type.equals((Object)PersistentDataType.TAG_CONTAINER)) {
                value = PersistentDataSerializer.fromMapList((List)value, context.newPersistentDataContainer());
            } else if (type.equals((Object)PersistentDataType.TAG_CONTAINER_ARRAY)) {
                List serializedContainers = (List)value;
                PersistentDataContainer[] containers = new PersistentDataContainer[serializedContainers.size()];
                for (int i = 0; i < serializedContainers.size(); ++i) {
                    containers[i] = PersistentDataSerializer.fromMapList((List)serializedContainers.get(i), context.newPersistentDataContainer());
                }
                value = containers;
            } else {
                value = PersistentDataSerializer.cast(value, type);
            }
            targetPdc.set(key, type, value);
        }
        return targetPdc;
    }

    @NotNull
    @Contract(value="_, _ -> new", pure=true)
    public static PersistentDataContainer fromMapList(@NotNull List<Map<?, ?>> serializedPdc, @NotNull PersistentDataAdapterContext context) {
        Objects.requireNonNull(serializedPdc, "serializedPdc cannot be null");
        Objects.requireNonNull(context, "context cannot be null");
        return PersistentDataSerializer.fromMapList(serializedPdc, context.newPersistentDataContainer());
    }

    private static Object cast(@Nullable Object value, @NotNull PersistentDataType<?, ?> type) {
        if (value == null) {
            return null;
        }
        Objects.requireNonNull(type, "type cannot be null");
        Class primitiveType = type.getPrimitiveType();
        if (primitiveType == Float.class) {
            return Float.valueOf(((Number)value).floatValue());
        }
        if (primitiveType == Integer.class) {
            return ((Number)value).intValue();
        }
        if (primitiveType == Double.class) {
            return ((Number)value).doubleValue();
        }
        if (primitiveType == Short.class) {
            return ((Number)value).shortValue();
        }
        if (primitiveType == Byte.class) {
            if (type.getComplexType() == Boolean.class) {
                if (value instanceof Byte) {
                    return (Byte)value == 1;
                }
                if (value instanceof Boolean) {
                    return value;
                }
            } else {
                if (value instanceof Boolean) {
                    return (byte)((Boolean)value != false ? 1 : 0);
                }
                if (value instanceof Number) {
                    return ((Number)value).byteValue();
                }
            }
        } else if (value instanceof List) {
            List list = (List)value;
            int length = list.size();
            if (type == PersistentDataType.BYTE_ARRAY) {
                byte[] arr = new byte[length];
                for (int i = 0; i < length; ++i) {
                    arr[i] = ((Number)list.get(i)).byteValue();
                }
                return arr;
            }
            if (type == PersistentDataType.INTEGER_ARRAY) {
                int[] arr = new int[length];
                for (int i = 0; i < length; ++i) {
                    arr[i] = ((Number)list.get(i)).intValue();
                }
                return arr;
            }
            if (type == PersistentDataType.LONG_ARRAY) {
                long[] arr = new long[length];
                for (int i = 0; i < length; ++i) {
                    arr[i] = ((Number)list.get(i)).longValue();
                }
                return arr;
            }
            throw new IllegalArgumentException("Unknown array type: " + type.getPrimitiveType().getComponentType().getName());
        }
        return value;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static String toJson(@NotNull PersistentDataContainer pdc) {
        Objects.requireNonNull(pdc, "pdc cannot be null");
        return GSON.toJson(PersistentDataSerializer.toMapList(pdc), LIST_MAP_TYPE_TOKEN.getType());
    }

    @Contract(value="_, _ -> param2")
    @NotNull
    public static PersistentDataContainer fromJson(@NotNull String serializedPdc, @NotNull PersistentDataContainer targetPdc) throws JsonSyntaxException {
        Objects.requireNonNull(targetPdc, "targetPdc cannot be null");
        Objects.requireNonNull(serializedPdc, "serializedPdc cannot be null");
        return PersistentDataSerializer.fromMapList((List)GSON.fromJson(serializedPdc, LIST_MAP_TYPE_TOKEN.getType()), targetPdc);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static PersistentDataContainer fromJson(@NotNull String serializedPdc, @NotNull PersistentDataAdapterContext context) throws JsonSyntaxException {
        Objects.requireNonNull(serializedPdc, "serializedPdc cannot be null");
        Objects.requireNonNull(context, "context cannot be null");
        return PersistentDataSerializer.fromMapList((List)GSON.fromJson(serializedPdc, LIST_MAP_TYPE_TOKEN.getType()), context.newPersistentDataContainer());
    }

    @NotNull
    private static PersistentDataType<?, ?> getNativePersistentDataTypeByFieldName(@NotNull String fieldName) throws IllegalArgumentException {
        Objects.requireNonNull(fieldName, "fieldName cannot be null");
        PersistentDataType<?, ?> type = NATIVE_PRIMITIVE_PERSISTENT_DATA_TYPES_BY_NAME.get(fieldName);
        if (type == null) {
            throw new IllegalArgumentException("Could not find native PersistentDataType with field name " + fieldName);
        }
        return type;
    }

    @NotNull
    private static String getNativePersistentDataTypeFieldName(@NotNull PersistentDataType<?, ?> type) throws IllegalArgumentException {
        Objects.requireNonNull(type, "type cannot be null");
        String name = NATIVE_PRIMITIVE_PERSISTENT_DATA_TYPES_BY_CLASS.get(type);
        if (name == null) {
            throw new IllegalArgumentException("Could not find native field name for PersistentDataType with primitive class " + type.getPrimitiveType().getName() + " and complex class " + type.getComplexType().getName());
        }
        return name;
    }

    static {
        for (Field field : PersistentDataType.class.getFields()) {
            if (!PersistentDataType.class.isAssignableFrom(field.getType())) continue;
            try {
                PersistentDataType type = Objects.requireNonNull((PersistentDataType)field.get(null));
                if (!(type instanceof PersistentDataType.PrimitivePersistentDataType)) continue;
                String name = field.getName();
                NATIVE_PRIMITIVE_PERSISTENT_DATA_TYPES.add(type);
                NATIVE_PRIMITIVE_PERSISTENT_DATA_TYPES_BY_NAME.put(name, type);
                NATIVE_PRIMITIVE_PERSISTENT_DATA_TYPES_BY_CLASS.put(type, name);
            }
            catch (IllegalAccessException exception) {
                throw new RuntimeException("Could not access native persistent data type field: " + field.getType().getName(), exception);
            }
        }
    }
}

