/*
 * Decompiled with CFR 0.152.
 */
package com.jeff_media.jsonconfigurationserialization;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.ConfigurationSerialization;

public final class ConfigurationSerializableTypeHierarchyAdapter
implements JsonSerializer<ConfigurationSerializable>,
JsonDeserializer<ConfigurationSerializable> {
    private static final String SERIALIZED_TYPE_KEY = "==";
    static final TypeToken<Map<String, Object>> MAP_TYPE = new TypeToken<Map<String, Object>>(){};

    static ConfigurationSerializable deserializeFromMap(Map<String, Object> map) throws IllegalArgumentException {
        ConfigurationSerializableTypeHierarchyAdapter.deserializeInner(map);
        return ConfigurationSerialization.deserializeObject(map);
    }

    static Map<String, Object> serializeToMap(ConfigurationSerializable serializable) {
        HashMap<String, Object> map = new HashMap<String, Object>(serializable.serialize());
        map.put(SERIALIZED_TYPE_KEY, ConfigurationSerialization.getAlias(serializable.getClass()));
        ConfigurationSerializableTypeHierarchyAdapter.serializeInner(map);
        return map;
    }

    private static void serializeInner(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (!(entry.getValue() instanceof ConfigurationSerializable)) continue;
            HashMap<String, Object> innerMap = new HashMap<String, Object>(((ConfigurationSerializable)entry.getValue()).serialize());
            innerMap.put(SERIALIZED_TYPE_KEY, ConfigurationSerialization.getAlias(entry.getValue().getClass()));
            ConfigurationSerializableTypeHierarchyAdapter.serializeInner(innerMap);
            entry.setValue(innerMap);
        }
    }

    private static void deserializeInner(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object raw = entry.getValue();
            if (raw instanceof Map) {
                Map innerMap = (Map)raw;
                ConfigurationSerializableTypeHierarchyAdapter.deserializeInner(innerMap);
                if (!innerMap.containsKey(SERIALIZED_TYPE_KEY)) continue;
                String alias = (String)innerMap.get(SERIALIZED_TYPE_KEY);
                Class clazz = ConfigurationSerialization.getClassByAlias((String)alias);
                if (clazz != null) {
                    ConfigurationSerializable serializable = ConfigurationSerialization.deserializeObject((Map)innerMap, (Class)clazz);
                    entry.setValue(serializable);
                    continue;
                }
                throw new IllegalArgumentException("Could not find class by alias: " + alias);
            }
            if (!(raw instanceof Number)) continue;
            Number number = (Number)raw;
            entry.setValue(ConfigurationSerializableTypeHierarchyAdapter.narrowNumberType(number));
        }
    }

    private static Number narrowNumberType(Number number) {
        long asLong = number.longValue();
        if (number.doubleValue() == (double)asLong) {
            if (asLong > Integer.MAX_VALUE || asLong < Integer.MIN_VALUE) {
                return asLong;
            }
            return number.intValue();
        }
        return number;
    }

    public JsonElement serialize(ConfigurationSerializable configurationSerializable, Type type, JsonSerializationContext jsonSerializationContext) {
        return jsonSerializationContext.serialize(ConfigurationSerializableTypeHierarchyAdapter.serializeToMap(configurationSerializable), MAP_TYPE.getType());
    }

    public ConfigurationSerializable deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        return ConfigurationSerializableTypeHierarchyAdapter.deserializeFromMap((Map)jsonDeserializationContext.deserialize(jsonElement, MAP_TYPE.getType()));
    }
}

