/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.jdbc;

import com.jcabi.jdbc.Outcome;
import com.jcabi.jdbc.Utc;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;

public final class SingleOutcome<T>
implements Outcome<T> {
    private final transient String type;
    private final transient boolean silently;

    public SingleOutcome(Class<T> tpe) {
        this(tpe, false);
    }

    public SingleOutcome(Class<T> tpe, boolean slnt) {
        if (!(tpe.equals(String.class) || tpe.equals(Long.class) || tpe.equals(Boolean.class) || tpe.equals(Byte.class) || tpe.equals(Date.class) || tpe.equals(Utc.class) || byte[].class.equals(tpe))) {
            throw new IllegalArgumentException(String.format("type %s is not supported", tpe.getName()));
        }
        this.type = tpe.getName();
        this.silently = slnt;
    }

    @Override
    public T handle(ResultSet rset, Statement stmt) throws SQLException {
        T result = null;
        if (rset.next()) {
            result = this.fetch(rset);
        } else if (!this.silently) {
            throw new SQLException("no records found");
        }
        return result;
    }

    private T fetch(ResultSet rset) throws SQLException {
        Object result;
        Class<?> tpe;
        block9: {
            try {
                tpe = Class.forName(this.type);
                if (tpe.equals(String.class)) {
                    result = rset.getString(1);
                    break block9;
                }
                if (tpe.equals(Long.class)) {
                    result = rset.getLong(1);
                    break block9;
                }
                if (tpe.equals(Boolean.class)) {
                    result = rset.getBoolean(1);
                    break block9;
                }
                if (tpe.equals(Byte.class)) {
                    result = rset.getByte(1);
                    break block9;
                }
                if (tpe.equals(Date.class)) {
                    result = rset.getDate(1);
                    break block9;
                }
                if (tpe.equals(Utc.class)) {
                    result = new Utc(Utc.getTimestamp(rset, 1));
                    break block9;
                }
                if (byte[].class.equals(tpe)) {
                    result = rset.getBytes(1);
                    break block9;
                }
                throw new IllegalStateException(String.format("type %s is not allowed", tpe.getName()));
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalArgumentException(String.format("Unknown type: %s", this.type), ex);
            }
        }
        return (T)tpe.cast(result);
    }

    public String toString() {
        return "SingleOutcome(type=" + this.type + ", silently=" + this.silently + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SingleOutcome)) {
            return false;
        }
        SingleOutcome other = (SingleOutcome)o;
        String this$type = this.type;
        String other$type = other.type;
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        return this.silently == other.silently;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.type;
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        result = result * 59 + (this.silently ? 79 : 97);
        return result;
    }
}

