/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public interface Outcome<T> {
    public static final Outcome<Boolean> NOT_EMPTY = new Outcome<Boolean>(){

        @Override
        public Boolean handle(ResultSet rset, Statement stmt) throws SQLException {
            return rset.next();
        }
    };
    public static final Outcome<Void> VOID = new Outcome<Void>(){

        @Override
        public Void handle(ResultSet rset, Statement stmt) {
            return null;
        }
    };
    public static final Outcome<Integer> UPDATE_COUNT = new Outcome<Integer>(){

        @Override
        public Integer handle(ResultSet rset, Statement stmt) throws SQLException {
            return stmt.getUpdateCount();
        }
    };
    public static final Outcome<Long> LAST_INSERT_ID = new Outcome<Long>(){

        @Override
        public Long handle(ResultSet rset, Statement stmt) throws SQLException {
            if (!rset.next()) {
                throw new SQLException("no last_insert_id() available");
            }
            return rset.getLong(1);
        }
    };

    public T handle(ResultSet var1, Statement var2) throws SQLException;
}

