/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.jdbc;

import com.jcabi.jdbc.Outcome;
import com.jcabi.jdbc.Utc;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;

public final class ColumnOutcome<T>
implements Outcome<Collection<T>> {
    private final transient String type;

    public ColumnOutcome(Class<T> tpe) {
        if (!(tpe.equals(String.class) || tpe.equals(Long.class) || tpe.equals(Boolean.class) || tpe.equals(Byte.class) || tpe.equals(Date.class) || tpe.equals(Utc.class) || byte[].class.equals(tpe))) {
            throw new IllegalArgumentException(String.format("type %s is not supported", tpe.getName()));
        }
        this.type = tpe.getName();
    }

    @Override
    public Collection<T> handle(ResultSet rset, Statement stmt) throws SQLException {
        LinkedList<T> result = new LinkedList<T>();
        while (rset.next()) {
            result.add(this.fetch(rset));
        }
        return result;
    }

    private T fetch(ResultSet rset) throws SQLException {
        Object result;
        Class<?> tpe;
        block9: {
            try {
                tpe = Class.forName(this.type);
                if (tpe.equals(String.class)) {
                    result = rset.getString(1);
                    break block9;
                }
                if (tpe.equals(Long.class)) {
                    result = rset.getLong(1);
                    break block9;
                }
                if (tpe.equals(Boolean.class)) {
                    result = rset.getBoolean(1);
                    break block9;
                }
                if (tpe.equals(Byte.class)) {
                    result = rset.getByte(1);
                    break block9;
                }
                if (tpe.equals(Date.class)) {
                    result = rset.getDate(1);
                    break block9;
                }
                if (tpe.equals(Utc.class)) {
                    result = new Utc(Utc.getTimestamp(rset, 1));
                    break block9;
                }
                if (byte[].class.equals(tpe)) {
                    result = rset.getBytes(1);
                    break block9;
                }
                throw new IllegalStateException(String.format("type %s is not allowed", tpe.getName()));
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalArgumentException(String.format("Unknown type: %s", this.type), ex);
            }
        }
        return (T)tpe.cast(result);
    }

    public String toString() {
        return "ColumnOutcome(type=" + this.type + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColumnOutcome)) {
            return false;
        }
        ColumnOutcome other = (ColumnOutcome)o;
        String this$type = this.type;
        String other$type = other.type;
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.type;
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }
}

