/*
 * Decompiled with CFR 0.152.
 */
package com.jaredsburrows.retrofit2.adapter.synchronous;

import java.io.IOException;
import java.lang.reflect.Type;
import okhttp3.MediaType;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Response;

final class SynchronousResponseCallAdapter<R>
implements CallAdapter<R, Response<R>> {
    private static final MediaType DEFAULT_MEDIA_TYPE = MediaType.get((String)"text/plain");
    private static final String DEFAULT_EMPTY_CONTENT = "";
    private final Type responseType;

    SynchronousResponseCallAdapter(Type responseType) {
        this.responseType = responseType;
    }

    public Type responseType() {
        return this.responseType;
    }

    public Response<R> adapt(Call<R> call) {
        Response response;
        try {
            response = call.execute();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (response.isSuccessful()) {
            return Response.success((Object)response.body(), (okhttp3.Response)response.raw());
        }
        ResponseBody errorBody = response.errorBody();
        okhttp3.Response raw = response.raw();
        if (errorBody == null) {
            return Response.error((ResponseBody)ResponseBody.create((MediaType)DEFAULT_MEDIA_TYPE, (String)DEFAULT_EMPTY_CONTENT), (okhttp3.Response)raw);
        }
        return Response.error((ResponseBody)errorBody, (okhttp3.Response)raw);
    }
}

