/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util.query;

import com.google.common.base.Preconditions;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.Rating;
import com.plotsquared.core.plot.flag.implementations.DoneFlag;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.util.MathMan;
import com.plotsquared.core.util.query.AliasFilter;
import com.plotsquared.core.util.query.AreaLimitedPlotProvider;
import com.plotsquared.core.util.query.ExpiredPlotProvider;
import com.plotsquared.core.util.query.FixedPlotProvider;
import com.plotsquared.core.util.query.GlobalPlotProvider;
import com.plotsquared.core.util.query.HasOwnerFilter;
import com.plotsquared.core.util.query.MemberFilter;
import com.plotsquared.core.util.query.NullProvider;
import com.plotsquared.core.util.query.OwnerFilter;
import com.plotsquared.core.util.query.OwnersIncludeFilter;
import com.plotsquared.core.util.query.PaginatedPlotResult;
import com.plotsquared.core.util.query.PlotFilter;
import com.plotsquared.core.util.query.PlotProvider;
import com.plotsquared.core.util.query.PredicateFilter;
import com.plotsquared.core.util.query.SearchPlotProvider;
import com.plotsquared.core.util.query.SortingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class PlotQuery
implements Iterable<Plot> {
    private final Collection<PlotFilter> filters = new LinkedList<PlotFilter>();
    private final PlotAreaManager plotAreaManager;
    private PlotProvider plotProvider;
    private SortingStrategy sortingStrategy = SortingStrategy.NO_SORTING;
    private PlotArea priorityArea;
    private Comparator<Plot> plotComparator;

    private PlotQuery(@NonNull PlotAreaManager plotAreaManager) {
        this.plotAreaManager = plotAreaManager;
        this.plotProvider = new GlobalPlotProvider(plotAreaManager);
    }

    public static PlotQuery newQuery() {
        return new PlotQuery(PlotSquared.get().getPlotAreaManager());
    }

    public @NonNull PlotQuery inArea(@NonNull PlotArea area) {
        Preconditions.checkNotNull((Object)area, (Object)"Area may not be null");
        this.plotProvider = new AreaLimitedPlotProvider(Collections.singletonList(area));
        return this;
    }

    public @NonNull PlotQuery inWorld(@NonNull String world) {
        Preconditions.checkNotNull((Object)world, (Object)"World may not be null");
        this.plotProvider = new AreaLimitedPlotProvider(this.plotAreaManager.getPlotAreasSet(world));
        return this;
    }

    public @NonNull PlotQuery inAreas(@NonNull Collection<PlotArea> areas) {
        Preconditions.checkNotNull(areas, (Object)"Areas may not be null");
        Preconditions.checkState((!areas.isEmpty() ? 1 : 0) != 0, (Object)"At least one area must be provided");
        this.plotProvider = new AreaLimitedPlotProvider(Collections.unmodifiableCollection(areas));
        return this;
    }

    public @NonNull PlotQuery expiredPlots() {
        this.plotProvider = new ExpiredPlotProvider();
        return this;
    }

    public @NonNull PlotQuery allPlots() {
        this.plotProvider = new GlobalPlotProvider(this.plotAreaManager);
        return this;
    }

    public @NonNull PlotQuery noPlots() {
        this.plotProvider = new NullProvider();
        return this;
    }

    public @NonNull PlotQuery plotsBySearch(@NonNull String searchTerm) {
        Preconditions.checkNotNull((Object)searchTerm, (Object)"Search term may not be null");
        this.plotProvider = new SearchPlotProvider(searchTerm);
        return this;
    }

    public @NonNull PlotQuery withPlot(@NonNull Plot plot) {
        Preconditions.checkNotNull((Object)plot, (Object)"Plot may not be null");
        this.plotProvider = new FixedPlotProvider(plot);
        return this;
    }

    public @NonNull PlotQuery whereBasePlot() {
        return this.addFilter(new PredicateFilter(Plot::isBasePlot));
    }

    public @NonNull PlotQuery ownedBy(@NonNull UUID owner) {
        Preconditions.checkNotNull((Object)owner, (Object)"Owner may not be null");
        return this.addFilter(new OwnerFilter(owner));
    }

    public @NonNull PlotQuery ownedBy(@NonNull PlotPlayer<?> owner) {
        Preconditions.checkNotNull(owner, (Object)"Owner may not be null");
        return this.addFilter(new OwnerFilter(owner.getUUID()));
    }

    public @NonNull PlotQuery ownersInclude(@NonNull UUID owner) {
        Preconditions.checkNotNull((Object)owner, (Object)"Owner may not be null");
        return this.addFilter(new OwnersIncludeFilter(owner));
    }

    public @NonNull PlotQuery ownersInclude(@NonNull PlotPlayer<?> owner) {
        Preconditions.checkNotNull(owner, (Object)"Owner may not be null");
        return this.addFilter(new OwnersIncludeFilter(owner.getUUID()));
    }

    public @NonNull PlotQuery hasOwner() {
        return this.addFilter(new HasOwnerFilter());
    }

    public @NonNull PlotQuery withAlias(@NonNull String alias) {
        Preconditions.checkNotNull((Object)alias, (Object)"Alias may not be null");
        return this.addFilter(new AliasFilter(alias));
    }

    public @NonNull PlotQuery withMember(@NonNull UUID member) {
        Preconditions.checkNotNull((Object)member, (Object)"Member may not be null");
        return this.addFilter(new MemberFilter(member));
    }

    public @NonNull PlotQuery thatPasses(@NonNull Predicate<Plot> predicate) {
        Preconditions.checkNotNull(predicate, (Object)"Predicate may not be null");
        return this.addFilter(new PredicateFilter(predicate));
    }

    public @NonNull PlotQuery withSortingStrategy(@NonNull SortingStrategy strategy) {
        Preconditions.checkNotNull((Object)((Object)strategy), (Object)"Strategy may not be null");
        this.sortingStrategy = strategy;
        return this;
    }

    public @NonNull PlotQuery sorted(@NonNull Comparator<Plot> comparator) {
        Preconditions.checkNotNull(comparator, (Object)"Comparator may not be null");
        this.sortingStrategy = SortingStrategy.COMPARATOR;
        this.plotComparator = comparator;
        return this;
    }

    public @NonNull PlotQuery relativeToArea(@NonNull PlotArea plotArea) {
        Preconditions.checkNotNull((Object)plotArea, (Object)"Area may not be null");
        this.priorityArea = plotArea;
        return this;
    }

    public @NonNull Stream<Plot> asStream() {
        return this.asList().stream();
    }

    public @NonNull List<Plot> asList() {
        ArrayList<Plot> result;
        if (this.filters.isEmpty()) {
            result = new ArrayList<Plot>(this.plotProvider.getPlots());
        } else {
            Collection<Plot> plots = this.plotProvider.getPlots();
            result = new ArrayList(plots.size());
            block0: for (Plot plot : plots) {
                for (PlotFilter filter : this.filters) {
                    if (filter.accepts(plot)) continue;
                    continue block0;
                }
                result.add(plot);
            }
        }
        if (this.sortingStrategy == SortingStrategy.NO_SORTING) {
            return result;
        }
        if (this.sortingStrategy == SortingStrategy.SORT_BY_TEMP) {
            return PlotSquared.get().sortPlotsByTemp(result);
        }
        if (this.sortingStrategy == SortingStrategy.SORT_BY_DONE) {
            result.sort((a, b) -> {
                String va = (String)a.getFlag(DoneFlag.class);
                String vb = (String)b.getFlag(DoneFlag.class);
                if (MathMan.isInteger(va)) {
                    if (MathMan.isInteger(vb)) {
                        return Integer.parseInt(vb) - Integer.parseInt(va);
                    }
                    return -1;
                }
                return 1;
            });
        } else if (this.sortingStrategy == SortingStrategy.SORT_BY_RATING) {
            result.sort((p1, p2) -> {
                double v1 = 0.0;
                int p1s = p1.getSettings().getRatings().size();
                int p2s = p2.getRatings().size();
                if (!p1.getSettings().getRatings().isEmpty()) {
                    v1 = p1.getRatings().values().stream().mapToDouble(Rating::getAverageRating).map(av -> av * av).sum();
                    v1 /= (double)p1s;
                    v1 += (double)p1s;
                }
                double v2 = 0.0;
                if (!p2.getSettings().getRatings().isEmpty()) {
                    for (Map.Entry<UUID, Rating> entry : p2.getRatings().entrySet()) {
                        double av2 = entry.getValue().getAverageRating();
                        v2 += av2 * av2;
                    }
                    v2 /= (double)p2s;
                    v2 += (double)p2s;
                }
                if (v2 == v1 && v2 != 0.0) {
                    return p2s - p1s;
                }
                return (int)Math.signum(v2 - v1);
            });
        } else {
            if (this.sortingStrategy == SortingStrategy.SORT_BY_CREATION) {
                return PlotSquared.get().sortPlots(result, PlotSquared.SortType.CREATION_DATE, this.priorityArea);
            }
            if (this.sortingStrategy == SortingStrategy.COMPARATOR) {
                result.sort(this.plotComparator);
            }
        }
        return result;
    }

    public @NonNull Set<Plot> asSet() {
        return new HashSet<Plot>(this.asList());
    }

    public @NonNull PaginatedPlotResult getPaginated(int pageSize) {
        Preconditions.checkState((pageSize > 0 ? 1 : 0) != 0, (Object)"Page size must be greater than 0");
        return new PaginatedPlotResult(this.asList(), pageSize);
    }

    public @NonNull Collection<Plot> asCollection() {
        return this.asList();
    }

    public int count() {
        return this.asList().size();
    }

    public boolean anyMatch() {
        if (this.filters.isEmpty()) {
            return !this.plotProvider.getPlots().isEmpty();
        }
        Collection<Plot> plots = this.plotProvider.getPlots();
        block0: for (Plot plot : plots) {
            for (PlotFilter filter : this.filters) {
                if (filter.accepts(plot)) continue;
                continue block0;
            }
            return true;
        }
        return false;
    }

    private @NonNull PlotQuery addFilter(@NonNull PlotFilter filter) {
        this.filters.add(filter);
        return this;
    }

    @Override
    public @NonNull Iterator<Plot> iterator() {
        return this.asCollection().iterator();
    }
}

