/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.util.MathMan;
import com.plotsquared.core.util.PatternUtil;
import com.plotsquared.core.uuid.UUIDMapping;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class TabCompletions {
    private static final Cache<String, List<String>> cachedCompletionValues = CacheBuilder.newBuilder().expireAfterWrite((long)Settings.Tab_Completions.CACHE_EXPIRATION, TimeUnit.SECONDS).build();
    private static final Command booleanTrueCompletion = new Command(null, false, "true", "", RequiredType.NONE, null){};
    private static final Command booleanFalseCompletion = new Command(null, false, "false", "", RequiredType.NONE, null){};

    private TabCompletions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static @NonNull List<Command> completePlayers(@NonNull PlotPlayer<?> issuer, @NonNull String input, @NonNull List<String> existing) {
        return TabCompletions.completePlayers("players", issuer, input, existing, uuid -> true);
    }

    public static @NonNull List<Command> completeAddedPlayers(@NonNull PlotPlayer<?> issuer, @NonNull Plot plot, @NonNull String input, @NonNull List<String> existing) {
        return TabCompletions.completePlayers("added" + String.valueOf(plot), issuer, input, existing, uuid -> plot.getMembers().contains(uuid) || plot.getTrusted().contains(uuid) || plot.getDenied().contains(uuid));
    }

    public static @NonNull List<Command> completePlayersInPlot(@NonNull PlotPlayer<?> issuer, @NonNull Plot plot, @NonNull String input, @NonNull List<String> existing) {
        ArrayList<String> players = (ArrayList<String>)cachedCompletionValues.getIfPresent((Object)("inPlot" + String.valueOf(plot)));
        if (players == null) {
            List<PlotPlayer<?>> inPlot = plot.getPlayersInPlot();
            players = new ArrayList<String>(inPlot.size());
            for (PlotPlayer<?> player : inPlot) {
                if (!issuer.canSee(player)) continue;
                players.add(player.getName());
            }
            cachedCompletionValues.put((Object)("inPlot" + String.valueOf(plot)), players);
        }
        return TabCompletions.filterCached((Collection<String>)players, input, existing);
    }

    public static @NonNull List<Command> completePatterns(@NonNull String input) {
        return PatternUtil.getSuggestions(input.trim()).stream().map(value -> value.toLowerCase(Locale.ENGLISH).replace("minecraft:", "")).filter(value -> value.startsWith(input.toLowerCase(Locale.ENGLISH))).map(value -> new Command(null, false, (String)value, "", RequiredType.NONE, null){}).collect(Collectors.toList());
    }

    public static @NonNull List<Command> completeBoolean(@NonNull String input) {
        if (input.isEmpty()) {
            return Arrays.asList(booleanTrueCompletion, booleanFalseCompletion);
        }
        if ("true".startsWith(input)) {
            return Collections.singletonList(booleanTrueCompletion);
        }
        if ("false".startsWith(input)) {
            return Collections.singletonList(booleanFalseCompletion);
        }
        return Collections.emptyList();
    }

    public static @NonNull List<Command> completeNumbers(@NonNull String input, int amountLimit, int highestLimit) {
        int offset;
        if (input.isEmpty() || input.length() > highestLimit || !MathMan.isInteger(input)) {
            return Collections.emptyList();
        }
        try {
            offset = Integer.parseInt(input) * 10;
        }
        catch (NumberFormatException ignored) {
            return Collections.emptyList();
        }
        ArrayList<String> commands = new ArrayList<String>();
        for (int i = offset; i <= highestLimit && offset - i + amountLimit > 0; ++i) {
            commands.add(String.valueOf(i));
        }
        return TabCompletions.asCompletions(commands.toArray(new String[0]));
    }

    public static @NonNull List<Command> completeAreas(@NonNull String input) {
        ArrayList<4> completions = new ArrayList<4>();
        for (PlotArea area : PlotSquared.get().getPlotAreaManager().getAllPlotAreas()) {
            Object areaName = area.getWorldName();
            if (area.getId() != null) {
                areaName = (String)areaName + ";" + area.getId();
            }
            if (!((String)areaName).toLowerCase().startsWith(input.toLowerCase())) continue;
            completions.add(new Command(null, false, (String)areaName, "", RequiredType.NONE, null){});
        }
        return Collections.unmodifiableList(completions);
    }

    public static @NonNull List<Command> asCompletions(String ... toFilter) {
        ArrayList<5> completions = new ArrayList<5>();
        for (String completion : toFilter) {
            completions.add(new Command(null, false, completion, "", RequiredType.NONE, null){});
        }
        return Collections.unmodifiableList(completions);
    }

    private static List<Command> completePlayers(@NonNull String cacheIdentifier, @NonNull PlotPlayer<?> issuer, @NonNull String input, @NonNull List<String> existing, @NonNull Predicate<UUID> uuidFilter) {
        ArrayList<String> players;
        if (Settings.Enabled_Components.EXTENDED_USERNAME_COMPLETION) {
            players = (ArrayList<String>)cachedCompletionValues.getIfPresent((Object)cacheIdentifier);
            if (players == null) {
                Collection<UUIDMapping> mappings = PlotSquared.get().getImpromptuUUIDPipeline().getAllImmediately();
                players = new ArrayList(mappings.size());
                for (UUIDMapping mapping : mappings) {
                    if (!uuidFilter.test(mapping.uuid())) continue;
                    players.add(mapping.username());
                }
                cachedCompletionValues.put((Object)cacheIdentifier, players);
            }
        } else {
            Collection<PlotPlayer<?>> onlinePlayers = PlotSquared.platform().playerManager().getPlayers();
            players = new ArrayList<String>(onlinePlayers.size());
            for (PlotPlayer<?> player : onlinePlayers) {
                if (!uuidFilter.test(player.getUUID()) || issuer != null && !issuer.canSee(player)) continue;
                players.add(player.getName());
            }
        }
        return TabCompletions.filterCached(players, input, existing);
    }

    private static List<Command> filterCached(Collection<String> playerNames, String input, List<String> existing) {
        String processedInput = input.toLowerCase(Locale.ENGLISH);
        return playerNames.stream().filter(player -> player.toLowerCase(Locale.ENGLISH).startsWith(processedInput)).filter(player -> !existing.contains(player)).map(player -> new Command(null, false, (String)player, "", RequiredType.NONE, CommandCategory.INFO){}).limit(200L).collect(Collectors.toList());
    }
}

