/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.LocaleHolder;
import com.plotsquared.core.configuration.caption.StaticCaption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.player.ConsolePlayer;
import com.plotsquared.core.player.OfflinePlotPlayer;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.uuid.UUIDMapping;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.Contract;

public abstract class PlayerManager<P extends PlotPlayer<? extends T>, T> {
    private static final MiniMessage MINI_MESSAGE = MiniMessage.builder().build();
    private final Map<UUID, P> playerMap = new HashMap<UUID, P>();
    private final Object playerLock = new Object();

    public static void getUUIDsFromString(@NonNull String list, @NonNull BiConsumer<Collection<UUID>, Throwable> consumer) {
        String[] split = list.split(",");
        HashSet<UUID> result = new HashSet<UUID>();
        LinkedList<String> request = new LinkedList<String>();
        for (String name : split) {
            if (name.isEmpty()) {
                consumer.accept(Collections.emptySet(), null);
                return;
            }
            if ("*".equals(name)) {
                result.add(DBFunc.EVERYONE);
                continue;
            }
            if (name.length() > 16) {
                try {
                    result.add(UUID.fromString(name));
                    continue;
                }
                catch (IllegalArgumentException ignored) {
                    consumer.accept(Collections.emptySet(), null);
                    return;
                }
            }
            request.add(name);
        }
        if (request.isEmpty()) {
            consumer.accept(result, null);
        } else {
            PlotSquared.get().getImpromptuUUIDPipeline().getUUIDs(request, Settings.UUID.NON_BLOCKING_TIMEOUT).whenComplete((uuids, throwable) -> {
                if (throwable != null) {
                    consumer.accept((Collection<UUID>)null, (Throwable)throwable);
                } else {
                    for (UUIDMapping uuid : uuids) {
                        result.add(uuid.uuid());
                    }
                    consumer.accept(result, null);
                }
            });
        }
    }

    public static @NonNull Component getPlayerList(@NonNull Collection<UUID> uuids, LocaleHolder localeHolder) {
        if (uuids.isEmpty()) {
            return TranslatableCaption.of("info.none").toComponent(localeHolder).asComponent();
        }
        LinkedList<UUID> players = new LinkedList<UUID>();
        LinkedList<Object> users = new LinkedList<Object>();
        for (UUID uuid : uuids) {
            if (uuid == null) {
                users.add(TranslatableCaption.of("info.none").toComponent(localeHolder));
                continue;
            }
            if (DBFunc.EVERYONE.equals(uuid)) {
                users.add(TranslatableCaption.of("info.everyone").toComponent(localeHolder));
                continue;
            }
            if (DBFunc.SERVER.equals(uuid)) {
                users.add(TranslatableCaption.of("info.console").toComponent(localeHolder));
                continue;
            }
            players.add(uuid);
        }
        try {
            for (UUIDMapping mapping : PlotSquared.get().getImpromptuUUIDPipeline().getNames(players).get(Settings.UUID.BLOCKING_TIMEOUT, TimeUnit.MILLISECONDS)) {
                users.add(Component.text((String)mapping.username()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String c = TranslatableCaption.of("info.plot_user_list").getComponent(ConsolePlayer.getConsole());
        TextComponent.Builder list = Component.text();
        for (int x = 0; x < users.size(); ++x) {
            if (x + 1 == uuids.size()) {
                list.append(MINI_MESSAGE.deserialize(c, (TagResolver)TagResolver.resolver((String)"user", (Tag)Tag.inserting((ComponentLike)((ComponentLike)users.get(x))))));
                continue;
            }
            list.append(MINI_MESSAGE.deserialize(c + ", ", (TagResolver)TagResolver.resolver((String)"user", (Tag)Tag.inserting((ComponentLike)((ComponentLike)users.get(x))))));
        }
        return list.asComponent();
    }

    @Deprecated(since="7.1.0")
    public static @NonNull Caption resolveName(@Nullable UUID owner) {
        return PlayerManager.resolveName(owner, true);
    }

    @Deprecated(since="7.1.0")
    public static @NonNull Caption resolveName(@Nullable UUID owner, boolean blocking) {
        UUIDMapping uuidMapping;
        if (owner == null) {
            return TranslatableCaption.of("info.none");
        }
        if (owner.equals(DBFunc.EVERYONE)) {
            return TranslatableCaption.of("info.everyone");
        }
        if (owner.equals(DBFunc.SERVER)) {
            return TranslatableCaption.of("info.server");
        }
        String name = blocking ? PlotSquared.get().getImpromptuUUIDPipeline().getSingle(owner, Settings.UUID.BLOCKING_TIMEOUT) : ((uuidMapping = PlotSquared.get().getImpromptuUUIDPipeline().getImmediately(owner)) != null ? uuidMapping.username() : null);
        if (name == null) {
            return TranslatableCaption.of("info.unknown");
        }
        return StaticCaption.of(name);
    }

    @Contract(value="_->!null")
    public @NonNull CompletableFuture<Caption> getUsernameCaption(@Nullable UUID uuid) {
        if (uuid == null) {
            return CompletableFuture.completedFuture(TranslatableCaption.of("info.none"));
        }
        if (uuid.equals(DBFunc.EVERYONE)) {
            return CompletableFuture.completedFuture(TranslatableCaption.of("info.everyone"));
        }
        if (uuid.equals(DBFunc.SERVER)) {
            return CompletableFuture.completedFuture(TranslatableCaption.of("info.server"));
        }
        P player = this.getPlayerIfExists(uuid);
        if (player != null) {
            return CompletableFuture.completedFuture(StaticCaption.of(player.getName()));
        }
        return PlotSquared.get().getImpromptuUUIDPipeline().getNames(Collections.singleton(uuid)).thenApply(mapping -> {
            if (mapping.isEmpty()) {
                return TranslatableCaption.of("info.unknown");
            }
            return StaticCaption.of(((UUIDMapping)mapping.get(0)).username());
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlayer(@NonNull PlotPlayer<?> plotPlayer) {
        Object object = this.playerLock;
        synchronized (object) {
            this.playerMap.remove(plotPlayer.getUUID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlayer(@NonNull UUID uuid) {
        Object object = this.playerLock;
        synchronized (object) {
            this.playerMap.remove(uuid);
        }
    }

    public @Nullable P getPlayerIfExists(@Nullable UUID uuid) {
        if (uuid == null) {
            return null;
        }
        return (P)((PlotPlayer)this.playerMap.get(uuid));
    }

    public @Nullable P getPlayerIfExists(@Nullable String name) {
        for (PlotPlayer plotPlayer : this.playerMap.values()) {
            if (!plotPlayer.getName().equalsIgnoreCase(name)) continue;
            return (P)plotPlayer;
        }
        return null;
    }

    public abstract @NonNull P getPlayer(@NonNull T var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull P getPlayer(@NonNull UUID uuid) {
        Object object = this.playerLock;
        synchronized (object) {
            PlotPlayer player = (PlotPlayer)this.playerMap.get(uuid);
            if (player == null) {
                player = this.createPlayer(uuid);
                this.playerMap.put(uuid, player);
            }
            return (P)player;
        }
    }

    public abstract @NonNull P createPlayer(@NonNull UUID var1);

    public abstract @Nullable OfflinePlotPlayer getOfflinePlayer(@Nullable UUID var1);

    public abstract @Nullable OfflinePlotPlayer getOfflinePlayer(@NonNull String var1);

    public Collection<P> getPlayers() {
        return Collections.unmodifiableCollection(new ArrayList<P>(this.playerMap.values()));
    }

    public static final class NoSuchPlayerException
    extends IllegalArgumentException {
        public NoSuchPlayerException(@NonNull UUID uuid) {
            super(String.format("There is no online player with UUID '%s'", uuid));
        }
    }
}

