/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util;

import com.plotsquared.core.util.MathMan;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.input.ParserContext;
import com.sk89q.worldedit.internal.registry.InputParser;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.block.FuzzyBlockState;
import com.sk89q.worldedit.world.registry.LegacyMapper;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class BlockUtil {
    private static final ParserContext PARSER_CONTEXT = new ParserContext();
    private static final InputParser<BaseBlock> PARSER;

    private BlockUtil() {
    }

    public static @Nullable BlockState get(int id) {
        return LegacyMapper.getInstance().getBlockFromLegacy(id);
    }

    public static @Nullable BlockState get(int id, int data) {
        return LegacyMapper.getInstance().getBlockFromLegacy(id, data);
    }

    public static @Nullable BlockState get(@NonNull String id) {
        String[] split;
        if (id.length() == 1 && id.charAt(0) == '*') {
            return FuzzyBlockState.builder().type(BlockTypes.AIR).build();
        }
        String mutableId = id.toLowerCase();
        BlockType type = BlockTypes.get((String)mutableId);
        if (type != null) {
            return type.getDefaultState();
        }
        if (Character.isDigit(mutableId.charAt(0)) && MathMan.isInteger((split = mutableId.split(":"))[0])) {
            if (split.length == 2) {
                if (MathMan.isInteger(split[1])) {
                    return BlockUtil.get(Integer.parseInt(split[0]), Integer.parseInt(split[1]));
                }
            } else {
                return BlockUtil.get(Integer.parseInt(split[0]));
            }
        }
        try {
            BaseBlock block = (BaseBlock)PARSER.parseFromInput(mutableId, PARSER_CONTEXT);
            return block.toImmutableState();
        }
        catch (InputParseException e) {
            return null;
        }
    }

    static {
        PARSER_CONTEXT.setRestricted(false);
        PARSER_CONTEXT.setPreferringWildcard(false);
        PARSER_CONTEXT.setTryLegacy(true);
        List parsers = WorldEdit.getInstance().getBlockFactory().getParsers();
        PARSER = (InputParser)parsers.get(parsers.size() - 1);
    }
}

