/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.queue;

import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.queue.LightingMode;
import com.plotsquared.core.queue.QueueCoordinator;
import com.plotsquared.core.queue.subscriber.ProgressSubscriber;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.util.SideEffectSet;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DelegateQueueCoordinator
extends QueueCoordinator {
    private final QueueCoordinator parent;

    public DelegateQueueCoordinator(QueueCoordinator parent) {
        super(parent == null ? null : parent.getWorld());
        this.parent = parent;
        if (parent != null) {
            this.setForceSync(parent.isForceSync());
            this.setShouldGen(parent.isShouldGen());
        }
    }

    public QueueCoordinator getParent() {
        return this.parent;
    }

    @Override
    public int size() {
        if (this.parent != null) {
            return this.parent.size();
        }
        return 0;
    }

    @Override
    public void setModified(long modified) {
        if (this.parent != null) {
            this.parent.setModified(modified);
        }
    }

    @Override
    public boolean setBlock(int x, int y, int z, @NonNull Pattern pattern) {
        if (this.parent != null) {
            return this.parent.setBlock(x, y, z, pattern);
        }
        return false;
    }

    @Override
    public boolean setBlock(int x, int y, int z, @NonNull BaseBlock id) {
        if (this.parent != null) {
            return this.parent.setBlock(x, y, z, id);
        }
        return false;
    }

    @Override
    public boolean setBlock(int x, int y, int z, @NonNull BlockState id) {
        if (this.parent != null) {
            return this.parent.setBlock(x, y, z, id);
        }
        return false;
    }

    @Override
    public @Nullable BlockState getBlock(int x, int y, int z) {
        if (this.parent != null) {
            return this.parent.getBlock(x, y, z);
        }
        return null;
    }

    @Override
    public boolean setBiome(int x, int z, @NonNull BiomeType biome) {
        if (this.parent != null) {
            return this.parent.setBiome(x, z, biome);
        }
        return false;
    }

    @Override
    public boolean setBiome(int x, int y, int z, @NonNull BiomeType biome) {
        if (this.parent != null) {
            return this.parent.setBiome(x, y, z, biome);
        }
        return false;
    }

    @Override
    public boolean isSettingBiomes() {
        if (this.parent != null) {
            return this.parent.isSettingBiomes();
        }
        return false;
    }

    @Override
    public void setBiomesEnabled(boolean enabled) {
        if (this.parent != null) {
            this.parent.setBiomesEnabled(enabled);
        }
    }

    @Override
    public boolean setEntity(@NonNull Entity entity) {
        if (this.parent != null) {
            return this.parent.setEntity(entity);
        }
        return false;
    }

    @Override
    public void regenChunk(int x, int z) {
        if (this.parent != null) {
            this.parent.regenChunk(x, z);
        }
    }

    @Override
    public @Nullable World getWorld() {
        if (this.parent != null) {
            return this.parent.getWorld();
        }
        return null;
    }

    @Override
    public boolean setTile(int x, int y, int z, @NonNull CompoundTag tag) {
        if (this.parent != null) {
            return this.parent.setTile(x, y, z, tag);
        }
        return false;
    }

    @Override
    public boolean isSettingTiles() {
        if (this.parent != null) {
            return this.parent.isSettingTiles();
        }
        return false;
    }

    @Override
    public boolean enqueue() {
        if (this.parent != null) {
            return this.parent.enqueue();
        }
        return false;
    }

    @Override
    public void start() {
        if (this.parent != null) {
            this.parent.start();
        }
    }

    @Override
    public void cancel() {
        if (this.parent != null) {
            this.parent.cancel();
        }
    }

    @Override
    public Runnable getCompleteTask() {
        if (this.parent != null) {
            return this.parent.getCompleteTask();
        }
        return null;
    }

    @Override
    public void setCompleteTask(Runnable whenDone) {
        if (this.parent != null) {
            this.parent.setCompleteTask(whenDone);
        }
    }

    @Override
    public @Nullable Consumer<BlockVector2> getChunkConsumer() {
        if (this.parent != null) {
            return this.parent.getChunkConsumer();
        }
        return null;
    }

    @Override
    public void setChunkConsumer(@NonNull Consumer<BlockVector2> consumer) {
        if (this.parent != null) {
            this.parent.setChunkConsumer(consumer);
        }
    }

    @Override
    public void addProgressSubscriber(@NonNull ProgressSubscriber progressSubscriber) {
        if (this.parent != null) {
            this.parent.addProgressSubscriber(progressSubscriber);
        }
    }

    @Override
    public @NonNull LightingMode getLightingMode() {
        if (this.parent != null) {
            return this.parent.getLightingMode();
        }
        return LightingMode.valueOf(Settings.QUEUE.LIGHTING_MODE);
    }

    @Override
    public void setLightingMode(@Nullable LightingMode mode) {
        if (this.parent != null) {
            this.parent.setLightingMode(mode);
        }
    }

    @Override
    public SideEffectSet getSideEffectSet() {
        if (this.parent != null) {
            return this.parent.getSideEffectSet();
        }
        return null;
    }

    @Override
    public void setSideEffectSet(SideEffectSet sideEffectSet) {
        if (this.parent != null) {
            this.parent.setSideEffectSet(sideEffectSet);
        }
    }

    @Override
    public @NonNull List<BlockVector2> getReadChunks() {
        if (this.parent != null) {
            return this.parent.getReadChunks();
        }
        return new ArrayList<BlockVector2>();
    }

    @Override
    public void addReadChunks(@NonNull Set<BlockVector2> readChunks) {
        if (this.parent != null) {
            this.parent.addReadChunks(readChunks);
        }
    }

    @Override
    public void addReadChunk(@NonNull BlockVector2 chunk) {
        if (this.parent != null) {
            this.parent.addReadChunk(chunk);
        }
    }

    @Override
    public boolean isUnloadAfter() {
        if (this.parent != null) {
            return this.parent.isUnloadAfter();
        }
        return false;
    }

    @Override
    public void setUnloadAfter(boolean setUnloadAfter) {
        if (this.parent != null) {
            this.parent.setUnloadAfter(setUnloadAfter);
        }
    }

    @Override
    public @Nullable CuboidRegion getRegenRegion() {
        if (this.parent != null) {
            return this.parent.getRegenRegion();
        }
        return null;
    }

    @Override
    public void setRegenRegion(@NonNull CuboidRegion regenRegion) {
        if (this.parent != null) {
            this.parent.setRegenRegion(regenRegion);
        }
    }
}

