/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.comment;

import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.comment.PlotComment;
import com.plotsquared.core.util.task.RunnableVal;
import java.util.List;

public abstract class CommentInbox {
    public abstract String toString();

    public boolean canRead(Plot plot, PlotPlayer<?> player) {
        if (player.hasPermission("plots.inbox.read." + String.valueOf(this), true)) {
            return plot.isOwner(player.getUUID()) || player.hasPermission("plots.inbox.read." + String.valueOf(this) + ".other", true);
        }
        return false;
    }

    public boolean canWrite(Plot plot, PlotPlayer<?> player) {
        if (plot == null) {
            return player.hasPermission("plots.inbox.write." + String.valueOf(this), true);
        }
        return player.hasPermission("plots.inbox.write." + String.valueOf(this), true) && (plot.isOwner(player.getUUID()) || player.hasPermission("plots.inbox.write." + String.valueOf(this) + ".other", true));
    }

    public boolean canModify(Plot plot, PlotPlayer<?> player) {
        if (player.hasPermission("plots.inbox.modify." + String.valueOf(this), true)) {
            return plot.isOwner(player.getUUID()) || player.hasPermission("plots.inbox.modify." + String.valueOf(this) + ".other", true);
        }
        return false;
    }

    public abstract boolean getComments(Plot var1, RunnableVal<List<PlotComment>> var2);

    public abstract boolean addComment(Plot var1, PlotComment var2);

    public void removeComment(Plot plot, PlotComment comment) {
        DBFunc.removeComment(plot, comment);
    }

    public void clearInbox(Plot plot) {
        DBFunc.clearInbox(plot, this.toString());
    }
}

