/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.google.inject.Inject;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.backup.BackupManager;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.MainCommand;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SetCommand;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.StaticCaption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.inject.factory.ProgressSubscriberFactory;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotManager;
import com.plotsquared.core.queue.QueueCoordinator;
import com.plotsquared.core.util.PatternUtil;
import com.plotsquared.core.util.StringMan;
import com.plotsquared.core.util.TabCompletions;
import com.plotsquared.core.util.WorldUtil;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.registry.Keyed;
import com.sk89q.worldedit.world.block.BlockCategory;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="set", aliases={"s"}, usage="/plot set <biome | alias | home | flag> <value...>", permission="plots.set", category=CommandCategory.APPEARANCE, requiredType=RequiredType.NONE)
public class Set
extends SubCommand {
    public static final String[] values = new String[]{"biome", "alias", "home"};
    public static final String[] aliases = new String[]{"b", "w", "wf", "a", "h"};
    private final SetCommand component;

    @Inject
    public Set(final @NonNull WorldUtil worldUtil) {
        this.component = new SetCommand(){

            @Override
            public String getId() {
                return "set.component";
            }

            @Override
            public boolean set(PlotPlayer<?> player, Plot plot, String value) {
                PlotArea plotArea = player.getLocation().getPlotArea();
                if (plotArea == null) {
                    return false;
                }
                PlotManager manager = plotArea.getPlotManager();
                String[] components = manager.getPlotComponents(plot.getId());
                String[] args = value.split(" ");
                String material = StringMan.join(Arrays.copyOfRange(args, 1, args.length), ",").trim();
                ArrayList<String> forbiddenTypes = new ArrayList<String>(Settings.General.INVALID_BLOCKS);
                if (Settings.Enabled_Components.CHUNK_PROCESSOR) {
                    forbiddenTypes.addAll(worldUtil.getTileEntityTypes().stream().map(BlockType::getName).toList());
                }
                if (!player.hasPermission(Permission.PERMISSION_ADMIN_ALLOW_UNSAFE) && !forbiddenTypes.isEmpty()) {
                    for (String forbiddenType : forbiddenTypes) {
                        if ((forbiddenType = forbiddenType.toLowerCase(Locale.ENGLISH)).startsWith("minecraft:")) {
                            forbiddenType = forbiddenType.substring(10);
                        }
                        for (String blockType : material.split(",")) {
                            block15: {
                                if ((blockType = blockType.toLowerCase(Locale.ENGLISH)).startsWith("minecraft:")) {
                                    blockType = blockType.substring(10);
                                }
                                if (blockType.startsWith("##")) {
                                    try {
                                        BlockCategory category = (BlockCategory)BlockCategory.REGISTRY.get(blockType.substring(2).replaceAll("[*^|]+", "").toLowerCase(Locale.ENGLISH));
                                        if (category == null || !category.contains((Keyed)BlockTypes.get((String)forbiddenType))) {
                                            continue;
                                        }
                                        break block15;
                                    }
                                    catch (Throwable throwable) {
                                        break block15;
                                    }
                                }
                                if (!blockType.contains(forbiddenType)) continue;
                            }
                            player.sendMessage((Caption)TranslatableCaption.of("invalid.component_illegal_block"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)forbiddenType)))});
                            return true;
                        }
                    }
                }
                for (String component : components) {
                    if (!component.equalsIgnoreCase(args[0])) continue;
                    if (!player.hasPermission(Permission.PERMISSION_SET_COMPONENT.format(component))) {
                        player.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), new TagResolver[]{TagResolver.resolver((String)"node", (Tag)Tag.inserting((Component)Component.text((String)Permission.PERMISSION_SET_COMPONENT.format(component))))});
                        return false;
                    }
                    if (args.length < 2) {
                        player.sendMessage((Caption)TranslatableCaption.of("need.need_block"), new TagResolver[0]);
                        return true;
                    }
                    Pattern pattern = PatternUtil.parse(player, material, false);
                    if (plot.getRunning() > 0) {
                        player.sendMessage((Caption)TranslatableCaption.of("errors.wait_for_timer"), new TagResolver[0]);
                        return false;
                    }
                    BackupManager.backup(player, plot, () -> {
                        plot.addRunning();
                        QueueCoordinator queue = plotArea.getQueue();
                        queue.setCompleteTask(() -> {
                            plot.removeRunning();
                            player.sendMessage((Caption)TranslatableCaption.of("working.component_complete"), new TagResolver[]{TagResolver.resolver((String)"plot", (Tag)Tag.inserting((Component)Component.text((String)plot.getId().toString())))});
                        });
                        if (Settings.QUEUE.NOTIFY_PROGRESS) {
                            queue.addProgressSubscriber(((ProgressSubscriberFactory)PlotSquared.platform().injector().getInstance(ProgressSubscriberFactory.class)).createWithActor(player));
                        }
                        for (Plot current : plot.getConnectedPlots()) {
                            current.getPlotModificationManager().setComponent(component, pattern, player, queue);
                        }
                        queue.enqueue();
                        player.sendMessage((Caption)TranslatableCaption.of("working.generating_component"), new TagResolver[0]);
                    });
                    return true;
                }
                return false;
            }

            @Override
            public Collection<Command> tab(PlotPlayer<?> player, String[] args, boolean space) {
                return TabCompletions.completePatterns(StringMan.join(args, ","));
            }
        };
    }

    public boolean noArgs(PlotPlayer<?> player) {
        ArrayList<String> newValues = new ArrayList<String>(Arrays.asList("biome", "alias", "home"));
        Plot plot = player.getCurrentPlot();
        if (plot != null) {
            newValues.addAll(Arrays.asList(plot.getManager().getPlotComponents(plot.getId())));
        }
        player.sendMessage((Caption)StaticCaption.of(TranslatableCaption.of("commandconfig.subcommand_set_options_header_only").getComponent(player) + StringMan.join(newValues, TranslatableCaption.of("blocklist.block_list_separator").getComponent(player))), new TagResolver[0]);
        return false;
    }

    @Override
    public boolean onCommand(PlotPlayer<?> player, String[] args) {
        if (args.length == 0) {
            return this.noArgs(player);
        }
        Command cmd = MainCommand.getInstance().getCommand("set" + args[0]);
        if (cmd != null) {
            if (!player.hasPermission(cmd.getPermission(), true)) {
                return false;
            }
            cmd.execute(player, Arrays.copyOfRange(args, 1, args.length), null, null);
            return true;
        }
        Plot plot = player.getCurrentPlot();
        if (plot == null) {
            player.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
            return false;
        }
        if (plot.getVolume() > 2.147483647E9) {
            player.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_too_large"), new TagResolver[0]);
            return false;
        }
        HashSet<String> components = new HashSet<String>(Arrays.asList(plot.getManager().getPlotComponents(plot.getId())));
        if (components.contains(args[0].toLowerCase())) {
            return this.component.onCommand(player, Arrays.copyOfRange(args, 0, args.length));
        }
        return this.noArgs(player);
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> player, String[] args, boolean space) {
        if (args.length == 1) {
            LinkedList<String> completions = new LinkedList<String>();
            if (player.hasPermission(Permission.PERMISSION_SET_BIOME)) {
                completions.add("biome");
            }
            if (player.hasPermission(Permission.PERMISSION_SET_ALIAS)) {
                completions.add("alias");
            }
            if (player.hasPermission(Permission.PERMISSION_SET_HOME)) {
                completions.add("home");
            }
            if (player.hasPermission(Permission.PERMISSION_SET_MAIN)) {
                completions.add("main");
            }
            if (player.hasPermission(Permission.PERMISSION_SET_FLOOR)) {
                completions.add("floor");
            }
            if (player.hasPermission(Permission.PERMISSION_SET_AIR)) {
                completions.add("air");
            }
            if (player.hasPermission(Permission.PERMISSION_SET_ALL)) {
                completions.add("all");
            }
            if (player.hasPermission(Permission.PERMISSION_SET_BORDER)) {
                completions.add("border");
            }
            if (player.hasPermission(Permission.PERMISSION_SET_WALL)) {
                completions.add("wall");
            }
            if (player.hasPermission(Permission.PERMISSION_SET_OUTLINE)) {
                completions.add("outline");
            }
            if (player.hasPermission(Permission.PERMISSION_SET_MIDDLE)) {
                completions.add("middle");
            }
            List commands = completions.stream().filter(completion -> completion.toLowerCase().startsWith(args[0].toLowerCase())).map(completion -> new Command(null, true, (String)completion, "", RequiredType.NONE, CommandCategory.APPEARANCE){}).collect(Collectors.toCollection(LinkedList::new));
            if (player.hasPermission(Permission.PERMISSION_SET) && args[0].length() > 0) {
                commands.addAll(TabCompletions.completePlayers(player, args[0], Collections.emptyList()));
            }
            return commands;
        }
        if (args.length > 1) {
            Plot plot = player.getCurrentPlot();
            if (plot == null) {
                return new ArrayList<Command>();
            }
            String[] newArgs = new String[args.length - 1];
            System.arraycopy(args, 1, newArgs, 0, newArgs.length);
            Command cmd = MainCommand.getInstance().getCommand("set" + args[0]);
            if (cmd != null) {
                if (!player.hasPermission(cmd.getPermission(), true)) {
                    return new ArrayList<Command>();
                }
                return cmd.tab(player, newArgs, space);
            }
            HashSet<String> components = new HashSet<String>(Arrays.asList(plot.getManager().getPlotComponents(plot.getId())));
            if (components.contains(args[0].toLowerCase())) {
                return this.component.tab(player, newArgs, space);
            }
        }
        return this.tabOf(player, args, space, new String[0]);
    }
}

