/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.google.inject.Inject;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.StaticCaption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.MetaDataAccess;
import com.plotsquared.core.player.PlayerMetaDataKeys;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.plot.schematic.Schematic;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.util.SchematicHandler;
import com.plotsquared.core.util.TimeUtil;
import com.plotsquared.core.util.task.RunnableVal;
import com.plotsquared.core.util.task.TaskManager;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="load", aliases={"restore"}, category=CommandCategory.SCHEMATIC, requiredType=RequiredType.NONE, permission="plots.load", usage="/plot load")
public class Load
extends SubCommand {
    private final PlotAreaManager plotAreaManager;
    private final SchematicHandler schematicHandler;

    @Inject
    public Load(@NonNull PlotAreaManager plotAreaManager, @NonNull SchematicHandler schematicHandler) {
        this.plotAreaManager = plotAreaManager;
        this.schematicHandler = schematicHandler;
    }

    @Override
    public boolean onCommand(final PlotPlayer<?> player, String[] args) {
        String world = player.getLocation().getWorldName();
        if (!this.plotAreaManager.hasPlotArea(world)) {
            player.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot_world"), new TagResolver[0]);
            return false;
        }
        final Plot plot = player.getCurrentPlot();
        if (plot == null) {
            player.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
            return false;
        }
        if (!plot.hasOwner()) {
            player.sendMessage((Caption)TranslatableCaption.of("info.plot_unowned"), new TagResolver[0]);
            return false;
        }
        if (!plot.isOwner(player.getUUID()) && !player.hasPermission(Permission.PERMISSION_ADMIN_COMMAND_LOAD)) {
            player.sendMessage((Caption)TranslatableCaption.of("permission.no_plot_perms"), new TagResolver[0]);
            return false;
        }
        if (plot.getRunning() > 0) {
            player.sendMessage((Caption)TranslatableCaption.of("errors.wait_for_timer"), new TagResolver[0]);
            return false;
        }
        try (MetaDataAccess<List<String>> metaDataAccess = player.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_SCHEMATICS);){
            if (args.length != 0) {
                if (args.length == 1) {
                    URL url;
                    String schematic;
                    List schematics = metaDataAccess.get().orElse(null);
                    if (schematics == null) {
                        player.sendMessage((Caption)TranslatableCaption.of("web.load_null"), new TagResolver[]{TagResolver.resolver((String)"command", (Tag)Tag.inserting((Component)Component.text((String)"/plot load")))});
                        boolean bl = false;
                        return bl;
                    }
                    try {
                        schematic = (String)schematics.get(Integer.parseInt(args[0]) - 1);
                    }
                    catch (Exception ignored) {
                        player.sendMessage((Caption)TranslatableCaption.of("invalid.not_valid_number"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)("(1, " + schematics.size() + ")"))))});
                        boolean bl = false;
                        if (metaDataAccess != null) {
                            metaDataAccess.close();
                        }
                        return bl;
                    }
                    try {
                        url = URI.create(Settings.Web.URL + "saves/" + String.valueOf(player.getUUID()) + "/" + schematic).toURL();
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                        player.sendMessage((Caption)TranslatableCaption.of("web.load_failed"), new TagResolver[0]);
                        boolean bl = false;
                        if (metaDataAccess != null) {
                            metaDataAccess.close();
                        }
                        return bl;
                    }
                    plot.addRunning();
                    player.sendMessage((Caption)TranslatableCaption.of("working.generating_component"), new TagResolver[0]);
                    TaskManager.runTaskAsync(() -> {
                        Schematic taskSchematic = this.schematicHandler.getSchematic(url);
                        if (taskSchematic == null) {
                            plot.removeRunning();
                            player.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_invalid"), new TagResolver[]{TagResolver.resolver((String)"reason", (Tag)Tag.inserting((Component)Component.text((String)"non-existent or not in gzip format")))});
                            return;
                        }
                        PlotArea area = plot.getArea();
                        this.schematicHandler.paste(taskSchematic, plot, 0, area.getMinBuildHeight(), 0, false, player, new RunnableVal<Boolean>(){

                            @Override
                            public void run(Boolean value) {
                                plot.removeRunning();
                                if (value.booleanValue()) {
                                    player.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_paste_success"), new TagResolver[0]);
                                } else {
                                    player.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_paste_failed"), new TagResolver[0]);
                                }
                            }
                        });
                    });
                    boolean bl = true;
                    return bl;
                }
                plot.removeRunning();
                player.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)"/plot load <index>")))});
                boolean schematics = false;
                return schematics;
            }
            List schematics = metaDataAccess.get().orElse(null);
            if (schematics == null) {
                plot.addRunning();
                TaskManager.runTaskAsync(() -> {
                    List<String> schematics1 = this.schematicHandler.getSaves(player.getUUID());
                    plot.removeRunning();
                    if (schematics1 == null || schematics1.isEmpty()) {
                        player.sendMessage((Caption)TranslatableCaption.of("web.load_failed"), new TagResolver[0]);
                        return;
                    }
                    metaDataAccess.set(schematics1);
                    this.displaySaves(player);
                });
            } else {
                this.displaySaves(player);
            }
        }
        return true;
    }

    public void displaySaves(PlotPlayer<?> player) {
        try (MetaDataAccess<List<String>> metaDataAccess = player.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_SCHEMATICS);){
            List schematics = metaDataAccess.get().orElse(Collections.emptyList());
            for (int i = 0; i < Math.min(schematics.size(), 32); ++i) {
                try {
                    String schematic = ((String)schematics.get(i)).split("\\.")[0];
                    String[] split = schematic.split("_");
                    if (split.length < 5) continue;
                    String time = TimeUtil.secToTime(System.currentTimeMillis() / 1000L - Long.parseLong(split[0]));
                    String world = split[1];
                    PlotId id = PlotId.fromString(split[2] + ";" + split[3]);
                    String size = split[4];
                    String color = "<dark_aqua>";
                    player.sendMessage((Caption)StaticCaption.of("<dark_gray>[</dark_gray><gray>" + (i + 1) + "</gray><dark_aqua>] </dark_aqua>" + color + time + "<dark_gray> | </dark_gray>" + color + world + ";" + String.valueOf(id) + "<dark_gray> | </dark_gray>" + color + size + "x" + size), new TagResolver[0]);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            player.sendMessage((Caption)TranslatableCaption.of("web.load_list"), new TagResolver[]{TagResolver.resolver((String)"command", (Tag)Tag.inserting((Component)Component.text((String)"/plot load #")))});
        }
    }
}

