/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.google.inject.Inject;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.Argument;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.util.PlayerManager;
import com.plotsquared.core.util.TabCompletions;
import com.plotsquared.core.util.WorldUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="kick", aliases={"k"}, permission="plots.kick", usage="/plot kick <player | *>", category=CommandCategory.TELEPORT, requiredType=RequiredType.PLAYER)
public class Kick
extends SubCommand {
    private final PlotAreaManager plotAreaManager;
    private final WorldUtil worldUtil;

    @Inject
    public Kick(@NonNull PlotAreaManager plotAreaManager, @NonNull WorldUtil worldUtil) {
        super(Argument.PlayerName);
        this.plotAreaManager = plotAreaManager;
        this.worldUtil = worldUtil;
    }

    @Override
    public boolean onCommand(PlotPlayer<?> player, String[] args) {
        Location location = player.getLocation();
        Plot plot = location.getPlot();
        if (plot == null) {
            player.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
            return false;
        }
        if (!(plot.hasOwner() && plot.isOwner(player.getUUID()) || player.hasPermission(Permission.PERMISSION_ADMIN_COMMAND_KICK))) {
            player.sendMessage((Caption)TranslatableCaption.of("permission.no_plot_perms"), new TagResolver[0]);
            return false;
        }
        PlayerManager.getUUIDsFromString(args[0], (uuids, throwable) -> {
            if (throwable instanceof TimeoutException) {
                player.sendMessage((Caption)TranslatableCaption.of("players.fetching_players_timeout"), new TagResolver[0]);
            } else if (throwable != null || uuids.isEmpty()) {
                player.sendMessage((Caption)TranslatableCaption.of("errors.invalid_player"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)args[0])))});
            } else {
                HashSet players = new HashSet();
                for (UUID uUID : uuids) {
                    if (uUID == DBFunc.EVERYONE) {
                        for (PlotPlayer<?> pp : plot.getPlayersInPlot()) {
                            if (pp == player || pp.hasPermission(Permission.PERMISSION_ADMIN_ENTRY_DENIED)) continue;
                            players.add(pp);
                        }
                        continue;
                    }
                    PlotPlayer<?> pp = PlotSquared.platform().playerManager().getPlayerIfExists(uUID);
                    if (pp == null) continue;
                    players.add(pp);
                }
                players.remove(player);
                if (players.isEmpty()) {
                    player.sendMessage((Caption)TranslatableCaption.of("errors.invalid_player"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)args[0])))});
                    return;
                }
                for (PlotPlayer plotPlayer : players) {
                    if (!plot.equals(plotPlayer.getCurrentPlot())) {
                        player.sendMessage((Caption)TranslatableCaption.of("kick.player_not_in_plot"), new TagResolver[]{TagResolver.resolver((String)"player", (Tag)Tag.inserting((Component)Component.text((String)plotPlayer.getName())))});
                        return;
                    }
                    if (plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_ENTRY_DENIED)) {
                        player.sendMessage((Caption)TranslatableCaption.of("kick.cannot_kick_player"), new TagResolver[]{TagResolver.resolver((String)"player", (Tag)Tag.inserting((Component)Component.text((String)plotPlayer.getName())))});
                        return;
                    }
                    Location spawn = this.worldUtil.getSpawn(location.getWorldName());
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("kick.you_got_kicked"), new TagResolver[0]);
                    if (plot.equals(spawn.getPlot())) {
                        Location newSpawn = this.worldUtil.getSpawn(this.plotAreaManager.getAllWorlds()[0]);
                        if (plot.equals(newSpawn.getPlot())) {
                            plotPlayer.kick("You got kicked from the plot! This server did not set up a loaded spawn, so you got kicked from the server.");
                            continue;
                        }
                        plotPlayer.plotkick(newSpawn);
                        continue;
                    }
                    plotPlayer.plotkick(spawn);
                }
            }
        });
        return true;
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> player, String[] args, boolean space) {
        Location location = player.getLocation();
        Plot plot = location.getPlotAbs();
        if (plot == null) {
            return Collections.emptyList();
        }
        return TabCompletions.completePlayersInPlot(player, plot, String.join((CharSequence)",", args).trim(), Collections.singletonList(player.getName()));
    }
}

