/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.schematic;

import com.sk89q.jnbt.NBTOutputStream;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.SpongeSchematicWriter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class Schematic {
    private final Clipboard clipboard;
    private Map<String, Tag> flags = new HashMap<String, Tag>();

    public Schematic(Clipboard clip) {
        this.clipboard = clip;
    }

    public boolean setBlock(BlockVector3 position, BaseBlock block) throws WorldEditException {
        if (this.clipboard.getRegion().contains(position)) {
            BlockVector3 vector3 = position.subtract(this.clipboard.getRegion().getMinimumPoint());
            this.clipboard.setBlock(vector3, (BlockStateHolder)block);
            return true;
        }
        return false;
    }

    public void save(File file) throws IOException {
        try (SpongeSchematicWriter schematicWriter = new SpongeSchematicWriter(new NBTOutputStream((OutputStream)new FileOutputStream(file)));){
            schematicWriter.write(this.clipboard);
        }
    }

    public Clipboard getClipboard() {
        return this.clipboard;
    }

    public Map<String, Tag> getFlags() {
        return this.flags;
    }

    public void setFlags(Map<String, Tag> flags) {
        this.flags = flags == null ? new HashMap() : flags;
    }
}

