/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.Like;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.CaptionUtility;
import com.plotsquared.core.configuration.caption.StaticCaption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.events.PlayerTeleportToPlotEvent;
import com.plotsquared.core.events.Result;
import com.plotsquared.core.events.TeleportCause;
import com.plotsquared.core.generator.ClassicPlotWorld;
import com.plotsquared.core.listener.PlotListener;
import com.plotsquared.core.location.BlockLoc;
import com.plotsquared.core.location.Direction;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.ConsolePlayer;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotCluster;
import com.plotsquared.core.plot.PlotCommentContainer;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.plot.PlotManager;
import com.plotsquared.core.plot.PlotModificationManager;
import com.plotsquared.core.plot.PlotSettings;
import com.plotsquared.core.plot.Rating;
import com.plotsquared.core.plot.expiration.ExpireManager;
import com.plotsquared.core.plot.expiration.PlotAnalysis;
import com.plotsquared.core.plot.flag.FlagContainer;
import com.plotsquared.core.plot.flag.GlobalFlagContainer;
import com.plotsquared.core.plot.flag.InternalFlag;
import com.plotsquared.core.plot.flag.PlotFlag;
import com.plotsquared.core.plot.flag.implementations.DescriptionFlag;
import com.plotsquared.core.plot.flag.implementations.KeepFlag;
import com.plotsquared.core.plot.flag.implementations.ServerPlotFlag;
import com.plotsquared.core.plot.flag.types.DoubleFlag;
import com.plotsquared.core.plot.schematic.Schematic;
import com.plotsquared.core.plot.world.SinglePlotArea;
import com.plotsquared.core.queue.QueueCoordinator;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.MathMan;
import com.plotsquared.core.util.PlayerManager;
import com.plotsquared.core.util.RegionManager;
import com.plotsquared.core.util.RegionUtil;
import com.plotsquared.core.util.SchematicHandler;
import com.plotsquared.core.util.TimeUtil;
import com.plotsquared.core.util.WorldUtil;
import com.plotsquared.core.util.query.PlotQuery;
import com.plotsquared.core.util.task.RunnableVal;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.core.util.task.TaskTime;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.world.biome.BiomeType;
import java.lang.ref.Cleaner;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Plot {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + Plot.class.getSimpleName()));
    private static final DecimalFormat FLAG_DECIMAL_FORMAT = new DecimalFormat("0");
    private static final MiniMessage MINI_MESSAGE = MiniMessage.builder().build();
    private static final Cleaner CLEANER = Cleaner.create();
    private final FlagContainer flagContainer = new FlagContainer(null);
    private final PlotCommentContainer plotCommentContainer = new PlotCommentContainer(this);
    private final PlotModificationManager plotModificationManager = new PlotModificationManager(this);
    @Deprecated
    public int temp;
    HashSet<UUID> trusted;
    HashSet<UUID> members;
    HashSet<UUID> denied;
    PlotSettings settings;
    private @NonNull PlotId id;
    @Inject
    private EventDispatcher eventDispatcher;
    @Inject
    private PlotListener plotListener;
    @Inject
    private RegionManager regionManager;
    @Inject
    private WorldUtil worldUtil;
    @Inject
    private SchematicHandler schematicHandler;
    private UUID owner;
    private long timestamp;
    private PlotArea area;
    private ConcurrentHashMap<String, Object> meta;
    private Plot origin;
    private Set<Plot> connectedCache;

    public Plot(PlotArea area, @NonNull PlotId id, UUID owner) {
        this(area, id, owner, 0);
    }

    public Plot(@NonNull PlotArea area, @NonNull PlotId id) {
        this(area, id, null, 0);
    }

    public Plot(PlotArea area, @NonNull PlotId id, UUID owner, int temp) {
        this.area = area;
        this.id = id;
        this.owner = owner;
        this.temp = temp;
        this.flagContainer.setParentContainer(area.getFlagContainer());
        PlotSquared.platform().injector().injectMembers((Object)this);
        CLEANER.register(this, this.flagContainer.createCleanupHook());
    }

    public Plot(@NonNull PlotId id, UUID owner, HashSet<UUID> trusted, HashSet<UUID> members, HashSet<UUID> denied, String alias, BlockLoc position, Collection<PlotFlag<?, ?>> flags, PlotArea area, boolean[] merged, long timestamp, int temp) {
        this.id = id;
        this.area = area;
        this.owner = owner;
        this.settings = new PlotSettings();
        this.members = members;
        this.trusted = trusted;
        this.denied = denied;
        this.settings.setAlias(alias);
        this.settings.setPosition(position);
        this.settings.setMerged(merged);
        this.timestamp = timestamp;
        this.temp = temp;
        if (area != null) {
            this.flagContainer.setParentContainer(area.getFlagContainer());
            if (flags != null) {
                for (PlotFlag<?, ?> flag : flags) {
                    this.flagContainer.addFlag(flag);
                }
            }
        }
        PlotSquared.platform().injector().injectMembers((Object)this);
    }

    public static @Nullable Plot getPlotFromString(@Nullable PlotPlayer<?> player, @Nullable String arg, boolean message) {
        PlotId id;
        String[] split;
        PlotArea area;
        if (arg == null) {
            if (player == null) {
                if (message) {
                    LOGGER.info("No plot area string was supplied");
                }
                return null;
            }
            return player.getCurrentPlot();
        }
        if (player != null) {
            area = PlotSquared.get().getPlotAreaManager().getPlotAreaByString(arg);
            if (area == null) {
                area = player.getApplicablePlotArea();
            }
        } else {
            area = ConsolePlayer.getConsole().getApplicablePlotArea();
        }
        if ((split = arg.split("[;,]")).length == 4) {
            area = PlotSquared.get().getPlotAreaManager().getPlotAreaByString(split[0] + ";" + split[1]);
            id = PlotId.fromString(split[2] + ";" + split[3]);
        } else if (split.length == 3) {
            area = PlotSquared.get().getPlotAreaManager().getPlotAreaByString(split[0]);
            id = PlotId.fromString(split[1] + ";" + split[2]);
        } else if (split.length == 2) {
            id = PlotId.fromString(arg);
        } else {
            Collection<Plot> plots = area == null ? PlotQuery.newQuery().allPlots().asList() : area.getPlots();
            for (Plot p : plots) {
                String name = p.getAlias();
                if (name.isEmpty() || !name.equalsIgnoreCase(arg)) continue;
                return p.getBasePlot(false);
            }
            if (message && player != null) {
                player.sendMessage((Caption)TranslatableCaption.of("invalid.not_valid_plot_id"), new TagResolver[0]);
            }
            return null;
        }
        if (area == null) {
            if (message && player != null) {
                player.sendMessage((Caption)TranslatableCaption.of("errors.invalid_plot_world"), new TagResolver[0]);
            }
            return null;
        }
        return area.getPlotAbs(id);
    }

    public static @Nullable Plot fromString(@Nullable PlotArea defaultArea, @NonNull String string) {
        PlotArea pa;
        String[] split = string.split("[;,]");
        if (split.length == 2) {
            if (defaultArea != null) {
                PlotId id = PlotId.fromString(split[0] + ";" + split[1]);
                return defaultArea.getPlotAbs(id);
            }
        } else if (split.length == 3) {
            PlotArea pa2 = PlotSquared.get().getPlotAreaManager().getPlotArea(split[0], null);
            if (pa2 != null) {
                PlotId id = PlotId.fromString(split[1] + ";" + split[2]);
                return pa2.getPlotAbs(id);
            }
        } else if (split.length == 4 && (pa = PlotSquared.get().getPlotAreaManager().getPlotArea(split[0], split[1])) != null) {
            PlotId id = PlotId.fromString(split[1] + ";" + split[2]);
            return pa.getPlotAbs(id);
        }
        return null;
    }

    public static @Nullable Plot getPlot(@NonNull Location location) {
        PlotArea pa = location.getPlotArea();
        if (pa != null) {
            return pa.getPlot(location);
        }
        return null;
    }

    static @NonNull Location[] getCorners(@NonNull String world, @NonNull CuboidRegion region) {
        BlockVector3 min = region.getMinimumPoint();
        BlockVector3 max = region.getMaximumPoint();
        return new Location[]{Location.at(world, min), Location.at(world, max)};
    }

    public @Nullable UUID getOwnerAbs() {
        return this.owner;
    }

    public void setOwnerAbs(@Nullable UUID owner) {
        this.owner = owner;
    }

    public @Nullable String getWorldName() {
        return this.area.getWorldName();
    }

    public void setMeta(@NonNull String key, @NonNull Object value) {
        if (this.meta == null) {
            this.meta = new ConcurrentHashMap();
        }
        this.meta.put(key, value);
    }

    public @Nullable Object getMeta(@NonNull String key) {
        if (this.meta != null) {
            return this.meta.get(key);
        }
        return null;
    }

    public void deleteMeta(@NonNull String key) {
        if (this.meta != null) {
            this.meta.remove(key);
        }
    }

    public @Nullable PlotCluster getCluster() {
        if (this.getArea() == null) {
            return null;
        }
        return this.getArea().getCluster(this.id);
    }

    public @NonNull List<PlotPlayer<?>> getPlayersInPlot() {
        ArrayList players = new ArrayList();
        for (PlotPlayer<?> player : PlotSquared.platform().playerManager().getPlayers()) {
            if (!this.equals(player.getCurrentPlot())) continue;
            players.add(player);
        }
        return players;
    }

    public boolean hasOwner() {
        return this.getOwnerAbs() != null;
    }

    public boolean isOwner(@NonNull UUID uuid) {
        if (uuid.equals(this.getOwner())) {
            return true;
        }
        if (!this.isMerged()) {
            return false;
        }
        Set<Plot> connected = this.getConnectedPlots();
        for (Plot current : connected) {
            if (!uuid.equals(current.getOwnerAbs())) continue;
            return true;
        }
        return false;
    }

    public boolean isOwnerAbs(@Nullable UUID uuid) {
        if (uuid == null) {
            return false;
        }
        return uuid.equals(this.getOwner());
    }

    public @Nullable UUID getOwner() {
        if (((Boolean)this.getFlag((PlotFlag)((Object)ServerPlotFlag.class))).booleanValue()) {
            return DBFunc.SERVER;
        }
        return this.getOwnerAbs();
    }

    public void setOwner(@NonNull UUID owner) {
        if (!this.hasOwner()) {
            this.setOwnerAbs(owner);
            this.getPlotModificationManager().create();
            return;
        }
        if (!this.isMerged()) {
            if (!owner.equals(this.getOwnerAbs())) {
                this.setOwnerAbs(owner);
                DBFunc.setOwner(this, owner);
            }
            return;
        }
        for (Plot current : this.getConnectedPlots()) {
            if (owner.equals(current.getOwnerAbs())) continue;
            current.setOwnerAbs(owner);
            DBFunc.setOwner(current, owner);
        }
    }

    public @NonNull Set<UUID> getOwners() {
        ImmutableSet.Builder owners = ImmutableSet.builder();
        for (Plot plot : this.getConnectedPlots()) {
            UUID owner = plot.getOwner();
            if (owner == null) continue;
            owners.add((Object)owner);
        }
        return owners.build();
    }

    public boolean isAdded(@NonNull UUID uuid) {
        if (!this.hasOwner() || this.getDenied().contains(uuid)) {
            return false;
        }
        if (this.isOwner(uuid)) {
            return true;
        }
        if (this.getMembers().contains(uuid)) {
            return this.isOnline();
        }
        if (this.getTrusted().contains(uuid) || this.getTrusted().contains(DBFunc.EVERYONE)) {
            return true;
        }
        if (this.getMembers().contains(DBFunc.EVERYONE)) {
            return this.isOnline();
        }
        return false;
    }

    public boolean isDenied(@NonNull UUID uuid) {
        return this.denied != null && (this.denied.contains(DBFunc.EVERYONE) && !this.isAdded(uuid) || !this.isAdded(uuid) && this.denied.contains(uuid));
    }

    public @NonNull PlotId getId() {
        return this.id;
    }

    public void setId(@NonNull PlotId id) {
        this.id = id;
    }

    public @Nullable PlotArea getArea() {
        return this.area;
    }

    public void setArea(@NonNull PlotArea area) {
        if (this.getArea() == area) {
            return;
        }
        if (this.getArea() != null) {
            this.area.removePlot(this.id);
        }
        this.area = area;
        area.addPlot(this);
        this.flagContainer.setParentContainer(area.getFlagContainer());
    }

    public @NonNull PlotManager getManager() {
        return this.area.getPlotManager();
    }

    public @NonNull PlotSettings getSettings() {
        if (this.settings == null) {
            this.settings = new PlotSettings();
        }
        return this.settings;
    }

    public boolean isBasePlot() {
        return !this.isMerged() || this.equals(this.getBasePlot(false));
    }

    public Plot getBasePlot(boolean recalculate) {
        if (this.origin != null && !recalculate) {
            if (this.equals(this.origin)) {
                return this;
            }
            return this.origin.getBasePlot(false);
        }
        if (!this.isMerged()) {
            this.origin = this;
            return this.origin;
        }
        this.origin = this;
        PlotId min = this.id;
        for (Plot plot : this.getConnectedPlots()) {
            if (plot.id.getY() >= min.getY() && (plot.id.getY() != min.getY() || plot.id.getX() >= min.getX())) continue;
            this.origin = plot;
            min = plot.id;
        }
        for (Plot plot : this.getConnectedPlots()) {
            plot.origin = this.origin;
        }
        return this.origin;
    }

    public boolean isMerged() {
        return this.getSettings().getMerged(0) || this.getSettings().getMerged(2) || this.getSettings().getMerged(1) || this.getSettings().getMerged(3);
    }

    public long getTimestamp() {
        if (this.timestamp == 0L) {
            this.timestamp = System.currentTimeMillis();
        }
        return this.timestamp;
    }

    public boolean isMerged(int dir) {
        if (this.settings == null) {
            return false;
        }
        switch (dir) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return this.getSettings().getMerged(dir);
            }
            case 7: {
                int i = dir - 4;
                int i2 = 0;
                if (this.getSettings().getMerged(i2) && this.getSettings().getMerged(i) && Objects.requireNonNull(this.area.getPlotAbs(this.id.getRelative(Direction.getFromIndex(i)))).isMerged(i2)) {
                    return Objects.requireNonNull(this.area.getPlotAbs(this.id.getRelative(Direction.getFromIndex(i2)))).isMerged(i);
                }
                return false;
            }
            case 4: 
            case 5: 
            case 6: {
                int i = dir - 4;
                int i2 = dir - 3;
                return this.getSettings().getMerged(i2) && this.getSettings().getMerged(i) && Objects.requireNonNull(this.area.getPlotAbs(this.id.getRelative(Direction.getFromIndex(i)))).isMerged(i2) && Objects.requireNonNull(this.area.getPlotAbs(this.id.getRelative(Direction.getFromIndex(i2)))).isMerged(i);
            }
        }
        return false;
    }

    public @NonNull HashSet<UUID> getDenied() {
        if (this.denied == null) {
            this.denied = new HashSet();
        }
        return this.denied;
    }

    public void setDenied(@NonNull Set<UUID> uuids) {
        boolean larger = uuids.size() > this.getDenied().size();
        HashSet<UUID> intersection = larger ? new HashSet<UUID>(this.getDenied()) : new HashSet<UUID>(uuids);
        if (larger) {
            intersection.retainAll(uuids);
        } else {
            intersection.retainAll(this.getDenied());
        }
        uuids.removeAll(intersection);
        HashSet<UUID> toRemove = new HashSet<UUID>(this.getDenied());
        toRemove.removeAll(intersection);
        for (UUID uuid : toRemove) {
            this.removeDenied(uuid);
        }
        for (UUID uuid : uuids) {
            this.addDenied(uuid);
        }
    }

    public @NonNull HashSet<UUID> getTrusted() {
        if (this.trusted == null) {
            this.trusted = new HashSet();
        }
        return this.trusted;
    }

    public void setTrusted(@NonNull Set<UUID> uuids) {
        boolean larger = uuids.size() > this.getTrusted().size();
        HashSet<UUID> intersection = new HashSet<UUID>(larger ? this.getTrusted() : uuids);
        intersection.retainAll(larger ? uuids : this.getTrusted());
        uuids.removeAll(intersection);
        HashSet<UUID> toRemove = new HashSet<UUID>(this.getTrusted());
        toRemove.removeAll(intersection);
        for (UUID uuid : toRemove) {
            this.removeTrusted(uuid);
        }
        for (UUID uuid : uuids) {
            this.addTrusted(uuid);
        }
    }

    public @NonNull HashSet<UUID> getMembers() {
        if (this.members == null) {
            this.members = new HashSet();
        }
        return this.members;
    }

    public void setMembers(@NonNull Set<UUID> uuids) {
        boolean larger = uuids.size() > this.getMembers().size();
        HashSet<UUID> intersection = new HashSet<UUID>(larger ? this.getMembers() : uuids);
        intersection.retainAll(larger ? uuids : this.getMembers());
        uuids.removeAll(intersection);
        HashSet<UUID> toRemove = new HashSet<UUID>(this.getMembers());
        toRemove.removeAll(intersection);
        for (UUID uuid : toRemove) {
            this.removeMember(uuid);
        }
        for (UUID uuid : uuids) {
            this.addMember(uuid);
        }
    }

    public void addDenied(@NonNull UUID uuid) {
        for (Plot current : this.getConnectedPlots()) {
            if (!current.getDenied().add(uuid)) continue;
            DBFunc.setDenied(current, uuid);
        }
    }

    public void addTrusted(@NonNull UUID uuid) {
        for (Plot current : this.getConnectedPlots()) {
            if (!current.getTrusted().add(uuid)) continue;
            DBFunc.setTrusted(current, uuid);
        }
    }

    public void addMember(@NonNull UUID uuid) {
        for (Plot current : this.getConnectedPlots()) {
            if (!current.getMembers().add(uuid)) continue;
            DBFunc.setMember(current, uuid);
        }
    }

    public boolean setOwner(UUID owner, PlotPlayer<?> initiator) {
        if (!this.hasOwner()) {
            this.setOwnerAbs(owner);
            this.getPlotModificationManager().create();
            return true;
        }
        if (!this.isMerged()) {
            if (!owner.equals(this.getOwnerAbs())) {
                this.setOwnerAbs(owner);
                DBFunc.setOwner(this, owner);
            }
            return true;
        }
        for (Plot current : this.getConnectedPlots()) {
            if (owner.equals(current.getOwnerAbs())) continue;
            current.setOwnerAbs(owner);
            DBFunc.setOwner(current, owner);
        }
        return true;
    }

    public boolean isLoaded() {
        return this.worldUtil.isWorld(this.getWorldName());
    }

    public PlotAnalysis getComplexity(Settings.Auto_Clear settings) {
        return PlotAnalysis.getAnalysis(this, settings);
    }

    public Set<PlotFlag<?, ?>> getFlags() {
        return ImmutableSet.copyOf(this.flagContainer.getFlagMap().values());
    }

    public <V> boolean setFlag(@NonNull PlotFlag<V, ?> flag) {
        if (flag instanceof KeepFlag && PlotSquared.platform().expireManager() != null) {
            PlotSquared.platform().expireManager().updateExpired(this);
        }
        for (Plot plot : this.getConnectedPlots()) {
            plot.getFlagContainer().addFlag(flag);
            plot.reEnter();
            DBFunc.setFlag(plot, flag);
        }
        return true;
    }

    public boolean setFlag(@NonNull Class<?> flag, @NonNull String value) {
        try {
            this.setFlag((PlotFlag)GlobalFlagContainer.getInstance().getFlagErased(flag).parse(value));
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean removeFlag(@NonNull Class<? extends PlotFlag<?, ?>> flag) {
        return this.removeFlag((PlotFlag<?, ?>)this.getFlagContainer().queryLocal(flag));
    }

    public Collection<PlotFlag<?, ?>> getApplicableFlags(boolean plotOnly, boolean ignorePluginFlags) {
        Map<Class<?>, PlotFlag<?, ?>> flagMap;
        if (!this.hasOwner()) {
            return Collections.emptyList();
        }
        HashMap flags = new HashMap();
        if (!plotOnly && this.getArea() != null && !this.getArea().getFlagContainer().getFlagMap().isEmpty()) {
            flagMap = this.getArea().getFlagContainer().getFlagMap();
            flags.putAll(flagMap);
        }
        flagMap = this.getFlagContainer().getFlagMap();
        if (ignorePluginFlags) {
            for (PlotFlag<?, ?> flag : flagMap.values()) {
                if (flag instanceof InternalFlag) continue;
                flags.put(flag.getClass(), flag);
            }
        } else {
            flags.putAll(flagMap);
        }
        return flags.values();
    }

    public Collection<PlotFlag<?, ?>> getApplicableFlags(boolean ignorePluginFlags) {
        return this.getApplicableFlags(false, ignorePluginFlags);
    }

    public boolean removeFlag(@NonNull PlotFlag<?, ?> flag) {
        if (flag == null || this.origin == null) {
            return false;
        }
        boolean removed = false;
        for (Plot plot : this.origin.getConnectedPlots()) {
            Object value = plot.getFlagContainer().removeFlag(flag);
            if (value == null) continue;
            plot.reEnter();
            DBFunc.removeFlag(plot, flag);
            removed = true;
        }
        return removed;
    }

    public int[] countEntities() {
        int[] count = new int[6];
        for (Plot current : this.getConnectedPlots()) {
            int[] result = this.regionManager.countEntities(current);
            count[0] = count[0] + result[0];
            count[1] = count[1] + result[1];
            count[2] = count[2] + result[2];
            count[3] = count[3] + result[3];
            count[4] = count[4] + result[4];
            count[5] = count[5] + result[5];
        }
        return count;
    }

    public int addRunning() {
        int value = this.getRunning();
        for (Plot plot : this.getConnectedPlots()) {
            plot.setMeta("running", value + 1);
        }
        return value;
    }

    public int removeRunning() {
        int value = this.getRunning();
        if (value < 2) {
            for (Plot plot : this.getConnectedPlots()) {
                plot.deleteMeta("running");
            }
        } else {
            for (Plot plot : this.getConnectedPlots()) {
                plot.setMeta("running", value - 1);
            }
        }
        return value;
    }

    public int getRunning() {
        Integer value = (Integer)this.getMeta("running");
        return value == null ? 0 : value;
    }

    public boolean unclaim() {
        if (!this.hasOwner()) {
            return false;
        }
        for (Plot current : this.getConnectedPlots()) {
            List<PlotPlayer<?>> players = current.getPlayersInPlot();
            for (PlotPlayer<?> pp : players) {
                this.plotListener.plotExit(pp, current);
            }
            if (Settings.Backup.DELETE_ON_UNCLAIM) {
                Objects.requireNonNull(PlotSquared.platform()).backupManager().getProfile(current).destroy();
            }
            this.getArea().removePlot(this.getId());
            DBFunc.delete(current);
            current.setOwnerAbs(null);
            current.settings = null;
            current.clearCache();
            for (PlotPlayer<?> pp : players) {
                this.plotListener.plotEntry(pp, current);
            }
        }
        return true;
    }

    public void getCenter(Consumer<Location> result) {
        Location[] corners = this.getCorners();
        Location top = corners[0];
        Location bot = corners[1];
        Location location = Location.at(this.getWorldName(), MathMan.average(bot.getX(), top.getX()), MathMan.average(bot.getY(), top.getY()), MathMan.average(bot.getZ(), top.getZ()));
        this.worldUtil.getHighestBlock(this.getWorldName(), location.getX(), location.getZ(), y -> {
            int height = y;
            if (this.area.allowSigns()) {
                height = Math.max(y, this.getManager().getSignLoc(this).getY());
            }
            result.accept(location.withY(1 + height));
        });
    }

    @Deprecated
    public Location getCenterSynchronous() {
        Location[] corners = this.getCorners();
        Location top = corners[0];
        Location bot = corners[1];
        if (!this.isLoaded()) {
            return Location.at("", 0, this.getArea() instanceof ClassicPlotWorld ? ((ClassicPlotWorld)this.getArea()).PLOT_HEIGHT + 1 : 4, 0);
        }
        Location location = Location.at(this.getWorldName(), MathMan.average(bot.getX(), top.getX()), MathMan.average(bot.getY(), top.getY()), MathMan.average(bot.getZ(), top.getZ()));
        int y = this.worldUtil.getHighestBlockSynchronous(this.getWorldName(), location.getX(), location.getZ());
        if (this.area.allowSigns()) {
            y = Math.max(y, this.getManager().getSignLoc(this).getY());
        }
        return location.withY(1 + y);
    }

    @Deprecated
    public Location getSideSynchronous() {
        int y;
        CuboidRegion largest = this.getLargestRegion();
        int x = (largest.getMaximumPoint().getX() >> 1) - (largest.getMinimumPoint().getX() >> 1) + largest.getMinimumPoint().getX();
        int z = largest.getMinimumPoint().getZ() - 1;
        PlotManager manager = this.getManager();
        int n = y = this.isLoaded() ? this.worldUtil.getHighestBlockSynchronous(this.getWorldName(), x, z) : 62;
        if (this.area.allowSigns() && (y <= this.area.getMinGenHeight() || y >= this.area.getMaxGenHeight())) {
            y = Math.max(y, manager.getSignLoc(this).getY() - 1);
        }
        return Location.at(this.getWorldName(), x, y + 1, z);
    }

    public void getSide(Consumer<Location> result) {
        CuboidRegion largest = this.getLargestRegion();
        int x = (largest.getMaximumPoint().getX() >> 1) - (largest.getMinimumPoint().getX() >> 1) + largest.getMinimumPoint().getX();
        int z = largest.getMinimumPoint().getZ() - 1;
        PlotManager manager = this.getManager();
        if (this.isLoaded()) {
            this.worldUtil.getHighestBlock(this.getWorldName(), x, z, y -> {
                int height = y;
                if (this.area.allowSigns() && (y <= this.area.getMinGenHeight() || y >= this.area.getMaxGenHeight())) {
                    height = Math.max(y, manager.getSignLoc(this).getY() - 1);
                }
                result.accept(Location.at(this.getWorldName(), x, height + 1, z));
            });
        } else {
            int y2 = 62;
            if (this.area.allowSigns()) {
                y2 = Math.max(y2, manager.getSignLoc(this).getY() - 1);
            }
            result.accept(Location.at(this.getWorldName(), x, y2 + 1, z));
        }
    }

    @Deprecated
    public Location getHomeSynchronous() {
        BlockLoc home = this.getPosition();
        if (home == null || home.getX() == 0 && home.getZ() == 0) {
            return this.getDefaultHomeSynchronous(true);
        }
        Location bottom = this.getBottomAbs();
        if (!this.isLoaded()) {
            return Location.at("", 0, this.getArea() instanceof ClassicPlotWorld ? ((ClassicPlotWorld)this.getArea()).PLOT_HEIGHT + 1 : 4, 0);
        }
        Location location = this.toHomeLocation(bottom, home);
        if (!this.worldUtil.getBlockSynchronous(location).getBlockType().getMaterial().isAir()) {
            location = location.withY(Math.max(1 + this.worldUtil.getHighestBlockSynchronous(this.getWorldName(), location.getX(), location.getZ()), bottom.getY()));
        }
        return location;
    }

    public void getHome(Consumer<Location> result) {
        BlockLoc home = this.getPosition();
        if (home == null || home.getX() == 0 && home.getZ() == 0) {
            this.getDefaultHome(result);
        } else {
            if (!this.isLoaded()) {
                result.accept(Location.at("", 0, this.getArea() instanceof ClassicPlotWorld ? ((ClassicPlotWorld)this.getArea()).PLOT_HEIGHT + 1 : 4, 0));
                return;
            }
            Location bottom = this.getBottomAbs();
            Location location = this.toHomeLocation(bottom, home);
            this.worldUtil.getBlock(location, block -> {
                if (!block.getBlockType().getMaterial().isAir()) {
                    this.worldUtil.getHighestBlock(this.getWorldName(), location.getX(), location.getZ(), y -> result.accept(location.withY(Math.max(1 + y, bottom.getY()))));
                } else {
                    result.accept(location);
                }
            });
        }
    }

    private Location toHomeLocation(Location bottom, BlockLoc relativeHome) {
        return Location.at(bottom.getWorldName(), bottom.getX() + relativeHome.getX(), relativeHome.getY(), bottom.getZ() + relativeHome.getZ(), relativeHome.getYaw(), relativeHome.getPitch());
    }

    public void setHome(BlockLoc location) {
        Plot plot = this.getBasePlot(false);
        if (location != null && (BlockLoc.ZERO.equals(location) || BlockLoc.MINY.equals(location))) {
            return;
        }
        plot.getSettings().setPosition(location);
        if (location != null) {
            DBFunc.setPosition(plot, plot.getSettings().getPosition().toString());
            return;
        }
        DBFunc.setPosition(plot, null);
    }

    public void getDefaultHome(Consumer<Location> result) {
        this.getDefaultHome(false, result);
    }

    @Deprecated
    public Location getDefaultHomeSynchronous(boolean member) {
        BlockLoc loc;
        Plot plot = this.getBasePlot(false);
        BlockLoc blockLoc = loc = member ? this.area.defaultHome() : this.area.nonmemberHome();
        if (loc != null) {
            int z;
            int x;
            if (loc.getX() == Integer.MAX_VALUE && loc.getZ() == Integer.MAX_VALUE) {
                if (this.getArea() instanceof SinglePlotArea) {
                    int y = loc.getY() == Integer.MIN_VALUE ? (this.isLoaded() ? this.worldUtil.getHighestBlockSynchronous(plot.getWorldName(), 0, 0) + 1 : 63) : loc.getY();
                    return Location.at(plot.getWorldName(), 0, y, 0, 0.0f, 0.0f);
                }
                CuboidRegion largest = plot.getLargestRegion();
                x = (largest.getMaximumPoint().getX() >> 1) - (largest.getMinimumPoint().getX() >> 1) + largest.getMinimumPoint().getX();
                z = (largest.getMaximumPoint().getZ() >> 1) - (largest.getMinimumPoint().getZ() >> 1) + largest.getMinimumPoint().getZ();
            } else {
                Location bot = plot.getBottomAbs();
                x = bot.getX() + loc.getX();
                z = bot.getZ() + loc.getZ();
            }
            int y = loc.getY() == Integer.MIN_VALUE ? (this.isLoaded() ? this.worldUtil.getHighestBlockSynchronous(plot.getWorldName(), x, z) + 1 : 63) : loc.getY();
            return Location.at(plot.getWorldName(), x, y, z, loc.getYaw(), loc.getPitch());
        }
        if (this.getArea() instanceof SinglePlotArea) {
            int y = this.isLoaded() ? this.worldUtil.getHighestBlockSynchronous(plot.getWorldName(), 0, 0) + 1 : 63;
            return Location.at(plot.getWorldName(), 0, y, 0, 0.0f, 0.0f);
        }
        return plot.getSideSynchronous();
    }

    public void getDefaultHome(boolean member, Consumer<Location> result) {
        BlockLoc loc;
        Plot plot = this.getBasePlot(false);
        if (!this.isLoaded()) {
            result.accept(Location.at("", 0, this.getArea() instanceof ClassicPlotWorld ? ((ClassicPlotWorld)this.getArea()).PLOT_HEIGHT + 1 : 4, 0));
            return;
        }
        BlockLoc blockLoc = loc = member ? this.area.defaultHome() : this.area.nonmemberHome();
        if (loc != null) {
            int z;
            int x;
            if (loc.getX() == Integer.MAX_VALUE && loc.getZ() == Integer.MAX_VALUE) {
                if (this.getArea() instanceof SinglePlotArea) {
                    x = 0;
                    z = 0;
                } else {
                    CuboidRegion largest = plot.getLargestRegion();
                    x = (largest.getMaximumPoint().getX() >> 1) - (largest.getMinimumPoint().getX() >> 1) + largest.getMinimumPoint().getX();
                    z = (largest.getMaximumPoint().getZ() >> 1) - (largest.getMinimumPoint().getZ() >> 1) + largest.getMinimumPoint().getZ();
                }
            } else {
                Location bot = plot.getBottomAbs();
                x = bot.getX() + loc.getX();
                z = bot.getZ() + loc.getZ();
            }
            if (loc.getY() == Integer.MIN_VALUE) {
                if (this.isLoaded()) {
                    this.worldUtil.getHighestBlock(plot.getWorldName(), x, z, y -> result.accept(Location.at(plot.getWorldName(), x, y + 1, z)));
                } else {
                    int y2 = this.getArea() instanceof ClassicPlotWorld ? ((ClassicPlotWorld)this.getArea()).PLOT_HEIGHT + 1 : 63;
                    result.accept(Location.at(plot.getWorldName(), x, y2, z, loc.getYaw(), loc.getPitch()));
                }
            } else {
                result.accept(Location.at(plot.getWorldName(), x, loc.getY(), z, loc.getYaw(), loc.getPitch()));
            }
            return;
        }
        if (this.getArea() instanceof SinglePlotArea) {
            int y3 = this.isLoaded() ? this.worldUtil.getHighestBlockSynchronous(plot.getWorldName(), 0, 0) + 1 : 63;
            result.accept(Location.at(plot.getWorldName(), 0, y3, 0, 0.0f, 0.0f));
        }
        plot.getSide(result);
    }

    public double getVolume() {
        double count = 0.0;
        for (CuboidRegion region : this.getRegions()) {
            count += (double)(region.getLength() * region.getWidth() * (this.area.getMaxGenHeight() - this.area.getMinGenHeight() + 1));
        }
        return count;
    }

    public double getAverageRating() {
        Collection<Rating> ratings = this.getRatings().values();
        double sum = ratings.stream().mapToDouble(Rating::getAverageRating).sum();
        return sum / (double)ratings.size();
    }

    public boolean addRating(UUID uuid, Rating rating) {
        Plot base = this.getBasePlot(false);
        PlotSettings baseSettings = base.getSettings();
        if (baseSettings.getRatings().containsKey(uuid)) {
            return false;
        }
        int aggregate = rating.getAggregate();
        baseSettings.getRatings().put(uuid, aggregate);
        DBFunc.setRating(base, uuid, aggregate);
        return true;
    }

    public void clearRatings() {
        Plot base = this.getBasePlot(false);
        PlotSettings baseSettings = base.getSettings();
        if (baseSettings.getRatings() != null && !baseSettings.getRatings().isEmpty()) {
            DBFunc.deleteRatings(base);
            baseSettings.setRatings(null);
        }
    }

    public Map<UUID, Boolean> getLikes() {
        HashMap<UUID, Boolean> map = new HashMap<UUID, Boolean>();
        HashMap<UUID, Rating> ratings = this.getRatings();
        ratings.forEach((uuid, rating) -> map.put((UUID)uuid, rating.getLike()));
        return map;
    }

    public HashMap<UUID, Rating> getRatings() {
        Plot base = this.getBasePlot(false);
        HashMap<UUID, Rating> map = new HashMap<UUID, Rating>();
        if (!base.hasRatings()) {
            return map;
        }
        for (Map.Entry<UUID, Integer> entry : base.getSettings().getRatings().entrySet()) {
            map.put(entry.getKey(), new Rating(entry.getValue()));
        }
        return map;
    }

    public boolean hasRatings() {
        Plot base = this.getBasePlot(false);
        return base.settings != null && base.settings.getRatings() != null;
    }

    public boolean claim(final @NonNull PlotPlayer<?> player, boolean teleport, String schematic, boolean updateDB, boolean auto) {
        PlotArea plotworld;
        this.eventDispatcher.callPlotClaimedNotify(this, auto);
        if (updateDB) {
            if (!this.getPlotModificationManager().create(player.getUUID(), true)) {
                LOGGER.error("Player {} attempted to claim plot {}, but the database failed to update", (Object)player.getName(), (Object)this.getId().toCommaSeparatedString());
                return false;
            }
        } else {
            this.area.addPlot(this);
            this.updateWorldBorder();
        }
        player.sendMessage((Caption)TranslatableCaption.of("working.claimed"), new TagResolver[]{TagResolver.resolver((String)"plot", (Tag)Tag.inserting((Component)Component.text((String)this.getId().toString())))});
        if (teleport) {
            if (!auto && Settings.Teleport.ON_CLAIM) {
                this.teleportPlayer(player, TeleportCause.COMMAND_CLAIM, result -> {});
            } else if (auto && Settings.Teleport.ON_AUTO) {
                this.teleportPlayer(player, TeleportCause.COMMAND_AUTO, result -> {});
            }
        }
        if ((plotworld = this.getArea()).isSchematicOnClaim()) {
            Schematic sch;
            try {
                if (schematic == null || schematic.isEmpty()) {
                    sch = this.schematicHandler.getSchematic(plotworld.getSchematicFile());
                } else {
                    sch = this.schematicHandler.getSchematic(schematic);
                    if (sch == null) {
                        sch = this.schematicHandler.getSchematic(plotworld.getSchematicFile());
                    }
                }
            }
            catch (SchematicHandler.UnsupportedFormatException e) {
                e.printStackTrace();
                return true;
            }
            this.schematicHandler.paste(sch, this, 0, this.getArea().getMinBuildHeight(), 0, Settings.Schematics.PASTE_ON_TOP, player, new RunnableVal<Boolean>(){

                @Override
                public void run(Boolean value) {
                    if (value.booleanValue()) {
                        player.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_paste_success"), new TagResolver[0]);
                    } else {
                        player.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_paste_failed"), new TagResolver[0]);
                    }
                }
            });
        }
        plotworld.getPlotManager().claimPlot(this, null);
        this.getPlotModificationManager().setSign(player.getName());
        return true;
    }

    public void getBiome(Consumer<BiomeType> result) {
        this.getCenter(location -> this.worldUtil.getBiome(location.getWorldName(), location.getX(), location.getZ(), result));
    }

    @Deprecated
    public BiomeType getBiomeSynchronous() {
        Location location = this.getCenterSynchronous();
        return this.worldUtil.getBiomeSynchronous(location.getWorldName(), location.getX(), location.getZ());
    }

    public Location getTopAbs() {
        return this.getManager().getPlotTopLocAbs(this.id).withWorld(this.getWorldName());
    }

    public Location getBottomAbs() {
        return this.getManager().getPlotBottomLocAbs(this.id).withWorld(this.getWorldName());
    }

    public CompletableFuture<Boolean> swapData(Plot plot) {
        if (!this.hasOwner()) {
            if (plot != null && plot.hasOwner()) {
                plot.moveData(this, null);
                return CompletableFuture.completedFuture(true);
            }
            return CompletableFuture.completedFuture(false);
        }
        if (plot == null || plot.getOwner() == null) {
            this.moveData(plot, null);
            return CompletableFuture.completedFuture(true);
        }
        PlotId temp = PlotId.of(this.getId().getX(), this.getId().getY());
        this.id = plot.getId();
        plot.id = temp;
        this.area.removePlot(this.getId());
        plot.area.removePlot(plot.getId());
        this.area.addPlotAbs(this);
        plot.area.addPlotAbs(plot);
        return DBFunc.swapPlots(plot, this);
    }

    public boolean moveData(Plot plot, Runnable whenDone) {
        if (!this.hasOwner()) {
            TaskManager.runTask(whenDone);
            return false;
        }
        if (plot.hasOwner()) {
            TaskManager.runTask(whenDone);
            return false;
        }
        this.area.removePlot(this.id);
        this.id = plot.getId();
        this.area.addPlotAbs(this);
        this.clearCache();
        DBFunc.movePlot(this, plot);
        TaskManager.runTaskLater(whenDone, TaskTime.ticks(1L));
        return true;
    }

    public Location getExtendedTopAbs() {
        Location top = this.getTopAbs();
        if (!this.isMerged()) {
            return top;
        }
        if (this.isMerged(Direction.SOUTH)) {
            top = top.withZ(this.getRelative(Direction.SOUTH).getBottomAbs().getZ() - 1);
        }
        if (this.isMerged(Direction.EAST)) {
            top = top.withX(this.getRelative(Direction.EAST).getBottomAbs().getX() - 1);
        }
        return top;
    }

    public Location getExtendedBottomAbs() {
        Location bot = this.getBottomAbs();
        if (!this.isMerged()) {
            return bot;
        }
        if (this.isMerged(Direction.NORTH)) {
            bot = bot.withZ(this.getRelative(Direction.NORTH).getTopAbs().getZ() + 1);
        }
        if (this.isMerged(Direction.WEST)) {
            bot = bot.withX(this.getRelative(Direction.WEST).getTopAbs().getX() + 1);
        }
        return bot;
    }

    @Deprecated
    public Location[] getCorners() {
        if (!this.isMerged()) {
            return new Location[]{this.getBottomAbs(), this.getTopAbs()};
        }
        return RegionUtil.getCorners(this.getWorldName(), this.getRegions());
    }

    @Deprecated
    public Location getBottom() {
        return this.getCorners()[0];
    }

    @Deprecated
    public Location getTop() {
        return this.getCorners()[1];
    }

    public String toString() {
        if (this.settings != null && this.settings.getAlias().length() > 1) {
            return this.settings.getAlias();
        }
        return String.valueOf(this.area) + ";" + String.valueOf(this.id);
    }

    public boolean removeDenied(UUID uuid) {
        if (uuid == DBFunc.EVERYONE && !this.denied.contains(uuid)) {
            boolean result = false;
            for (UUID other : new HashSet<UUID>(this.getDenied())) {
                result = this.rmvDenied(other) || result;
            }
            return result;
        }
        return this.rmvDenied(uuid);
    }

    private boolean rmvDenied(UUID uuid) {
        for (Plot current : this.getConnectedPlots()) {
            if (current.getDenied().remove(uuid)) {
                DBFunc.removeDenied(current, uuid);
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean removeTrusted(UUID uuid) {
        if (uuid == DBFunc.EVERYONE && !this.trusted.contains(uuid)) {
            boolean result = false;
            for (UUID other : new HashSet<UUID>(this.getTrusted())) {
                result = this.rmvTrusted(other) || result;
            }
            return result;
        }
        return this.rmvTrusted(uuid);
    }

    private boolean rmvTrusted(UUID uuid) {
        for (Plot plot : this.getConnectedPlots()) {
            if (plot.getTrusted().remove(uuid)) {
                DBFunc.removeTrusted(plot, uuid);
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean removeMember(UUID uuid) {
        if (this.members == null) {
            return false;
        }
        if (uuid == DBFunc.EVERYONE && !this.members.contains(uuid)) {
            boolean result = false;
            for (UUID other : new HashSet<UUID>(this.members)) {
                result = this.rmvMember(other) || result;
            }
            return result;
        }
        return this.rmvMember(uuid);
    }

    private boolean rmvMember(UUID uuid) {
        for (Plot current : this.getConnectedPlots()) {
            if (current.getMembers().remove(uuid)) {
                DBFunc.removeMember(current, uuid);
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Plot other = (Plot)obj;
        return this.hashCode() == other.hashCode() && this.id.equals(other.id) && this.area == other.area;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public @NonNull String getAlias() {
        if (this.settings == null) {
            return "";
        }
        return this.settings.getAlias();
    }

    public void setAlias(String alias) {
        for (Plot current : this.getConnectedPlots()) {
            String name = this.getSettings().getAlias();
            if (alias == null) {
                alias = "";
            }
            if (name.equals(alias)) {
                return;
            }
            current.getSettings().setAlias(alias);
            DBFunc.setAlias(current, alias);
        }
    }

    public void setMerged(Direction direction, boolean value) {
        if (this.getSettings().setMerged(direction, value)) {
            if (value) {
                Plot other = this.getRelative(direction).getBasePlot(false);
                if (!other.equals(this.getBasePlot(false))) {
                    Plot base;
                    this.origin.origin = base = other.id.getY() < this.id.getY() || other.id.getY() == this.id.getY() && other.id.getX() < this.id.getX() ? other : this.origin;
                    other.origin = base;
                    this.origin = base;
                    this.connectedCache = null;
                }
            } else {
                if (this.origin != null) {
                    this.origin.origin = null;
                    this.origin = null;
                }
                this.connectedCache = null;
            }
            DBFunc.setMerged(this, this.getSettings().getMerged());
        }
    }

    public boolean[] getMerged() {
        return this.getSettings().getMerged();
    }

    public void setMerged(boolean[] merged) {
        this.getSettings().setMerged(merged);
        DBFunc.setMerged(this, merged);
        this.clearCache();
    }

    public void clearCache() {
        this.connectedCache = null;
        if (this.origin != null) {
            this.origin.origin = null;
            this.origin = null;
        }
    }

    public BlockLoc getPosition() {
        return this.getSettings().getPosition();
    }

    public boolean canClaim(@NonNull PlotPlayer<?> player) {
        if (!WorldUtil.isValidLocation(this.getBottomAbs())) {
            return false;
        }
        PlotCluster cluster = this.getCluster();
        if (cluster != null && !cluster.isAdded(player.getUUID()) && !player.hasPermission("plots.admin.command.claim")) {
            return false;
        }
        UUID owner = this.getOwnerAbs();
        if (owner != null) {
            return false;
        }
        return !this.isMerged();
    }

    public void mergeData(Plot plot) {
        FlagContainer flagContainer2;
        FlagContainer flagContainer1 = this.getFlagContainer();
        if (!flagContainer1.equals(flagContainer2 = plot.getFlagContainer())) {
            boolean greater;
            boolean bl = greater = flagContainer1.getFlagMap().size() > flagContainer2.getFlagMap().size();
            if (greater) {
                flagContainer1.addAll(flagContainer2.getFlagMap().values());
            } else {
                flagContainer2.addAll(flagContainer1.getFlagMap().values());
            }
            if (!greater) {
                this.flagContainer.clearLocal();
                this.flagContainer.addAll(flagContainer2.getFlagMap().values());
            }
            plot.flagContainer.clearLocal();
            plot.flagContainer.addAll(this.flagContainer.getFlagMap().values());
        }
        if (!this.getAlias().isEmpty()) {
            plot.setAlias(this.getAlias());
        } else if (!plot.getAlias().isEmpty()) {
            this.setAlias(plot.getAlias());
        }
        for (UUID uuid : this.getTrusted()) {
            plot.addTrusted(uuid);
        }
        for (UUID uuid : plot.getTrusted()) {
            this.addTrusted(uuid);
        }
        for (UUID uuid : this.getMembers()) {
            plot.addMember(uuid);
        }
        for (UUID uuid : plot.getMembers()) {
            this.addMember(uuid);
        }
        for (UUID uuid : this.getDenied()) {
            plot.addDenied(uuid);
        }
        for (UUID uuid : plot.getDenied()) {
            this.addDenied(uuid);
        }
    }

    public Plot getRelative(int x, int y) {
        return this.area.getPlotAbs(PlotId.of(this.id.getX() + x, this.id.getY() + y));
    }

    public Plot getRelative(PlotArea area, int x, int y) {
        return area.getPlotAbs(PlotId.of(this.id.getX() + x, this.id.getY() + y));
    }

    public @Nullable Plot getRelative(@NonNull Direction direction) {
        return this.area.getPlotAbs(this.id.getRelative(direction));
    }

    public Set<Plot> getConnectedPlots() {
        Plot current;
        if (this.settings == null) {
            return Collections.singleton(this);
        }
        if (!this.isMerged()) {
            return Collections.singleton(this);
        }
        Plot basePlot = this.getBasePlot(false);
        if (this.connectedCache == null && this != basePlot) {
            Set<Plot> connectedPlots = basePlot.getConnectedPlots();
            this.connectedCache = connectedPlots;
            return connectedPlots;
        }
        if (this.connectedCache != null && this.connectedCache.contains(this)) {
            return this.connectedCache;
        }
        HashSet<Plot> tmpSet = new HashSet<Plot>();
        tmpSet.add(this);
        HashSet<Plot> queueCache = new HashSet<Plot>();
        ArrayDeque<Plot> frontier = new ArrayDeque<Plot>();
        this.computeDirectMerged(queueCache, frontier, Direction.NORTH);
        this.computeDirectMerged(queueCache, frontier, Direction.EAST);
        this.computeDirectMerged(queueCache, frontier, Direction.SOUTH);
        this.computeDirectMerged(queueCache, frontier, Direction.WEST);
        while ((current = frontier.poll()) != null) {
            if (!current.hasOwner() || current.settings == null) continue;
            tmpSet.add(current);
            queueCache.remove(current);
            this.addIfIncluded(current, Direction.NORTH, queueCache, tmpSet, frontier);
            this.addIfIncluded(current, Direction.EAST, queueCache, tmpSet, frontier);
            this.addIfIncluded(current, Direction.SOUTH, queueCache, tmpSet, frontier);
            this.addIfIncluded(current, Direction.WEST, queueCache, tmpSet, frontier);
        }
        tmpSet = Set.copyOf(tmpSet);
        this.connectedCache = tmpSet;
        return tmpSet;
    }

    private void computeDirectMerged(Set<Plot> queueCache, Deque<Plot> frontier, Direction direction) {
        if (this.isMerged(direction)) {
            Plot tmp = this.area.getPlotAbs(this.id.getRelative(direction));
            assert (tmp != null);
            if (!tmp.isMerged(direction.opposite())) {
                if (tmp.isOwnerAbs(this.getOwnerAbs())) {
                    tmp.getSettings().setMerged(direction.opposite(), true);
                    DBFunc.setMerged(tmp, tmp.getSettings().getMerged());
                } else {
                    this.getSettings().setMerged(direction, false);
                    DBFunc.setMerged(this, this.getSettings().getMerged());
                }
            }
            queueCache.add(tmp);
            frontier.add(tmp);
        }
    }

    private void addIfIncluded(Plot current, Direction direction, Set<Plot> queueCache, Set<Plot> tmpSet, Deque<Plot> frontier) {
        if (!current.isMerged(direction)) {
            return;
        }
        Plot tmp = current.area.getPlotAbs(current.id.getRelative(direction));
        if (tmp != null && !queueCache.contains(tmp) && !tmpSet.contains(tmp)) {
            queueCache.add(tmp);
            frontier.add(tmp);
        }
    }

    public @NonNull Set<CuboidRegion> getRegions() {
        if (!this.isMerged()) {
            Location pos1 = this.getBottomAbs().withY(this.getArea().getMinBuildHeight());
            Location pos2 = this.getTopAbs().withY(this.getArea().getMaxBuildHeight());
            CuboidRegion rg = new CuboidRegion(pos1.getBlockVector3(), pos2.getBlockVector3());
            return Collections.singleton(rg);
        }
        Set<Plot> plots = this.getConnectedPlots();
        HashSet<CuboidRegion> regions = new HashSet<CuboidRegion>();
        HashSet visited = new HashSet();
        for (Plot current : plots) {
            BlockVector3 pos2;
            BlockVector3 pos1;
            Location topabs;
            Location botabs;
            Location toploc;
            Plot plot;
            if (visited.contains(current.getId())) continue;
            boolean merge = true;
            PlotId bot = current.getId();
            PlotId top = current.getId();
            while (merge) {
                Plot plot2;
                merge = false;
                PlotId.PlotRangeIterator ids = PlotId.PlotRangeIterator.range(PlotId.of(bot.getX(), bot.getY() - 1), PlotId.of(top.getX(), bot.getY() - 1));
                boolean tmp = true;
                for (PlotId id : ids) {
                    plot2 = this.area.getPlotAbs(id);
                    if (plot2 != null && plot2.isMerged(Direction.SOUTH) && !visited.contains(plot2.getId())) continue;
                    tmp = false;
                }
                if (tmp) {
                    merge = true;
                    bot = PlotId.of(bot.getX(), bot.getY() - 1);
                }
                ids = PlotId.PlotRangeIterator.range(PlotId.of(top.getX() + 1, bot.getY()), PlotId.of(top.getX() + 1, top.getY()));
                tmp = true;
                for (PlotId id : ids) {
                    plot2 = this.area.getPlotAbs(id);
                    if (plot2 != null && plot2.isMerged(Direction.WEST) && !visited.contains(plot2.getId())) continue;
                    tmp = false;
                }
                if (tmp) {
                    merge = true;
                    top = PlotId.of(top.getX() + 1, top.getY());
                }
                ids = PlotId.PlotRangeIterator.range(PlotId.of(bot.getX(), top.getY() + 1), PlotId.of(top.getX(), top.getY() + 1));
                tmp = true;
                for (PlotId id : ids) {
                    plot2 = this.area.getPlotAbs(id);
                    if (plot2 != null && plot2.isMerged(Direction.NORTH) && !visited.contains(plot2.getId())) continue;
                    tmp = false;
                }
                if (tmp) {
                    merge = true;
                    top = PlotId.of(top.getX(), top.getY() + 1);
                }
                ids = PlotId.PlotRangeIterator.range(PlotId.of(bot.getX() - 1, bot.getY()), PlotId.of(bot.getX() - 1, top.getY()));
                tmp = true;
                for (PlotId id : ids) {
                    plot2 = this.area.getPlotAbs(id);
                    if (plot2 != null && plot2.isMerged(Direction.EAST) && !visited.contains(plot2.getId())) continue;
                    tmp = false;
                }
                if (!tmp) continue;
                merge = true;
                bot = PlotId.of(bot.getX() - 1, bot.getY());
            }
            int minHeight = this.getArea().getMinBuildHeight();
            int maxHeight = this.getArea().getMaxBuildHeight() - 1;
            Location gtopabs = this.area.getPlotAbs(top).getTopAbs();
            Location gbotabs = this.area.getPlotAbs(bot).getBottomAbs();
            visited.addAll(Lists.newArrayList((Iterable)PlotId.PlotRangeIterator.range(bot, top)));
            for (int x = bot.getX(); x <= top.getX(); ++x) {
                plot = this.area.getPlotAbs(PlotId.of(x, top.getY()));
                if (!plot.isMerged(Direction.SOUTH)) continue;
                toploc = plot.getExtendedTopAbs();
                botabs = plot.getBottomAbs();
                topabs = plot.getTopAbs();
                pos1 = BlockVector3.at((int)botabs.getX(), (int)minHeight, (int)(topabs.getZ() + 1));
                pos2 = BlockVector3.at((int)topabs.getX(), (int)maxHeight, (int)toploc.getZ());
                regions.add(new CuboidRegion(pos1, pos2));
                if (!plot.isMerged(Direction.SOUTHEAST)) continue;
                pos1 = BlockVector3.at((int)(topabs.getX() + 1), (int)minHeight, (int)(topabs.getZ() + 1));
                pos2 = BlockVector3.at((int)toploc.getX(), (int)maxHeight, (int)toploc.getZ());
                regions.add(new CuboidRegion(pos1, pos2));
            }
            for (int y = bot.getY(); y <= top.getY(); ++y) {
                plot = this.area.getPlotAbs(PlotId.of(top.getX(), y));
                if (!plot.isMerged(Direction.EAST)) continue;
                toploc = plot.getExtendedTopAbs();
                botabs = plot.getBottomAbs();
                topabs = plot.getTopAbs();
                pos1 = BlockVector3.at((int)(topabs.getX() + 1), (int)minHeight, (int)botabs.getZ());
                pos2 = BlockVector3.at((int)toploc.getX(), (int)maxHeight, (int)topabs.getZ());
                regions.add(new CuboidRegion(pos1, pos2));
                if (!plot.isMerged(Direction.SOUTHEAST)) continue;
                pos1 = BlockVector3.at((int)(topabs.getX() + 1), (int)minHeight, (int)(topabs.getZ() + 1));
                pos2 = BlockVector3.at((int)toploc.getX(), (int)maxHeight, (int)toploc.getZ());
                regions.add(new CuboidRegion(pos1, pos2));
            }
            BlockVector3 pos12 = BlockVector3.at((int)gbotabs.getX(), (int)minHeight, (int)gbotabs.getZ());
            BlockVector3 pos22 = BlockVector3.at((int)gtopabs.getX(), (int)maxHeight, (int)gtopabs.getZ());
            regions.add(new CuboidRegion(pos12, pos22));
        }
        return regions;
    }

    public CuboidRegion getLargestRegion() {
        Set<CuboidRegion> regions = this.getRegions();
        CuboidRegion max = null;
        double area = Double.NEGATIVE_INFINITY;
        for (CuboidRegion region : regions) {
            double current = ((double)region.getMaximumPoint().getX() - (double)region.getMinimumPoint().getX() + 1.0) * ((double)region.getMaximumPoint().getZ() - (double)region.getMinimumPoint().getZ() + 1.0);
            if (!(current > area)) continue;
            max = region;
            area = current;
        }
        return max;
    }

    public void reEnter() {
        TaskManager.runTaskLater(() -> {
            for (PlotPlayer<?> pp : this.getPlayersInPlot()) {
                this.plotListener.plotExit(pp, this);
                this.plotListener.plotEntry(pp, this);
            }
        }, TaskTime.ticks(1L));
    }

    public void debug(@NonNull String message) {
        try {
            Collection<PlotPlayer<?>> players = PlotPlayer.getDebugModePlayersInPlot(this);
            if (players.isEmpty()) {
                return;
            }
            TranslatableCaption caption = TranslatableCaption.of("debug.plot_debug");
            TagResolver resolver = TagResolver.builder().tag("plot", Tag.inserting((Component)Component.text((String)this.toString()))).tag("message", Tag.inserting((Component)Component.text((String)message))).build();
            for (PlotPlayer<?> player : players) {
                if (!this.isOwner(player.getUUID()) && !player.hasPermission(Permission.PERMISSION_ADMIN_DEBUG_OTHER)) continue;
                player.sendMessage((Caption)caption, resolver);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void teleportPlayer(PlotPlayer<?> player, Consumer<Boolean> result) {
        this.teleportPlayer(player, TeleportCause.PLUGIN, result);
    }

    public void teleportPlayer(PlotPlayer<?> player, TeleportCause cause, Consumer<Boolean> resultConsumer) {
        Plot plot = this.getBasePlot(false);
        if (!(this.getArea() != null && this.getArea() instanceof SinglePlotArea || WorldUtil.isValidLocation(plot.getBottomAbs()))) {
            player.sendMessage((Caption)TranslatableCaption.of("border.denied"), new TagResolver[0]);
            resultConsumer.accept(false);
            return;
        }
        PlayerTeleportToPlotEvent event = this.eventDispatcher.callTeleport(player, player.getLocation(), plot, cause);
        if (event.getEventResult() == Result.DENY) {
            player.sendMessage((Caption)TranslatableCaption.of("events.event_denied"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)"Teleport")))});
            resultConsumer.accept(false);
            return;
        }
        Consumer<Location> locationConsumer = calculatedLocation -> {
            Location location;
            Location location2 = location = event.getLocationTransformer() == null ? calculatedLocation : Objects.requireNonNullElse((Location)event.getLocationTransformer().apply((Location)calculatedLocation), calculatedLocation);
            if (Settings.Teleport.DELAY == 0 || player.hasPermission("plots.teleport.delay.bypass")) {
                player.sendMessage((Caption)TranslatableCaption.of("teleport.teleported_to_plot"), new TagResolver[0]);
                player.teleport(location, cause);
                resultConsumer.accept(true);
                return;
            }
            player.sendMessage((Caption)TranslatableCaption.of("teleport.teleport_in_seconds"), new TagResolver[]{TagResolver.resolver((String)"amount", (Tag)Tag.inserting((Component)Component.text((int)Settings.Teleport.DELAY)))});
            String name = player.getName();
            TaskManager.addToTeleportQueue(name);
            TaskManager.runTaskLater(() -> {
                if (!TaskManager.removeFromTeleportQueue(name)) {
                    return;
                }
                try {
                    player.sendMessage((Caption)TranslatableCaption.of("teleport.teleported_to_plot"), new TagResolver[0]);
                    player.teleport(location, cause);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }, TaskTime.seconds(Settings.Teleport.DELAY));
            resultConsumer.accept(true);
        };
        if (this.area.isHomeAllowNonmember() || plot.isAdded(player.getUUID())) {
            this.getHome(locationConsumer);
        } else {
            this.getDefaultHome(false, locationConsumer);
        }
    }

    public boolean isOnline() {
        if (!this.hasOwner()) {
            return false;
        }
        if (!this.isMerged()) {
            return PlotSquared.platform().playerManager().getPlayerIfExists(Objects.requireNonNull(this.getOwnerAbs())) != null;
        }
        for (Plot current : this.getConnectedPlots()) {
            if (!current.hasOwner() || PlotSquared.platform().playerManager().getPlayerIfExists(Objects.requireNonNull(current.getOwnerAbs())) == null) continue;
            return true;
        }
        return false;
    }

    public int getDistanceFromOrigin() {
        Location bot = this.getManager().getPlotBottomLocAbs(this.id);
        Location top = this.getManager().getPlotTopLocAbs(this.id);
        return Math.max(Math.max(Math.abs(bot.getX()), Math.abs(bot.getZ())), Math.max(Math.abs(top.getX()), Math.abs(top.getZ())));
    }

    public void updateWorldBorder() {
        int border = this.area.getBorder(false);
        if (border == Integer.MAX_VALUE) {
            return;
        }
        int max = this.getDistanceFromOrigin();
        if (max > border) {
            this.area.setMeta("worldBorder", max);
        }
    }

    public void mergePlot(Plot lesserPlot, boolean removeRoads, @Nullable QueueCoordinator queue) {
        Plot greaterPlot = this;
        lesserPlot.getPlotModificationManager().removeSign();
        if (lesserPlot.getId().getX() == greaterPlot.getId().getX()) {
            if (lesserPlot.getId().getY() > greaterPlot.getId().getY()) {
                Plot tmp = lesserPlot;
                lesserPlot = greaterPlot;
                greaterPlot = tmp;
            }
            if (!lesserPlot.isMerged(Direction.SOUTH)) {
                lesserPlot.clearRatings();
                greaterPlot.clearRatings();
                lesserPlot.setMerged(Direction.SOUTH, true);
                greaterPlot.setMerged(Direction.NORTH, true);
                lesserPlot.mergeData(greaterPlot);
                if (removeRoads) {
                    Plot below;
                    lesserPlot.getPlotModificationManager().removeRoadSouth(queue);
                    Plot diagonal = greaterPlot.getRelative(Direction.EAST);
                    if (diagonal.isMerged(Direction.NORTHWEST)) {
                        lesserPlot.plotModificationManager.removeRoadSouthEast(queue);
                    }
                    if ((below = greaterPlot.getRelative(Direction.WEST)).isMerged(Direction.NORTHEAST)) {
                        below.getRelative((Direction)Direction.NORTH).plotModificationManager.removeRoadSouthEast(queue);
                    }
                }
            }
        } else {
            if (lesserPlot.getId().getX() > greaterPlot.getId().getX()) {
                Plot tmp = lesserPlot;
                lesserPlot = greaterPlot;
                greaterPlot = tmp;
            }
            if (!lesserPlot.isMerged(Direction.EAST)) {
                Plot below;
                lesserPlot.clearRatings();
                greaterPlot.clearRatings();
                lesserPlot.setMerged(Direction.EAST, true);
                greaterPlot.setMerged(Direction.WEST, true);
                lesserPlot.mergeData(greaterPlot);
                if (removeRoads) {
                    Plot diagonal = greaterPlot.getRelative(Direction.SOUTH);
                    if (diagonal.isMerged(Direction.NORTHWEST)) {
                        lesserPlot.plotModificationManager.removeRoadSouthEast(queue);
                    }
                    lesserPlot.plotModificationManager.removeRoadEast(queue);
                }
                if ((below = greaterPlot.getRelative(Direction.NORTH)).isMerged(Direction.SOUTHWEST)) {
                    below.getRelative(Direction.WEST).getPlotModificationManager().removeRoadSouthEast(queue);
                }
            }
        }
    }

    public boolean isMerged(@NonNull Direction direction) {
        return this.isMerged(direction.getIndex());
    }

    public <T> @NonNull T getFlag(@NonNull Class<? extends PlotFlag<T, ?>> flagClass) {
        return this.flagContainer.getFlag(flagClass).getValue();
    }

    public <T, V extends PlotFlag<T, ?>> @NonNull T getFlag(@NonNull V flag) {
        Class<?> flagClass = flag.getClass();
        PlotFlag<?, ?> flagInstance = this.flagContainer.getFlagErased(flagClass);
        return ((PlotFlag)FlagContainer.castUnsafe(flagInstance)).getValue();
    }

    public CompletableFuture<Caption> format(Caption iInfo, PlotPlayer<?> player, boolean full) {
        CompletableFuture<Caption> future = new CompletableFuture<Caption>();
        int num = this.getConnectedPlots().size();
        TextComponent alias = !this.getAlias().isEmpty() ? Component.text((String)this.getAlias()) : TranslatableCaption.of("info.none").toComponent(player);
        Location bot = this.getCorners()[0];
        PlotSquared.platform().worldUtil().getBiome(Objects.requireNonNull(this.getWorldName()), bot.getX(), bot.getZ(), arg_0 -> this.lambda$format$13(player, (ComponentLike)alias, num, iInfo, full, future, arg_0));
        return future;
    }

    public @NonNull double[] getAverageRatings() {
        Map<UUID, Integer> rating = this.getSettings().getRatings() != null ? this.getSettings().getRatings() : (Settings.Enabled_Components.RATING_CACHE ? new HashMap<UUID, Integer>() : DBFunc.getRatings(this));
        int size = 1;
        if (!Settings.Ratings.CATEGORIES.isEmpty()) {
            size = Math.max(1, Settings.Ratings.CATEGORIES.size());
        }
        double[] ratings = new double[size];
        if (rating == null || rating.isEmpty()) {
            return ratings;
        }
        for (Map.Entry<UUID, Integer> entry : rating.entrySet()) {
            int current = entry.getValue();
            if (Settings.Ratings.CATEGORIES.isEmpty()) {
                ratings[0] = ratings[0] + (double)current;
                continue;
            }
            int i = 0;
            while (i < Settings.Ratings.CATEGORIES.size()) {
                int n = i++;
                ratings[n] = ratings[n] + (double)(current % 10 - 1);
                current /= 10;
            }
        }
        int i = 0;
        while (i < size) {
            int n = i++;
            ratings[n] = ratings[n] / (double)rating.size();
        }
        return ratings;
    }

    public @NonNull FlagContainer getFlagContainer() {
        return this.flagContainer;
    }

    public @NonNull PlotCommentContainer getPlotCommentContainer() {
        return this.plotCommentContainer;
    }

    public @NonNull PlotModificationManager getPlotModificationManager() {
        return this.plotModificationManager;
    }

    private /* synthetic */ void lambda$format$13(PlotPlayer player, ComponentLike alias, int num, Caption iInfo, boolean full, CompletableFuture future, BiomeType biome) {
        Component flags;
        Collection<PlotFlag<?, ?>> flagCollection;
        int time;
        Component trusted = PlayerManager.getPlayerList(this.getTrusted(), player);
        Component members = PlayerManager.getPlayerList(this.getMembers(), player);
        Component denied = PlayerManager.getPlayerList(this.getDenied(), player);
        ExpireManager expireManager = PlotSquared.platform().expireManager();
        Object seen = Settings.Enabled_Components.PLOT_EXPIRY && expireManager != null ? (this.isOnline() ? TranslatableCaption.of("info.now").toComponent(player) : ((time = (int)(PlotSquared.platform().expireManager().getAge(this, false) / 1000L)) != 0 ? Component.text((String)TimeUtil.secToTime(time)) : TranslatableCaption.of("info.unknown").toComponent(player))) : TranslatableCaption.of("info.never").toComponent(player);
        Component description = TranslatableCaption.of("info.plot_no_description").toComponent(player);
        String descriptionValue = (String)this.getFlag((PlotFlag)((Object)DescriptionFlag.class));
        if (!descriptionValue.isEmpty()) {
            description = Component.text((String)descriptionValue);
        }
        if ((flagCollection = this.getApplicableFlags(true)).isEmpty()) {
            flags = TranslatableCaption.of("info.none").toComponent(player);
        } else {
            TextComponent.Builder flagBuilder = Component.text();
            String prefix = "";
            for (PlotFlag<?, ?> flag : flagCollection) {
                String value = flag instanceof DoubleFlag && !Settings.General.SCIENTIFIC ? FLAG_DECIMAL_FORMAT.format(flag.getValue()) : flag.toString();
                Component snip = MINI_MESSAGE.deserialize(prefix + CaptionUtility.format(player, TranslatableCaption.of("info.plot_flag_list").getComponent(player)), TagResolver.builder().tag("flag", Tag.inserting((Component)Component.text((String)flag.getName()))).tag("value", Tag.inserting((Component)Component.text((String)CaptionUtility.formatRaw(player, value.toString())))).build());
                flagBuilder.append(snip);
                prefix = ", ";
            }
            flags = flagBuilder.build();
        }
        boolean build = this.isAdded(player.getUUID());
        Object owner = this.getOwner() == null ? Component.text((String)"unowned") : (this.getOwner().equals(DBFunc.SERVER) ? Component.text((String)MINI_MESSAGE.stripTags(TranslatableCaption.of("info.server").getComponent(player))) : PlayerManager.getPlayerList(this.getOwners(), player));
        TagResolver.Builder tagBuilder = TagResolver.builder();
        tagBuilder.tag("header", Tag.inserting((Component)TranslatableCaption.of("info.plot_info_header").toComponent(player)));
        tagBuilder.tag("footer", Tag.inserting((Component)TranslatableCaption.of("info.plot_info_footer").toComponent(player)));
        TextComponent.Builder areaComponent = Component.text();
        if (this.getArea() != null) {
            areaComponent.append((Component)Component.text((String)this.getArea().getWorldName()));
            if (this.getArea().getId() != null) {
                ((TextComponent.Builder)((TextComponent.Builder)areaComponent.append((Component)Component.text((String)"("))).append((Component)Component.text((String)this.getArea().getId()))).append((Component)Component.text((String)")"));
            }
        } else {
            areaComponent.append(TranslatableCaption.of("info.none").toComponent(player));
        }
        tagBuilder.tag("area", Tag.inserting((ComponentLike)areaComponent));
        long creationDate = Long.parseLong(String.valueOf(this.timestamp));
        SimpleDateFormat sdf = new SimpleDateFormat(Settings.Timeformat.DATE_FORMAT);
        sdf.setTimeZone(TimeZone.getTimeZone(Settings.Timeformat.TIME_ZONE));
        String newDate = sdf.format(creationDate);
        tagBuilder.tag("id", Tag.inserting((Component)Component.text((String)this.getId().toString())));
        tagBuilder.tag("alias", Tag.inserting((ComponentLike)alias));
        tagBuilder.tag("num", Tag.inserting((Component)Component.text((int)num)));
        tagBuilder.tag("desc", Tag.inserting((ComponentLike)description));
        tagBuilder.tag("biome", Tag.inserting((Component)Component.text((String)biome.toString().toLowerCase())));
        tagBuilder.tag("owner", Tag.inserting((Component)owner));
        tagBuilder.tag("members", Tag.inserting((ComponentLike)members));
        tagBuilder.tag("player", Tag.inserting((Component)Component.text((String)player.getName())));
        tagBuilder.tag("trusted", Tag.inserting((ComponentLike)trusted));
        tagBuilder.tag("denied", Tag.inserting((ComponentLike)denied));
        tagBuilder.tag("seen", Tag.inserting((ComponentLike)seen));
        tagBuilder.tag("flags", Tag.inserting((ComponentLike)flags));
        tagBuilder.tag("creationdate", Tag.inserting((Component)Component.text((String)newDate)));
        tagBuilder.tag("build", Tag.inserting((Component)Component.text((boolean)build)));
        tagBuilder.tag("size", Tag.inserting((Component)Component.text((int)this.getConnectedPlots().size())));
        String component = iInfo.getComponent(player);
        if (component.contains("<rating>") || component.contains("<likes>")) {
            TaskManager.runTaskAsync(() -> {
                if (Settings.Ratings.USE_LIKES) {
                    tagBuilder.tag("rating", Tag.inserting((Component)Component.text((String)String.format("%.0f%%", Like.getLikesPercentage(this) * 100.0))));
                    tagBuilder.tag("likes", Tag.inserting((Component)Component.text((String)String.format("%.0f%%", Like.getLikesPercentage(this) * 100.0))));
                } else {
                    int max = 10;
                    if (Settings.Ratings.CATEGORIES != null && !Settings.Ratings.CATEGORIES.isEmpty()) {
                        max = 8;
                    }
                    if (full && Settings.Ratings.CATEGORIES != null && Settings.Ratings.CATEGORIES.size() > 1) {
                        double[] ratings = this.getAverageRatings();
                        StringBuilder rating = new StringBuilder();
                        String prefix = "";
                        for (int i = 0; i < ratings.length; ++i) {
                            rating.append(prefix).append(Settings.Ratings.CATEGORIES.get(i)).append('=').append(String.format("%.1f", ratings[i]));
                            prefix = ",";
                        }
                        tagBuilder.tag("rating", Tag.inserting((Component)Component.text((String)rating.toString())));
                    } else {
                        double rating = this.getAverageRating();
                        if (Double.isFinite(rating)) {
                            tagBuilder.tag("rating", Tag.inserting((Component)Component.text((String)(String.format("%.1f", rating) + "/" + max))));
                        } else {
                            tagBuilder.tag("rating", Tag.inserting((Component)TranslatableCaption.of("info.none").toComponent(player)));
                        }
                    }
                    tagBuilder.tag("likes", Tag.inserting((Component)Component.text((String)"N/A")));
                }
                future.complete(StaticCaption.of((String)MINI_MESSAGE.serialize(MINI_MESSAGE.deserialize(iInfo.getComponent(player), tagBuilder.build()))));
            });
            return;
        }
        future.complete(StaticCaption.of((String)MINI_MESSAGE.serialize(MINI_MESSAGE.deserialize(iInfo.getComponent(player), tagBuilder.build()))));
    }

    static {
        FLAG_DECIMAL_FORMAT.setMaximumFractionDigits(340);
    }
}

