/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.location;

public enum Direction {
    ALL(-1, "all"),
    NORTH(0, "north"),
    EAST(1, "east"),
    SOUTH(2, "south"),
    WEST(3, "west"),
    NORTHEAST(4, "northeast"),
    SOUTHEAST(5, "southeast"),
    SOUTHWEST(6, "southwest"),
    NORTHWEST(7, "northwest");

    private final int index;
    private final String name;

    private Direction(int index, String name) {
        this.index = index;
        this.name = name;
    }

    public static Direction getFromIndex(int index) {
        for (Direction value : Direction.values()) {
            if (value.getIndex() != index) continue;
            return value;
        }
        return NORTH;
    }

    public Direction opposite() {
        return switch (this.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> ALL;
            case 1 -> SOUTH;
            case 2 -> WEST;
            case 3 -> NORTH;
            case 4 -> EAST;
            case 5 -> SOUTHWEST;
            case 6 -> NORTHWEST;
            case 7 -> NORTHEAST;
            case 8 -> SOUTHEAST;
        };
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }
}

