/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.location;

import com.plotsquared.core.util.StringMan;

public class BlockLoc {
    public static final BlockLoc ZERO = new BlockLoc(0, 0, 0);
    public static final BlockLoc MINY = new BlockLoc(0, Integer.MIN_VALUE, 0);
    private static final BlockLoc MIDDLE = new BlockLoc(Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE);
    private final int x;
    private final int y;
    private final int z;
    private final float yaw;
    private final float pitch;

    public BlockLoc(int x, int y, int z) {
        this(x, y, z, 0.0f, 0.0f);
    }

    public BlockLoc(int x, int y, int z, float yaw, float pitch) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public static BlockLoc fromString(String string) {
        float pitch;
        float yaw;
        if (string == null || "side".equalsIgnoreCase(string)) {
            return null;
        }
        if (StringMan.isEqualIgnoreCaseToAny(string, "center", "middle", "centre")) {
            return MIDDLE;
        }
        String[] parts = string.split(",");
        if (parts.length == 5) {
            yaw = Float.parseFloat(parts[3]);
            pitch = Float.parseFloat(parts[4]);
        } else if (parts.length == 3) {
            yaw = 0.0f;
            pitch = 0.0f;
        } else {
            return ZERO;
        }
        int x = Integer.parseInt(parts[0]);
        int y = Integer.parseInt(parts[1]);
        int z = Integer.parseInt(parts[2]);
        return new BlockLoc(x, y, z, yaw, pitch);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + this.getX();
        result = prime * result + this.getY();
        result = prime * result + this.getZ();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return this.getX() == 0 && this.getY() == 0 && this.getZ() == 0;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlockLoc other = (BlockLoc)obj;
        return this.getX() == other.getX() && this.getY() == other.getY() && this.getZ() == other.getZ() && this.getYaw() == other.getYaw() && this.getPitch() == other.getPitch();
    }

    public String toString() {
        if (this.getX() == 0 && this.getY() == 0 && this.getZ() == 0 && this.getYaw() == 0.0f && this.getPitch() == 0.0f) {
            return "";
        }
        return this.getX() + "," + this.getY() + "," + this.getZ() + "," + this.getYaw() + "," + this.getPitch();
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }
}

