/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.configuration.caption;

import com.google.common.base.Objects;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.caption.LocaleHolder;
import com.plotsquared.core.configuration.caption.NamespacedCaption;
import java.util.Locale;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.NotNull;

public final class TranslatableCaption
implements NamespacedCaption {
    public static final String DEFAULT_NAMESPACE = "plotsquared";
    private final String namespace;
    private final String key;

    private TranslatableCaption(@NonNull String namespace, @NonNull String key) {
        this.namespace = namespace;
        this.key = key;
    }

    public static @NonNull TranslatableCaption of(@NonNull String rawKey) {
        String key;
        String namespace;
        if (rawKey.contains(":")) {
            String[] split = rawKey.split(Pattern.quote(":"));
            namespace = split[0];
            key = split[1];
        } else {
            namespace = DEFAULT_NAMESPACE;
            key = rawKey;
        }
        return new TranslatableCaption(namespace.toLowerCase(Locale.ENGLISH), key.toLowerCase(Locale.ENGLISH));
    }

    public static @NonNull TranslatableCaption of(@NonNull String namespace, @NonNull String key) {
        return new TranslatableCaption(namespace.toLowerCase(Locale.ENGLISH), key.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public @NonNull String getComponent(@NonNull LocaleHolder localeHolder) {
        return PlotSquared.get().getCaptionMap(this.namespace).getMessage(this, localeHolder);
    }

    @Override
    public @NonNull Component toComponent(@NonNull LocaleHolder localeHolder) {
        if (this.getKey().equals("core.prefix")) {
            return MiniMessage.miniMessage().deserialize((Object)this.getComponent(localeHolder));
        }
        return MiniMessage.miniMessage().deserialize(this.getComponent(localeHolder), (TagResolver)TagResolver.resolver((String)"prefix", (Tag)Tag.inserting((Component)TranslatableCaption.of("core.prefix").toComponent(localeHolder))));
    }

    @Override
    public @NonNull String getKey() {
        return this.key;
    }

    @Override
    public @NonNull String getNamespace() {
        return this.namespace;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TranslatableCaption that = (TranslatableCaption)o;
        return Objects.equal((Object)this.getNamespace(), (Object)that.getNamespace()) && Objects.equal((Object)this.getKey(), (Object)that.getKey());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getNamespace(), this.getKey()});
    }

    @Override
    @NotNull
    public String toString() {
        return "TranslatableCaption(" + this.getNamespace() + ":" + this.getKey() + ")";
    }
}

