/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.configuration;

import com.plotsquared.core.configuration.MemorySection;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.file.YamlConfiguration;
import com.plotsquared.core.util.StringMan;
import java.io.File;
import java.io.PrintWriter;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Config {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + Config.class.getSimpleName()));

    public static void set(String key, Object value, Class<? extends Config> root) {
        Field field;
        String[] split = key.split("\\.");
        Object instance = Config.getInstance(split, root);
        if (instance != null && (field = Config.getField(split, instance)) != null) {
            try {
                if (field.getAnnotation(Final.class) != null) {
                    return;
                }
                if (field.getType() == String.class && !(value instanceof String)) {
                    value = String.valueOf(value);
                }
                field.set(instance, value);
                return;
            }
            catch (Throwable e) {
                LOGGER.error("Invalid configuration value '{}: {}' in {}", (Object)key, value, (Object)root.getSimpleName());
                e.printStackTrace();
            }
        }
        LOGGER.error("Failed to set config option '{}: {}' | {}", (Object)key, value, instance);
    }

    public static boolean load(File file, Class<? extends Config> root) {
        if (!file.exists()) {
            return false;
        }
        YamlConfiguration yml = YamlConfiguration.loadConfiguration(file);
        for (String key : yml.getKeys(true)) {
            Object value = yml.get(key);
            if (value instanceof MemorySection) continue;
            Config.set(key, value, root);
        }
        return true;
    }

    public static void save(File file, Class<? extends Config> root) {
        try {
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            try (PrintWriter writer = new PrintWriter(file);){
                Config instance = root.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Config.save(writer, root, instance, 0);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static Map<String, Object> getFields(Class<Settings.Enabled_Components> clazz) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Field field : clazz.getFields()) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            try {
                map.put(Config.toNodeName(field.getName()), field.get(null));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    private static String toYamlString(Object value, String spacing) {
        if (value instanceof List) {
            Collection listValue = (Collection)value;
            if (listValue.isEmpty()) {
                return "[]";
            }
            StringBuilder m = new StringBuilder();
            for (Object obj : listValue) {
                m.append(System.lineSeparator()).append(spacing).append("- ").append(Config.toYamlString(obj, spacing));
            }
            return m.toString();
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            if (stringValue.isEmpty()) {
                return "''";
            }
            return "\"" + stringValue + "\"";
        }
        return value != null ? value.toString() : "null";
    }

    private static void save(PrintWriter writer, Class<?> clazz, Object instance, int indent) {
        try {
            Comment comment;
            String lineSeparator = System.lineSeparator();
            String spacing = StringMan.repeat(" ", indent);
            block2: for (Field field : clazz.getFields()) {
                String[] create;
                if (field.getAnnotation(Ignore.class) != null) continue;
                comment = field.getAnnotation(Comment.class);
                if (comment != null) {
                    for (String string : comment.value()) {
                        writer.write(spacing + "# " + string + lineSeparator);
                    }
                }
                if ((create = field.getAnnotation(Create.class)) != null) {
                    Class<?>[] classes;
                    Object value = field.get(instance);
                    if (value != null || field.getType() == ConfigBlock.class) continue;
                    Config.setAccessible(field);
                    for (Class<?> current : classes = clazz.getDeclaredClasses()) {
                        if (!StringMan.isEqual(current.getSimpleName(), field.getName())) continue;
                        field.set(instance, current.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                        continue block2;
                    }
                    continue;
                }
                writer.write(spacing + Config.toNodeName(field.getName() + ": ") + Config.toYamlString(field.get(instance), spacing) + lineSeparator);
            }
            for (AnnotatedElement annotatedElement : clazz.getClasses()) {
                if (((Class)annotatedElement).isInterface() || ((Class)annotatedElement).getAnnotation(Ignore.class) != null) continue;
                if (indent == 0) {
                    writer.write(lineSeparator);
                }
                if ((comment = ((Class)annotatedElement).getAnnotation(Comment.class)) != null) {
                    for (String string : comment.value()) {
                        writer.write(spacing + "# " + string + lineSeparator);
                    }
                }
                writer.write(spacing + Config.toNodeName(((Class)annotatedElement).getSimpleName()) + ":" + lineSeparator);
                BlockName blockNames = ((Class)annotatedElement).getAnnotation(BlockName.class);
                if (blockNames != null) {
                    Field instanceField = clazz.getDeclaredField(Config.toFieldName(((Class)annotatedElement).getSimpleName()));
                    Config.setAccessible(instanceField);
                    ConfigBlock value = (ConfigBlock)instanceField.get(instance);
                    if (value == null) {
                        value = new ConfigBlock();
                        instanceField.set(instance, value);
                        for (String blockName : blockNames.value()) {
                            value.put(blockName, ((Class)annotatedElement).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                        }
                    }
                    for (Map.Entry entry : value.getRaw().entrySet()) {
                        String key = entry.getKey();
                        writer.write(spacing + "  " + Config.toNodeName(key) + ":" + lineSeparator);
                        Config.save(writer, annotatedElement, entry.getValue(), indent + 4);
                    }
                    continue;
                }
                Config.save(writer, annotatedElement, ((Class)annotatedElement).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), indent + 2);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static Field getField(String[] split, Object instance) {
        try {
            Field field = instance.getClass().getField(Config.toFieldName(split[split.length - 1]));
            Config.setAccessible(field);
            return field;
        }
        catch (Throwable e) {
            LOGGER.error("Invalid config field: {} for {}. It's likely you are in the process of updating from an older major release of PlotSquared. The entries named can be removed safely from the settings.yml. They are likely no longer in use, moved to a different location or have been merged with other configuration options. Check the changelog for more information.", (Object)StringMan.join(split, "."), (Object)Config.toNodeName(instance.getClass().getSimpleName()));
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object getInstance(String[] split, Class<?> root) {
        try {
            Class<?> clazz = root == null ? MethodHandles.lookup().lookupClass() : root;
            Object instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            while (split.length > 0) {
                Class<?>[] classes;
                if (split.length == 1) {
                    return instance;
                }
                Class<?> found = null;
                for (Class<?> current : classes = clazz.getDeclaredClasses()) {
                    if (!current.getSimpleName().equalsIgnoreCase(Config.toFieldName(split[0]))) continue;
                    found = current;
                    break;
                }
                try {
                    Field instanceField = clazz.getDeclaredField(Config.toFieldName(split[0]));
                    Config.setAccessible(instanceField);
                    if (instanceField.getType() != ConfigBlock.class) {
                        Object value = instanceField.get(instance);
                        if (value == null) {
                            value = found.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            instanceField.set(instance, value);
                        }
                        clazz = found;
                        instance = value;
                        split = Arrays.copyOfRange(split, 1, split.length);
                        continue;
                    }
                    ConfigBlock value = (ConfigBlock)instanceField.get(instance);
                    if (value == null) {
                        value = new ConfigBlock();
                        instanceField.set(instance, value);
                    }
                    if ((instance = value.get(split[1])) == null) {
                        instance = found.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        value.put(split[1], instance);
                    }
                    clazz = found;
                    split = Arrays.copyOfRange(split, 2, split.length);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    if (found == null) return null;
                    split = Arrays.copyOfRange(split, 1, split.length);
                    clazz = found;
                    instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    continue;
                    return null;
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    private static String toFieldName(String node) {
        return node.toUpperCase().replaceAll("-", "_");
    }

    private static String toNodeName(String field) {
        return field.toLowerCase().replace("_", "-");
    }

    private static void setAccessible(Field field) {
        field.setAccessible(true);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Final {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.TYPE})
    public static @interface Ignore {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.TYPE})
    @Documented
    public static @interface Comment {
        public String[] value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Create {
    }

    @Ignore
    public static class ConfigBlock<T> {
        private final HashMap<String, T> INSTANCES = new HashMap();

        public T get(String key) {
            return this.INSTANCES.get(key);
        }

        public void put(String key, T value) {
            this.INSTANCES.put(key, value);
        }

        public Collection<T> getInstances() {
            return this.INSTANCES.values();
        }

        private Map<String, T> getRaw() {
            return this.INSTANCES;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.TYPE})
    public static @interface BlockName {
        public String[] value();
    }
}

